/*
 * DDCDiagnostics.java
 *
 * Created on 08 January 2004, 12:55
 */

package GuiComponents.SctApi;

import javax.swing.DefaultComboBoxModel;
import GuiComponents.System.SystemInterface;

/**
 * Diagnostic access to DDC
 *
 * @author  gallop
 */
public class DdcDiagnostics extends javax.swing.JPanel {
    
    private Sct_SctApi.SctApi api;

    private String dataValue;
    
    /** Creates new form DdcDiagnostics */
    public DdcDiagnostics(Sct_SctApi.SctApi a) {
        api = a;

        initComponents();
    }

    public DdcDiagnostics() {
        initComponents();
    }

    public static void main(String [] args) {
        javax.swing.JFrame f = new javax.swing.JFrame("DDC Diag test");
        
        f.getContentPane().add(new DdcDiagnostics());
        f.pack();
        f.setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        crateValueText = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        allChannelCheck = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        channelValueText = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        stateCombo = new javax.swing.JComboBox();
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        parameterCombo = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jPanel8 = new javax.swing.JPanel();
        valueFloatText = new javax.swing.JTextField();
        valueText = new javax.swing.JTextField();
        jPanel7 = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.Y_AXIS));

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jLabel1.setText("Crate");
        jPanel2.add(jLabel1);

        crateValueText.setText("0");
        jPanel2.add(crateValueText);

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.Y_AXIS));

        allChannelCheck.setText("All Channels");
        allChannelCheck.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                allChannelsStateChanged(evt);
            }
        });

        jPanel4.add(allChannelCheck);

        jPanel5.setLayout(new javax.swing.BoxLayout(jPanel5, javax.swing.BoxLayout.X_AXIS));

        jLabel2.setText("Channel");
        jPanel5.add(jLabel2);

        channelValueText.setText("0");
        jPanel5.add(channelValueText);

        jPanel4.add(jPanel5);

        jPanel2.add(jPanel4);

        jLabel3.setText("New State");
        jPanel2.add(jLabel3);

        stateCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "ON", "OFF", "STANDBY" }));
        jPanel2.add(stateCombo);

        jPanel1.add(jPanel2);

        jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.X_AXIS));

        jButton1.setText("Perform Hard Reset");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hardResetActionPerformed(evt);
            }
        });

        jPanel3.add(jButton1);

        jButton2.setText("Change state");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changeStateActionPerformed(evt);
            }
        });

        jPanel3.add(jButton2);

        jButton3.setText("Load configuration to ELMB FLASH");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadConfigActionPerformed(evt);
            }
        });

        jPanel3.add(jButton3);

        jPanel1.add(jPanel3);

        jPanel6.setLayout(new javax.swing.BoxLayout(jPanel6, javax.swing.BoxLayout.X_AXIS));

        jLabel4.setText("Parameter");
        jPanel6.add(jLabel4);

        parameterCombo.setModel(new DefaultComboBoxModel(getParameterList()));
        jPanel6.add(parameterCombo);

        jLabel5.setText("Value");
        jPanel6.add(jLabel5);

        jPanel8.setLayout(new javax.swing.BoxLayout(jPanel8, javax.swing.BoxLayout.Y_AXIS));

        valueFloatText.setEditable(false);
        valueFloatText.setText(null);
        jPanel8.add(valueFloatText);

        valueText.setEditable(false);
        valueText.setText(null);
        jPanel8.add(valueText);

        jPanel6.add(jPanel8);

        jPanel1.add(jPanel6);

        jButton4.setText("Get channel parameter");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                channelParameterGetPerformed(evt);
            }
        });

        jPanel7.add(jButton4);

        jButton5.setText("Get card parameter");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cardParameterGetPerformed(evt);
            }
        });

        jPanel7.add(jButton5);

        jButton6.setText("Get crate parameter");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                crateParameterGetPerformed(evt);
            }
        });

        jPanel7.add(jButton6);

        jPanel1.add(jPanel7);

        add(jPanel1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void channelParameterGetPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_channelParameterGetPerformed
        System.out.println("Get channel: " + getCrateValue() + " " + getChannelValue() + " " + getParameterName());
        if(api != null) {
            String value = api.ddcGetChannelParameterString(getCrateValue(), getChannelValue(), getParameterName());
            valueText.setText(value);
            float floatValue = api.ddcGetChannelParameterFloat(getCrateValue(), getChannelValue(), getParameterName());
            valueFloatText.setText("(" + floatValue + ")");
        }
    }//GEN-LAST:event_channelParameterGetPerformed

    private void cardParameterGetPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cardParameterGetPerformed
        System.out.println("Get card: " + getCrateValue() + " " + getChannelValue() + " " + getParameterName());
        if(api != null) {
            String value = api.ddcGetCardParameterString(getCrateValue(), getChannelValue(), getParameterName());
            valueText.setText(value);
            float floatValue = api.ddcGetCardParameterFloat(getCrateValue(), getChannelValue(), getParameterName());
            valueFloatText.setText("(" + floatValue + ")");
        }
    }//GEN-LAST:event_cardParameterGetPerformed

    private void crateParameterGetPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_crateParameterGetPerformed
        System.out.println("Get crate: " + getCrateValue() + " " + getParameterName());
        if(api != null) {
            String value = api.ddcGetCrateParameterString(getCrateValue(), getParameterName());
            valueText.setText(value);
            float floatValue = api.ddcGetCrateParameterFloat(getCrateValue(), getParameterName());
            valueFloatText.setText("(" + floatValue + ")");
        }
    }//GEN-LAST:event_crateParameterGetPerformed

    private void hardResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hardResetActionPerformed
        if(allChannelCheck.isSelected()) {
            System.out.println("Hard reset all: " + getCrateValue());
            if(api != null) {
                api.ddcHardResetAll(getCrateValue());
            }
        } else {
            System.out.println("Hard reset: " + getCrateValue() + " " + getChannelValue());
            if(api != null) {
                api.ddcHardReset(getCrateValue(), getChannelValue());
            }
        }
    }//GEN-LAST:event_hardResetActionPerformed

    private void loadConfigActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadConfigActionPerformed
        System.out.println("Load configuration: " + getCrateValue() + " " + getNewState());
        if(api != null) {
            api.ddcLoadConfiguration(getCrateValue(), getNewState());
        }
    }//GEN-LAST:event_loadConfigActionPerformed

    private void changeStateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeStateActionPerformed
        short state = getNewState();

        if(state >=0 ) {
            if(allChannelCheck.isSelected()) {
                System.out.println("Change state all: " + getCrateValue() + " " + state);
                if(api != null) {
                    api.ddcChangeStateAll(getCrateValue(), state);
                }
            } else {
                System.out.println("Change state: " + getCrateValue() + " " + getChannelValue() + " " + state);
                if(api != null) {
                    api.ddcChangeState(getCrateValue(), getChannelValue(), state);
                }
            }
        }
    }//GEN-LAST:event_changeStateActionPerformed

    private void allChannelsStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_allChannelsStateChanged
        channelValueText.setEnabled(!((javax.swing.JCheckBox)evt.getSource()).getModel().isSelected());
    }//GEN-LAST:event_allChannelsStateChanged

    String getDataValue() {
        return dataValue;
    }    
    
    int getCrateValue() {
        return Long.decode(crateValueText.getText()).intValue();
    }

    short getNewState() {
        short state = -1;

        if(stateCombo.getSelectedItem().equals("ON")) {
            state = 1;
        } else if(stateCombo.getSelectedItem().equals("OFF")) {
            state = 0;
        } else if(stateCombo.getSelectedItem().equals("STANDBY")) {
            state = 2;
        } else {
            // Some strange value
            System.out.println("Strange state " + stateCombo.getSelectedItem());
            state = -1;
        }

        return state;
    }

    int getChannelValue() {
        return Long.decode(channelValueText.getText()).intValue();
    }

    String getParameterName() {
        return (String)parameterCombo.getSelectedItem();
    }
    
    public String[] getParameterList() {
        SystemInterface sys = SystemInterface.getInstance();
        sctConf.Configuration conf = sys.getConfigurationService();
        try {
            String[] channel = conf.listDCSChannelParams();
            String[] card = conf.listDCSCardParams();
            String[] crate = conf.listDCSCrateParams();
            String[] result = new String[channel.length + card.length + crate.length];
            for(int i=0; i<channel.length; i++) {
                result[i] = channel[i];
            }
            for(int i=0; i<card.length; i++) {
                result[i + channel.length] = card[i];
            }
            for(int i=0; i<crate.length; i++) {
                result[i + channel.length + card.length] = crate[i];
            }
            return result;
        } catch(sctConf.ConfigurationException e) {
            String [] defaults = {"LVch_Vcc"};

            return defaults;
        }
    }    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox allChannelCheck;
    private javax.swing.JTextField channelValueText;
    private javax.swing.JTextField crateValueText;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JComboBox parameterCombo;
    private javax.swing.JComboBox stateCombo;
    private javax.swing.JTextField valueFloatText;
    private javax.swing.JTextField valueText;
    // End of variables declaration//GEN-END:variables
    
}
