package GuiComponents.Panels;

import sctConf.*;
import ipc.*;

import GuiComponents.SctConf.*;
import GuiComponents.System.*;

import java.util.Enumeration;
import java.util.Vector;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;

import org.omg.CORBA.IntHolder;

public class SctConfGui extends JPanel {
    private sctConf.Configuration config;

//     final private SctConfigGui finalGui;

    public static void main(String args[]) {
        System.out.println("Hello world");

        JFrame frame = new JFrame("Configuration GUI");
        frame.getContentPane().add(new SctConfGui());

//         frame.addWindowListener(new WindowAdapter() {
//             public void windowClosing(WindowEvent e) {
//                 System.exit(0);
//             }
//         });  

        frame.pack();
        frame.setVisible(true);
    }

    public SctConfGui() {
//         finalGui = this;

        connectServer();

	if (config==null) {
	    System.err.println("Error (check configuration running)");
	    System.exit(0);
	}
        System.out.println("Found configuration");

        setLayout(new BorderLayout());

        JPanel buttons = new JPanel();

        JButton close = new JButton("Exit");
        close.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    System.exit(1);
//                     ((Window)getTopLevelAncestor()).dispose();
                }
            });
        buttons.add(close);

        JButton myTreeView = new JButton("Tree View");
        myTreeView.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    JFrame frame = new JFrame("Tree view");
                    if(config == null) {
                        connectServer();
                    }
                    frame.getContentPane().add(new TreeView(new Proxies(config), config));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        buttons.add(myTreeView);

        JButton moduleListView = new JButton("Module List");
        moduleListView.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    JFrame frame = new JFrame("Module list");
                    if(config == null) {
                        connectServer();
                    }
                    frame.getContentPane().add(new ModuleListView(config));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        buttons.add(moduleListView);

//         JButton power = new JButton("Power mappings");
//         power.addActionListener(new ActionListener() {
//                 public void actionPerformed(ActionEvent e) {
//                     JFrame frame = new JFrame("Power Mappings");
//                     if(config == null) {
//                         connectServer();
//                     }
//                     frame.getContentPane().add(new PowerMappings(config));

//                     frame.addWindowListener(new WindowAdapter() {
//                             public void windowClosing(WindowEvent e) {
//                                 e.getWindow().dispose();
//                             }
//                         });
//                     frame.pack();
//                     frame.setVisible(true);
//                 }
//             });
//         buttons.add(power);

        JButton physic = new JButton("View Physical");
        physic.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    JFrame frame = new JFrame("Physical view");
                    if(config == null) {
                        connectServer();
                    }
                    frame.getContentPane().add(new PhysicalView(config));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        buttons.add(physic);

        JButton shutdown = new JButton("Shutdown server");
        shutdown.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        System.out.println("Dump configuration");
                        config.saveConfiguration("Shutdown_Dump_From_ConfigGUI.xml");
                        System.out.println("Done");
                    } catch(ConfigurationException c) {
                        System.out.println("Shutdown xml dump failed");
                    } catch(Exception ex) {
                        // Exit whatever happens
                    }
                    try {
                        config.destroy();
                    } catch(Exception ex) {
                        // Exit whatever happens
                    }
//                     ((Window)getTopLevelAncestor()).dispose();
                    System.exit(0);
                }
            });
        buttons.add(shutdown);

        JButton saveConf = new JButton("Save configuration");
        saveConf.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        System.out.println("Saving configuration to Dump_From_ConfigGUI.xml");
                        config.saveConfiguration("Dump_From_ConfigGUI.xml");
                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "Save configuration failed!");
                    }
                }
            });
        buttons.add(saveConf);

        JButton loadConf = new JButton("Reload configuration");
        loadConf.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        config.loadConfiguration("");
                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "Load configuration failed!");
                    }
                }
            });
        buttons.add(loadConf);

        JButton reconnect = new JButton("Reconnect");
        reconnect.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    connectServer();
                }
            });
        buttons.add(reconnect);

        add(buttons, BorderLayout.SOUTH);

        System.out.println("Set up GUI, wait for it to run");
    }

    public void connectServer() {
        SystemInterface sys = SystemInterface.getInstance();
        // If config server lost then need to reconnect
        sys.refresh();
        config = sys.getConfigurationService();
    }
}
