#ifndef ROOTFITSTRATEGY_H
#define ROOTFITSTRATEGY_H
#include "FitStrategy.h"

using namespace Sct;
namespace SctFitter{
    /**
       Concrete fit strategy uses ROOT's usual hist.fit() function.
       @author Alan Barr
       @date 16/5/03
     */

    class RootFitStrategy : public FitStrategy {
    public:
	/// constuctor
	RootFitStrategy(string opt=string("")) throw();
	/// destructor
	~RootFitStrategy() throw();
	/// fit TH1
	virtual void fitTH1(const TH1& hist, TF1& fit) const throw(LogicError, MathsError);
	/// fit TGraph
	virtual void fitTGraph(const TGraph& graph, TF1& fit) const throw(LogicError, MathsError);
	/// fit TGraphErrors
	virtual void fitTGraphErrors(const TGraphErrors& graph, TF1& fit) const throw(LogicError, MathsError);
	
	/// over-ride
	virtual const string& getName() const throw();
    private:
	RootFitStrategy( const RootFitStrategy& ); ///< no copy constructor
	const string name; ///< the name of the strategy
	static bool inMap; ///< dummy variable used at static initialization.
    };
    
} // end of namespace SctFitter;
#endif // #ifndef ROOTFITSTRATEGY_H
