#include "FitterWorkerGroup.h"
#include "Fitter.h"
#include "FitAlgorithm.h"
#include "FitAlgorithmMap.h"

#include "Sct/SctNames.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/ISProxy/IOManagerISProxy.h"
#include "Sct/IS/IONameIS.h"
#include "SctData/FitScanResult.h"
#include "SctData/RawScanResult.h"
#include "Sct/StdExceptionWrapper.h"
#include "ScanResultWriter/dataTypes.h"
#include <boost/timer.hpp>

using namespace std;
using namespace SctService;
using boost::shared_ptr;
using boost::timer;
using namespace SctData;
using namespace Sct;
using namespace Sct::IS;

namespace SctFitter {


void FitterWorkerGroup::work(string name) throw() {
    using namespace SctData;
    timer t;
    
    try {
        shared_ptr<const Serializable> ob ( IOManagerIS::instance().read(name) );
        shared_ptr<const RawScanResult> raw = dynamic_pointer_cast<const RawScanResult>(ob);
        if (!raw)
            throw InvalidArgumentError("Fitter::work(): Not a RawScanResult", __FILE__, __LINE__);
	Fitter::instance().addIOTime(t.elapsed());
	t.restart();
	
        // make a cache of the name of this scan:
        Fitter::instance().setLastScanName(raw->getUniqueID().c_str() );
        Fitter::instance().incrementFitsDone();
        m_calls++;

        std::cout << "This is call number  " << m_calls << " to this worker. Working on " << raw->getUniqueID().c_str() << " Q = "<< queueSize()<< std::endl;

	// dont fit RawRawData ("direct from BOC")
	if (raw->getDataType()==SR_DT_RAWHIST) return;

        const FitAlgorithm& alg = FitAlgorithmMap::instance().getAlgorithm((*raw).getHeader().getVariable());
        std::auto_ptr<SctData::FitScanResult> fitted = alg.doFit(*raw);

	Fitter::instance().scanDone(t.elapsed());
	t.restart();
	
        //Publish object
        Sct::IS::IOParamsIS params(Sct::SctNames::getFittedDataName());
        Sct::ISProxy::IOManagerISProxy::instance().write(*fitted, &params);	
	Fitter::instance().addIOTime(t.elapsed());
    } catch (Sct::InvalidArgumentError& e) {
        e.sendToMrs();
        Fitter::instance().incrementFitErrors();
    } catch(Sct::Throwable& e) {
        e.sendToMrs(MRS_ERROR);
        Fitter::instance().incrementFitErrors();
    } catch(std::exception& e) {
	StdExceptionWrapper sew(e);
        sew.sendToMrs(MRS_ERROR);
        Fitter::instance().incrementFitErrors();	
    } catch(...) {
	Error e("uncaught unknown exception", __FILE__, __LINE__);
	e.sendToMrs(MRS_ERROR);
	Fitter::instance().incrementFitErrors();	
    }    
}

}// end of namespace SctFitter
