#ifndef FITALGORITHMMAP_H
#define FITALGORITHMMAP_H

#include <string>
#include <map>
#include <memory>
#include <boost/utility.hpp>
#include <boost/shared_ptr.hpp>
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

namespace SctData {
class ConfigurationVariable;
}

using namespace std;
using namespace boost;
using SctData::ConfigurationVariable;

namespace SctFitter {
 
class FitAlgorithm;    
    
/**
  FitAlgorithmMap is a mapping between ConfigurationVariables and FitAlgorithms.
  The Fitter uses the map to determine which FitAlgorithm to ask to create the FitScanResult object.
  The Map is of course a singleton.
  @todo Add an iterator for this class
  @todo Make this thread-safe
  @author Matthew Palmer
  @date 8 June 2003
  */
class FitAlgorithmMap : boost::noncopyable {
public:
    /**
      Get the instance of the Map.
      */
    static FitAlgorithmMap& instance();
    
    /**
      Get the algorithm associated with the given variable
      @throws InvalidArgument if there is no FitAlgorithm for variable
      */
    const FitAlgorithm& getAlgorithm(const ConfigurationVariable& variable) const throw(Sct::InvalidArgument);
    
    /**
      Sets the algorithm for ConfigurationVariables with variableName to 
      the given FitAlgorithm.  Note that auto_ptr is used to denote object transfer
      @return true if the mapping was successful
      @todo Think: Should this return a ptr to the previous alg?
      */
    bool setAlgorithm(string variableName, auto_ptr<FitAlgorithm>) throw();
    
private:
    FitAlgorithmMap() {}
    map<string, shared_ptr<FitAlgorithm> > algMap;
};
    
    
}

#endif //FITALGORITHMMAP_H
