#include "../src/ipc/Sct_CalibrationController.hh"

#include <ipc/object.h>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <ilu/iluxport.h>

using namespace std;


class TestSequenceRequest : public IPCCallback, public Sct_CalibrationController_T_SequenceRequest {
public:
    TestSequenceRequest(IPCServer& server, IPCObjectVar<Sct_CalibrationController_T_CalibrationController>& cc) : IPCCallback(&server) {
	this->cc = cc;
	
	Sct_CalibrationControllerStatus status;
	ilu_DebugPrintf("%s", "\n\nAbout to call getTestLibrary\n\n");
	Sct_CalibrationController_T_TestLibrary* tl = cc->getTestLibrary(&status);
	responseCurve = tl->responseCurve(&status);	
    }
    
    virtual ilu_T_CString startSequence (Sct_CalibrationControllerStatus *_status, Sct_CalibrationController_T_CalibrationController * cc, Sct_SctApi_T_SctApi * api) {
	cout << "startSequence" << endl;
	cout << "CalibrationController: " << cc << endl;
	this->cc = cc;
	this->api = api;
	char* name = new char[20];
	strcpy(name, "TestSequenceRequest");
	//this->cc->incRef();
	cout << "startSequence finished" << endl;
	return name;
    }
    
    virtual Sct_CalibrationController_T_TestRequest * getNextTest (Sct_CalibrationControllerStatus *_status, ilu_Cardinal index) {	
	cout << "getNextTest " << index << endl;
	cout << "CalibrationController: " << cc << endl;
	
	//ilu_DebugPrintf("%s", "\n\nAbout to call getTestLibrary\n\n");
	//Sct_CalibrationController_T_TestLibrary* tl = cc->getTestLibrary(&status);
	//cout << "TestLibrary: " << tl << "  " << status.returnCode << endl;
	switch (index) {
	case 0:
	    return responseCurve;//tl->responseCurve(&status);
	default:
	    cout << "Return 0" << endl;
	    return 0;
	}	
    }
    
    virtual ilu_Boolean applyConfigChanges (Sct_CalibrationControllerStatus *_status, ilu_Cardinal index) {
	cout << "applyConfigChanges " << index << endl;	
	return false;
    }
    
    virtual void endSequence (Sct_CalibrationControllerStatus *_status) {
	//cc = 0;
	api = 0;
	cout << "endSequence" << endl;
	delete this;
    }
    

private:
    IPCObjectVar<Sct_CalibrationController_T_CalibrationController> cc;
    Sct_SctApi_T_SctApi* api;
    Sct_CalibrationController_T_TestRequest* responseCurve;
};

void testRequest(void* server) {
    IPCPartition p("SCT");
    IPCObjectVar<Sct_CalibrationController_T_CalibrationController> cc = p.lookup(Sct_CalibrationController_C_CalibrationController_serverName, Sct_CalibrationController_C_CalibrationController_instanceName, Sct_CalibrationController_T_CalibrationController::ILUClassRecord, true);
    cout << "Got handle? " << cc << endl;
    
    TestSequenceRequest* tsr = new TestSequenceRequest(*(IPCServer*)server, cc);    
    
    Sct_CalibrationControllerStatus status;
    status.returnCode = 0;

    ilu_DebugPrintf("%s", "\n\n\n\nAbout to call doSequence\n\n");	
    cc->doSequence(&status, tsr);
    cout << "doSequence? " << status.returnCode << endl;
}

int main(int argc, char** argv) {
    IPCCore::init(false);
    ilu_SetDebugLevelViaString("MOST");
    ilu_SendDebugOutputToFile("TestCalibrationControllerILU.out");

    IPCPartition p("SCT");
    {
    IPCObjectVar<Sct_CalibrationController_T_CalibrationController> cc = p.lookup(Sct_CalibrationController_C_CalibrationController_serverName, Sct_CalibrationController_C_CalibrationController_instanceName, Sct_CalibrationController_T_CalibrationController::ILUClassRecord, true);

    cout << "Got handle? " << cc << endl;
    Sct_CalibrationControllerStatus status;
    status.returnCode = 0;
    
    //IPCObjectVar<Sct_CalibrationController_T_SequenceLibrary> lib = cc->getSequenceLibrary(&status);
    //cout << "Got library? " <<  status.returnCode << "   " << lib << endl;
    //IPCObjectVar<Sct_CalibrationController_T_SequenceRequest> req = lib->characterizationSequence(&status);
    //cout << "Got request? " << status.returnCode << "   " << req << endl;
    //time_t start = time(0);
    //cc->doSequence(&status, req);
    //cout << "TestSequence requested " << status.returnCode << endl;
    //time_t now = time(0);
    //cout << difftime(now, start) << " seconds to return" << endl;
    //cc->doSequence(&status, cc->getSequenceLibrary(&status)->characterizationSequence(&status));
    cout << "SequenceLibrary: " << cc->getSequenceLibrary(&status) << "  " << status.returnCode << endl;
    cout << "TestLibrary: " << cc->getTestLibrary(&status) << "  " << status.returnCode << endl;
    cout << "ScanLibrary: " << cc->getScanLibrary(&status) << "  " << status.returnCode << endl;
    }
    //cout << "Did that work?? " << status.returnCode << endl;
    
    
    //Now try the request:
    IPCServer server(0, p);
    server.doSoon(testRequest, &server);
    server.run();
    cout << "Finished" << endl;
}
