#ifndef DEFAULTTEST_H
#define DEFAULTTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/ScanRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/Sct_CalibrationController.hh"
#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace SctCalibrationController::Ipc;

namespace SctCalibrationController {
namespace Scripts {
    
class DefaultTest : public TestRequest {
public:	
    DefaultTest(shared_ptr<ScanRequest> scan) : scan(scan) {}
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {
	name = "DefaultTest";
	testVariable = ST_ELAPSED;
	nScans = 1;
	testPoints.push_back(0);
    }
    
    virtual ScanRequest* getNextScan(unsigned long index) {
	if (index == 0) return scan.get();
	return 0;
    }
    
    virtual bool canFeedback() {
	return false;
    }
    
    virtual void endTest() {}
    
private:
    shared_ptr<ScanRequest> scan;
};
}
}
#endif //DEFAULTTEST_H
