#ifndef SCTCALIBRATIONCONTROLLER_SCTAPICALL_H
#define SCTCALIBRATIONCONTROLLER_SCTAPICALL_H

#include "SctApiException.h"
#include "SctApiAccessException.h"

#ifndef __Sct_SctApi_H_
#include "Sct_SctApi/Sct_SctApi.hh"
#endif

namespace SctCalibrationController {

/**
Defines a useful macro for calling SctApi
Throws SctApiAccessException if there is a problem with the call
and InvalidArgumentError if the api is a null pointer
The call should take &st as its first argument
Incidentally, this is a poor replacement for a proper wrapper that I couldn't
be bothered to write.
*/

inline void raiseSctApiException(ilu_Exception exception, const char* text, const char* file, unsigned int line) {
    if (exception == Sct_SctApi_E_SctApiException)
        throw SctApiException(exception, text, file, line);
    throw SctApiAccessException(exception, text, file, line);
}

#define APICALL( api, call, errorText ) { \
    if (!api) throw InvalidArgumentError("Null pointer to SctApi", __FILE__, __LINE__); \
    Sct_SctApiStatus st; \
    (api)->call; \
    if (st.returnCode != 0) raiseSctApiException(st.returnCode, errorText, __FILE__, __LINE__);\
}


#define APIRETCALL( api, ret, call, errorText ) { \
    if (!api) throw InvalidArgumentError("Null pointer to SctApi", __FILE__, __LINE__); \
    Sct_SctApiStatus st; \
    ret=(api)->call; \
    if (st.returnCode != 0) \
        raiseSctApiException(st.returnCode, errorText, __FILE__, __LINE__); }
}

#endif //SCTCALIBRATIONCONTROLLER_SCTAPICALL_H
