#ifdef linux
#undef linux
#endif

#include "SctApiCall.h"
#include "RunController.h"
#include "SctApiAccessException.h"
#include "CalibrationControllerImpl.h"
#include "ipc/CalibrationController.h"
#include "Sct/SctNames.h"
#include "Sct/Exception.h"
#include "Sct/LogicErrors.h"
#include <rc/RunParamsInfo.h>
#include <ipc/partition.h>
#include <is/isinfo.h>
#include <iostream>
#include <fstream>
#include <ilu/iluxport.h>

using namespace std;
using namespace Sct;

int main(int argc, char** argv) {
    using namespace SctCalibrationController;
   
    cout << "Starting Calibration controller" << endl;
    setExceptionHandlers(argv[0]);
    
    IPCCore::init(true);
    //IPCPartition p("SCT");
    
    RunControl& rc = RunControl::instance();
    cout << "Instance created" << endl;
        
    rc.rc_start("CalibrationController", "SCT");
    cout << "All over" << endl;

    return 0;
}

namespace SctCalibrationController {
    
RunControl::RunControl() : cc (CalibrationControllerImpl::initialize(*this)) {	
}
    
RunControl& RunControl::instance() {
    static RunControl rc;
    return rc;
}


int RunControl::loadaction () {
    cout << "Loadaction" << endl;
    api = (Sct_SctApi_T_SctApi*)ipcPartition().lookup(Sct_SctApi_C_SctApi_serverName, Sct_SctApi_C_SctApi_instanceName, Sct_SctApi_T_SctApi::ILUClassRecord);
    if (!api) {
	SctNames::Mrs() << "RC_INIT" << MRS_TEXT("RunController failed to find SctApi") << MRS_ERROR << ENDM;
	return 1;
    }
    cc.setApi(*api);
    try {
        APICALL(api, initialiseAll(&st, 0), "SctApi failed to initialiseAll")
    } catch(SctApiAccessException& e) {
        e.sendToMrs(MRS_ERROR);
        return 1;
    }

    return 0;
}

int RunControl::configaction() {
    try {
        APICALL(api, configureAllModules(&st), "SctApi failed to configureAllModules")
    } catch(SctApiAccessException& e) {
        e.sendToMrs(MRS_ERROR);
        return 1;
    }

    return 0;
}

int RunControl::startaction() {
    if (!api) {
	cout << "Can't enter running as we don't have the api" << endl;
	return 2;
    }
    cout << "enter Running"  << endl;

    ///@todo Check status
    RunParamsInfo runParams;
    ISInfoDictionary& is = SctNames::getISDictionary();
    ISInfo::Status isStatus;

    isStatus = is.findValue("RunParams.RunParams", runParams);

    try {
        APICALL(api, setRunNumber(&st, runParams.run_number), "Failed to set run number")
        APICALL(api, setScanNumber(&st, 0), "Failed to set scan number")
        cout << "New Run, setting run number and scan number: " << runParams.run_number << "  " << 0 << endl;
        cc.takeControl(runParams.run_number);
    } catch (SctApiAccessException& e) {
        e.sendToMrs(MRS_ERROR);
        return 1;
    }

    return 0;
}

void RunControl::exitRunning() {
    cout << "exit Running" << endl;
    cc.giveupControl();
}

int RunControl::unloadaction () {
    cout << "unloadaction" << endl;

    try {
        APICALL(api, shutdownAll(&st), "Could not shutdown all")
    } catch (SctApiAccessException& e) {
        e.sendToMrs(MRS_ERROR);
        return 1;
    }
    cc.reset();

    return 0;
}

int RunControl::resetaction () {
    cc.reset();
    return 0;
}

void RunControl::sctApiError(ErrorState state, const string& reason) {
    this->setError(state, reason);
    cc.giveupControl();
}

}
