#include "Zlib_Test.h"
#include "../ZlibStringCompressor.h"
#include "../ZlibException.h"
#include <fstream>
#include <iostream>
#include <sys/stat.h>

namespace SctArchiving{
  string getSomeData(){
    BOOST_CHECK(system("ls -l > data")==0 );
    char* file_name="data";

    std::ifstream In (file_name,std::ios::in | std::ios::binary); 
    struct stat for_len; 
    BOOST_CHECK((In.rdbuf())->is_open());
    BOOST_CHECK(stat(file_name,&for_len)!=-1); 
    unsigned int blen = for_len.st_size;
    BOOST_CHECK(blen);
    char  *read_buffer = new char[blen];    
    In.read(read_buffer,blen); 
    string data(read_buffer,blen);
    return data;
  }

  string getOddData(){
    std::ostringstream oss;
    for (unsigned i=0; i<1000000; ++i){
      oss << "A";
    }
    return oss.str();
  }

  void checkStringCompressor(ZlibStringCompressor& comp, const string& s, int level, bool resetBuffer=false){
    const string myorig = s;
    const string mycompress = comp.compress(myorig, level);
    if (resetBuffer) comp.setBufferSize(0);
    const string myinflate = comp.inflate(mycompress);
    
    BOOST_CHECK_EQUAL(myinflate.size(), myorig.size());
    BOOST_CHECK_EQUAL(myinflate,myorig);
  }

  void checkStringCompressor(){
    ZlibStringCompressor compressor(0);
    compressor.setDebugLevel(0);
    const int level=5;
    checkStringCompressor(compressor, getSomeData(), level);
    checkStringCompressor(compressor, getOddData(), level);
    checkStringCompressor(compressor, getSomeData(), level, true);
    checkStringCompressor(compressor, getOddData(), level, true);    
  }


  void keepRedoubling(){
    ZlibStringCompressor compressor(10000);
    while(true){
      compressor.setBufferSize(compressor.getBufferSize()*10);
    }
  }

  void checkBufferAllocate(){
    BOOST_CHECK_THROW(keepRedoubling(), ZlibException);
  }
  
  Zlib_Test::Zlib_Test(){
    add (BOOST_TEST_CASE(&checkStringCompressor));
    add (BOOST_TEST_CASE(&checkBufferAllocate));
  }
}
