#ifndef SCT_ARCHIVEFILE_IOMANAGERARCHIVEFILE_H
#define SCT_ARCHIVEFILE_IOMANAGERARCHIVEFILE_H

#include "Sct/Archive/IOManagerArchive.h"
#include "Sct/IoExceptions.h"
#include "Sct/LogicErrors.h"
#include "SctData/ResultHeader.h"

class Sct::Serializable;
class MysqlConnection;
class MysqlQuery;

namespace SctArchiving {
class ZlibStringCompressor;
  /**
     This IOManager reads from and writes to a database.
     It is expected to be used in archival, and so also makes use of streamer 
     versioning by inheriting from IOManagerStreamerVersioned.
     Uses a <A HREF="http://www.mysql.com">mysql</a> back-end.
   */
class IOManagerDB : public Sct::Archive::IOManagerArchive {
public:
  /** retrieve access to singleton */
  static IOManagerDB& instance();
  /** write using default streamers */
  virtual void write(const Sct::Serializable& ob, const Sct::IOParams* params = 0) const;
  /** read using appropriate streamers */
  virtual shared_ptr<Sct::Serializable> read(const string& name, const Sct::IOParams* params = 0) const;
  virtual ~IOManagerDB();
  /** get some status information */
  virtual std::string status() const;
 private:
  IOManagerDB();  ///< constructor.
  MysqlQuery getQuery() const; ///< get a null query.
  static IOManagerDB* s_man; ///< pointer to singleton
  /**
     keep a string compressor handy to zip and unzip BLOB data.
  */
  boost::shared_ptr<ZlibStringCompressor> m_compressor;
  boost::shared_ptr<MysqlConnection> m_connection; ///< pointer to the database connection
  /**
     get the header from a TestResult or ScanResult
  */
  static const SctData::ResultHeader& getHeader( const Sct::Serializable& ob);
  /**
     change query to prepare to insert ob.
  */
  void prepareInsertion(const Sct::Serializable& ob, MysqlQuery& q) const;
  /**
     make the "`WHERE'" part of the query matching the name by building a 
     IOName from it.
  */
  static std::string getQueryMatching(const string& name);
  /**
     find the name of the table which the ob should to into.
   */
  static std::string getTable(const Sct::Serializable& ob);
};
}
#endif //SCT_ARCHIVEFILE_IOMANAGERARCHIVEFILE_H
