#ifndef SCTARCHIVING_GETCOMMAND_H
#define  SCTARCHIVING_GETCOMMAND_H
#include "Sct/Serializable.h"
#include "ArchivingCommand.h"
#include "Sct/IOName.h"

namespace SctArchiving{
  /**
     Command which retrieves an object from somewhere!
     After execute() getObject() should return the object.
  */
  class GetCommand : public ArchivingCommand {
  public:
    /** constructor with name of object to get */
    GetCommand(boost::shared_ptr<Sct::IOName> name);
    /** destructor */
    ~GetCommand() {}
    /** valid after execute() */
    virtual shared_ptr<Sct::Serializable> getObject() const;
    /** get the IOName */
    const Sct::IOName& getIOName() const;
    /** copy */
    ArchivingCommand& operator=(const ArchivingCommand& copyme);
    /** setName */
    virtual void setName(boost::shared_ptr<Sct::IOName> name);
  protected:
    boost::shared_ptr<Sct::IOName> m_name; ///< cache of name to execute
    boost::shared_ptr<Sct::Serializable> m_ob; ///< zero until after execute()
    GetCommand(){}
  };

  inline GetCommand::GetCommand(boost::shared_ptr<Sct::IOName> name)
    : m_name(name)
    {}

  inline boost::shared_ptr<Sct::Serializable> GetCommand::getObject() const {
    return m_ob;
  }
  
  inline const Sct::IOName& GetCommand::getIOName() const {
    if (!m_name.get()) throw Sct::IllegalStateError("NoName!", __FILE__, __LINE__);
    return *m_name;
  }
  
  inline void GetCommand::setName(boost::shared_ptr<Sct::IOName> name){
    m_name=name;
  }
}

#endif
