#ifndef SCTARCHIVING_ARCHIVEPUTCOMMAND_H
#define  SCTARCHIVING_ARCHIVEPUTCOMMAND_H
#include "PutCommand.h"

namespace SctArchiving{
  /** PutCommand to put an object in the archive.
   * Uses the Sct::Archive::IOManagerArchive kept by
   * the Archiver::instance() to write */
  class ArchivePutCommand : public PutCommand{
  public:
    /** Puts object in archive */
    ArchivePutCommand(boost::shared_ptr<Sct::Serializable> ob);
    /** destructor */
    ~ArchivePutCommand();
    /** puts the object from the archive */
    virtual void execute();
    /** constructor which requires setObject before execute() */
    ArchivePutCommand();
    /** */
    virtual boost::shared_ptr<ArchivingCommand> create() const;
  };
}

#endif
