#ifndef RXDELAYALGORITHM_H
#define RXDELAYALGORITHM_H
#include "AnalysisAlgorithm.h"

namespace SctData {
    class RxDelayTestResult;
    class FitScanResult;
}

namespace SctAnalysis {
    /**
       Algorithm for single-scan Rx-Delay Test.
       Uses a single FitScanResult to find the optimum value of the strobe delay.
    */
class RxDelayAlgorithm : public AnalysisAlgorithm {
public:        
    /** 
	finds the optimum - a fractions of the way from the mid-rise to the mid-fall of the 
	function.
     */
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();    
    /** 
	constructor 
     */
    RxDelayAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~RxDelayAlgorithm() throw() {}
private:
    RxDelayAlgorithm() {}
    static bool inMap;    
};
}
#endif //#ifndef RXDELAYALGORITHM_H
