#ifndef FULLBYPASSALGORITHM_H
#define FULLBYPASSALGORITHM_H

#include "AnalysisAlgorithm.h"

namespace SctAnalysis {
    /**
       Algorithm for FullBypass Test.
    */
class FullBypassAlgorithm : public AnalysisAlgorithm {
public:
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();
    /** 
	constructor 
     */
    FullBypassAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~FullBypassAlgorithm() throw() {}

    /** 
	set the nominal value of the digital voltage 
    */
    static void setVddNom(float value) {s_vddNominal=value;}
    /** 
	get the nominal value of the digital voltage.
    */
    static float getVddNom() {return s_vddNominal;}
private:
    FullBypassAlgorithm();
    static bool inMap;
    static unsigned getConf(const unsigned int conf);

    ///@throw IllegalStateError if no configuration matches token
    static unsigned getConfNo(const unsigned token);
    static unsigned sumFib(const unsigned int n);
    /// nominal digital voltage level. 
    static float s_vddNominal;
};
}

#endif //FULLBYPASSALGORITHM_H
