#This is an example setup script for both building from source and running the
#binary release.  

###############################
#Required variables for running
###############################


###### External Software ######

#Change this if you use gcc295
export CMTCONFIG=i686-rh73-gcc32


# Initialise the online software
export TDAQ_JAVA_HOME=/usr/local/j2sdk1.4.1_02 #Or set JAVA_HOME instead
export PATH=${TDAQ_JAVA_HOME}/bin:${PATH}
source /usr/local/atlas/tdaq/cmt/online-00-19-01/installed/setup.sh

# Fix online software for version 2.96 - only necessary if you insist on using unsupported compilers!
test `gcc -dumpversion` = "2.96" && export LD_LIBRARY_PATH=`echo -n $LD_LIBRARY_PATH | tr ':' "\012" | grep -e external -v | tr "\012" ":"`

# Setup the DataFlow software
export DF_INST_PATH=/usr/local/atlas/tdaq/DataFlow/DF-00-04-02/installed
export PATH=${DF_INST_PATH}/${CMTCONFIG}/bin:${DF_INST_PATH}/share/bin:${PATH}
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${DF_INST_PATH}/${CMTCONFIG}/lib

# Setup the PVSS libraries - may not be necessary
export PVSS_PATH=/usr/local/atlas/tdaq/dcs/pvss2_v2.12
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${PVSS_PATH}/bin
export PATH=${PATH}:${PVSS_PATH}/bin

#Setup ROOT
export ROOTSYS=/usr/local/atlas/root
export PATH=${ROOTSYS}/bin:${PATH}
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${ROOTSYS}/lib


######## Our Software #########

# The following should set SCT_DAQ_ROOT to the directory this script is run from
export SCT_DAQ_ROOT=/usr/local/atlas/SctRodDaq

#Set this to your rod configuration (or nothing for the test setup)
export SCTDAQ_ROD_CONFIGURATION_PATH=${SCT_DAQ_ROOT}/sctConf/newRod.xml

#Only necessary if you share your online software installation
export IPC_REF_FILE=${SCT_DAQ_ROOT}/ipc.ref.file

# Directory to put IS proxy files
export SCT_SCRATCH_DIR=${SCT_DAQ_ROOT}/scratch


################################
#Required variables for building
################################

# Point to external programs 
export BOOSTDIR=${SCT_DAQ_ROOT}/boost/boost_1_30_0
export NAGDIR=${SCT_DAQ_ROOT}/Nag_C

export PATH=${PATH}:${ROOTSYS}/bin
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${ROOTSYS}/lib

# Point to external java jar files
export SCT_DAQ_EXT=${SCT_DAQ_ROOT}/ext

#####################################
#And finally, source the setup script
#####################################
source setup.sh
