#include <iostream>
using namespace std;

#include <ctype.h>

#include "RodModule.h"
#include "primParams.h"
#include "RCCVmeInterface.h"
#include "parameters.h"

int main() {

using namespace SctPixelRod;

  unsigned long mdspPrimBuff, mdspReplyBuff;
  unsigned long slvPrimBuff, slvReplyBuff;
  unsigned long mdspErrBuff, mdspInfoBuff, mdspDiagBuff, mdspXferBuff;
  unsigned long slvErrBuff, slvInfoBuff, slvDiagBuff, slvXferBuff;
  unsigned long mdspHpic, mdspHpia, mdspAuto, mdspNoAuto;  
  unsigned long slvHpic[4], slvHpia[4], slvAuto[4], slvNoAuto[4];
  unsigned long mdspStatusReg[3], mdspCmdReg[2];
  unsigned long slvStatusReg[3], slvCmdReg[2];
  
  hex(cout);
  cout << endl << endl;
  cout << "DSP ADDRESS LIST - All addresses are in hexadecimal" << endl << endl;
  cout << "                        MDSP            SDSP" << endl;
  mdspPrimBuff = PRIM_BUFF_BASE;
  slvPrimBuff = SLAVE_PRIM_BUFF_BASE;
  cout << "PRIM_BUFF          ";
  cout.width(8);  cout << mdspPrimBuff << "/MDSP    ";
  cout.width(8);  cout << slvPrimBuff << "/SDSP" << endl;
  mdspReplyBuff = REPLY_BUFF_BASE;
  slvReplyBuff = SLAVE_REPLY_BUFF_BASE;
  cout << "REPLY_BUFF         ";
  cout.width(8); cout << mdspReplyBuff << "/MDSP    "; 
  cout.width(8); cout << slvReplyBuff << "/SDSP" << endl;
  cout << endl;
  
  mdspErrBuff = ERR_BUFF_BASE;
  slvErrBuff = ERR_BUFF_BASE;
  mdspInfoBuff = INFO_BUFF_BASE;
  slvInfoBuff = INFO_BUFF_BASE;
  mdspDiagBuff = DIAG_BUFF_BASE;
  slvDiagBuff = DIAG_BUFF_BASE;
  mdspXferBuff = XFER_BUFF_BASE;
  slvXferBuff = XFER_BUFF_BASE;
  cout << "ERR_BUFF           ";
  cout.width(8); cout << mdspErrBuff << "/MDSP    "; 
  cout.width(8); cout << slvErrBuff << "/SDSP" << endl;
  cout << "INFO_BUFF          ";
  cout.width(8); cout << mdspInfoBuff << "/MDSP    "; 
  cout.width(8); cout << slvInfoBuff << "/SDSP" << endl;
  cout << "DIAG_BUFF          ";
  cout.width(8); cout << mdspDiagBuff << "/MDSP    "; 
  cout.width(8); cout << slvDiagBuff << "/SDSP" << endl;
  cout << "XFER_BUFF          ";
  cout.width(8); cout << mdspXferBuff << "/MDSP    "; 
  cout.width(8); cout << slvXferBuff << "/SDSP" << endl;
  cout << endl;
  
  mdspHpic = HPIC;
  mdspHpia = HPIA;
  mdspAuto = HPID_AUTO;
  mdspNoAuto = HPID_NOAUTO;
  for (int i = 0; i<4; i++) {
    slvHpic[i] = SLAVE_HPIC_BASE + i*SLAVE_HPI_OFFSET;
    slvHpia[i] = SLAVE_HPIA_BASE + i*SLAVE_HPI_OFFSET;
    slvAuto[i] = SLAVE_HPID_AUTO_BASE + i*SLAVE_HPI_OFFSET;
    slvNoAuto[i] = SLAVE_HPID_NOAUTO_BASE + i*SLAVE_HPI_OFFSET;
  }
  cout << "HPIC               ";
  cout.width(8); cout << mdspHpic << "/VME     ";
  cout.width(8); cout << slvHpic[0] << "/MDSP" << endl;
  for (int i=1; i<4; i++) {
    cout << "                                    ";
    cout.width(8); cout << slvHpic[i] << "/MDSP" << endl;
  }
  cout << "HPIA               ";
  cout.width(8); cout << mdspHpia << "/VME     ";
  cout.width(8); cout << slvHpia[0] << "/MDSP" << endl;
  for (int i=1; i<4; i++) {
    cout << "                                    ";
    cout.width(8); cout << slvHpia[i] << "/MDSP" << endl;
  }
  cout << "HPID_AUTO          ";
  cout.width(8); cout << mdspAuto << "/VME     ";
  cout.width(8); cout << slvAuto[0] << "/MDSP" << endl;
  for (int i=1; i<4; i++) {
    cout << "                                    ";
    cout.width(8); cout << slvAuto[i] << "/MDSP" << endl;
  }
  cout << "HPID_NOAUTO        ";
  cout.width(8); cout << mdspNoAuto << "/VME     ";
  cout.width(8); cout << slvNoAuto[0] << "/MDSP" << endl;
  for (int i=1; i<4; i++) {
    cout << "                                    ";
    cout.width(8); cout << slvNoAuto[i] << "/MDSP" << endl;
  }
  cout << endl;
  
  for (int i=0; i<3; i++) {
    mdspStatusReg[i] = STATUS_REG[i];
    slvStatusReg[i] = STATUS_REG[i];
    cout << "STATUS_REG[" << i << "]      ";
    cout.width(8); cout << mdspStatusReg[i] << "/VME     ";
    cout.width(8); cout << slvStatusReg[i] << "/MDSP" << endl;
  }
  cout << endl;
  
  for (int i=0; i<1; i++) {
    mdspCmdReg[i] = COMMAND_REG[i];
    slvCmdReg[i] = COMMAND_REG[i];
    cout << "COMMAND_REG[" << i << "]     ";
    cout.width(8); cout << mdspCmdReg[i] << "/VME     ";
    cout.width(8); cout << slvCmdReg[i] << "/MDSP" << endl;
  }
  cout << endl;

  dec(cout);     
  return 0;
}
