/*
 * Decompiled with CFR 0.152.
 */
package SctApi.conf.gui;

import SctApi.conf.gui.ConfigGui;
import SctApi.conf.gui.MURPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import sctConf.Configuration;
import sctConf.ConfigurationException;
import sctConf.RodConfig;

public class RODView
extends JFrame {
    Configuration config;
    ConfigGui.Rod rod;

    public RODView(Configuration configuration, ConfigGui.Rod rod) {
        super("Modules in a ROD");
        JPanel jPanel;
        this.rod = rod;
        this.config = configuration;
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RODView.this.dispose();
            }
        });
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 4));
        int n = 0;
        while (n < 8) {
            jPanel = new MURPanel(configuration, this.rod, n, false);
            jPanel.addMouseListener(new MouseAdapter(n));
            jPanel3.add(jPanel);
            ++n;
        }
        this.getContentPane().add((Component)jPanel3, "Center");
        jPanel = new JPanel();
        try {
            RodConfig rodConfig = this.config.getRodConfig(this.rod.partition(), this.rod.crate(), this.rod.index());
            jPanel.setLayout(new GridLayout(4, 2));
            jPanel.add(new JLabel("BaseAddress:"));
            jPanel.add(new JLabel(Long.toHexString(rodConfig.baseAddress)));
            jPanel.add(new JLabel("IPRAM:"));
            jPanel.add(new JLabel(rodConfig.slaves[0].ipramFile));
            jPanel.add(new JLabel("IDRAM:"));
            jPanel.add(new JLabel(rodConfig.slaves[0].idramFile));
            jPanel.add(new JLabel("EXT:"));
            jPanel.add(new JLabel(rodConfig.slaves[0].extFile));
        }
        catch (ConfigurationException configurationException) {
            jPanel.setLayout(new GridLayout(1, 1));
            jPanel.add(new JLabel("No Rod configuration information"));
        }
        this.getContentPane().add((Component)jPanel, "North");
    }

    class MouseAdapter
    extends MouseInputAdapter {
        int index;

        public MouseAdapter(int n) {
            this.index = n;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JFrame jFrame = new JFrame("MUR editor");
            jFrame.getContentPane().add((Component)new MURPanel(RODView.this.config, RODView.this.rod, this.index, true), "Center");
            jFrame.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ MouseAdapter this$1;
                {
                    this.this$1 = mouseAdapter;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getWindow().dispose();
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }
}

