/*
 * Decompiled with CFR 0.152.
 */
package SctApi.conf.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sctConf.Configuration;
import sctConf.ConfigurationException;

public class ModuleListView
extends JFrame {
    Configuration config;
    JList moduleList;
    boolean unused;
    static JFileChooser fileChooser;

    public ModuleListView(Configuration configuration) {
        super("Module List");
        fileChooser = null;
        this.config = configuration;
        this.unused = true;
        JPanel jPanel = new JPanel();
        JCheckBox jCheckBox = new JCheckBox("Unused", this.unused);
        jCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                System.out.println("CheckBox state changed");
                boolean bl = ((JCheckBox)changeEvent.getSource()).getModel().isSelected();
                System.out.println("To " + bl);
                if (bl != ModuleListView.this.unused) {
                    System.out.println("Updating");
                    ModuleListView.this.unused = bl;
                    ModuleListView.this.updateList();
                }
            }
        });
        jPanel.add(jCheckBox);
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    String string = ModuleListView.getFileName();
                    if (string == null) break block2;
                    System.out.println("Add a module to the list using the configuration in file " + string);
                    try {
                        ModuleListView.this.config.configureModuleFromFile(string);
                    }
                    catch (ConfigurationException configurationException) {
                        System.out.println("Failed!");
                    }
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleListView.this.dispose();
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.moduleList = new JList(this.getList());
        this.moduleList.setSelectionMode(0);
        this.moduleList.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(this.moduleList);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().validate();
        this.updateList();
    }

    void updateList() {
        this.moduleList.setListData(this.getList());
    }

    public Vector getList() {
        Vector<String> vector = new Vector<String>();
        try {
            String[] stringArray = this.unused ? this.config.listUnusedModules() : this.config.listAllModules();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                System.out.println(stringArray[n]);
                ++n;
            }
        }
        catch (ConfigurationException configurationException) {
            System.out.println("Java caught an exception!");
        }
        System.out.println("Returned list of " + vector.size() + " modules");
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelected() {
        try {
            String string = (String)this.moduleList.getSelectedValue();
            Object var3_2 = null;
            return null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            return null;
        }
    }

    static String getFileName() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if (fileChooser.showDialog(null, "Pick module configuration file") == 0) {
            File file = fileChooser.getSelectedFile();
            return file.toString();
        }
        return null;
    }
}

