/*
 * Decompiled with CFR 0.152.
 */
package guiUtilities;

import Preferences.PreferencesInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class RawDataViewer
extends JFrame
implements ActionListener {
    private static RawDataViewer instance = new RawDataViewer();
    JTextArea theTextArea;
    JButton saveDataButton;
    JLabel captionLabel;
    JLabel title;
    Vector theRawData;
    JComboBox fileNameMenu;
    int current = 0;

    public RawDataViewer() {
        super("Data Viewer");
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        jPanel.setBorder(border);
        this.theRawData = this.theRawData;
        this.title = new JLabel("The title of this Data");
        this.title.setFont(new Font("SansSerif", 1, 16));
        this.title.setForeground(Color.blue);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.fileNameMenu = new JComboBox();
        this.fileNameMenu.addItem("None yet");
        this.fileNameMenu.setFont(new Font("SansSerif", 0, 12));
        this.fileNameMenu.addActionListener(this);
        this.fileNameMenu.setActionCommand("menuChange");
        jPanel2.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel("Filename:");
        jLabel.setFont(new Font("SansSerif", 0, 12));
        jLabel.setForeground(Color.blue);
        jPanel2.add(jLabel);
        jPanel2.add(this.fileNameMenu);
        jPanel2.add(Box.createHorizontalGlue());
        this.theTextArea = new JTextArea(60, 40);
        this.theTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.theTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        this.title.setAlignmentX(0.5f);
        jPanel.add(this.title);
        this.captionLabel.setAlignmentX(0.5f);
        jPanel.add(jPanel2);
        jPanel.add(jScrollPane);
        this.saveDataButton = new JButton("Save to File");
        this.saveDataButton.setActionCommand("save");
        this.saveDataButton.addActionListener(this);
        this.saveDataButton.setAlignmentX(0.5f);
        jPanel.add(this.saveDataButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.saveDataButton);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        this.setContentPane(jPanel);
        this.pack();
    }

    public static RawDataViewer getInstance() {
        return instance;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("save")) {
            String string = (String)this.fileNameMenu.getSelectedItem();
            File file = new File(PreferencesInterface.getInstance().getPreference(3));
            File file2 = new File(file, string);
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setSelectedFile(file2);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file3 = jFileChooser.getSelectedFile();
                try {
                    FileWriter fileWriter = new FileWriter(file3);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    String string2 = this.theTextArea.getText();
                    bufferedWriter.write(string2, 0, string2.length());
                    bufferedWriter.close();
                    System.out.println("Raw data file saved ok as " + file3.getAbsolutePath());
                }
                catch (IOException iOException) {
                    System.out.println("Error creating file " + file3.getAbsolutePath());
                }
            }
        } else {
            int n = this.fileNameMenu.getSelectedIndex();
            if (n >= 0) {
                this.theTextArea.setText((String)this.theRawData.elementAt(2 * n + 1));
            }
        }
    }

    public void showNewData(Vector vector, String string) {
        this.theRawData = vector;
        this.fileNameMenu.removeAllItems();
        int n = 0;
        while (n < vector.size()) {
            if (n % 2 == 0) {
                this.fileNameMenu.addItem((String)vector.elementAt(n));
            }
            ++n;
        }
        this.theTextArea.setText((String)vector.elementAt(1));
        this.title.setText(string);
        this.pack();
        this.setVisible(true);
    }
}

