/*
 * Decompiled with CFR 0.152.
 */
package guiUtilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class DaveUtils {
    public static String padString(String string, int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 *= -1;
        }
        if (string.length() >= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = n2 - string.length();
        if (n > 0) {
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.insert(0, " ");
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                stringBuffer.append(" ");
                ++n5;
            }
        }
        return stringBuffer.toString();
    }

    public static String padString(String string, int n, char c) {
        int n2 = n;
        if (n2 < 0) {
            n2 *= -1;
        }
        if (string.length() >= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = n2 - string.length();
        if (n > 0) {
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.insert(0, c);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                stringBuffer.append(c);
                ++n5;
            }
        }
        return stringBuffer.toString();
    }

    public static void copyFile(String string, String string2) throws IOException {
        String string3;
        FileReader fileReader = new FileReader(string);
        FileWriter fileWriter = new FileWriter(string2);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        while ((string3 = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string3, 0, string3.length());
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    public static String extractDate(String string) {
        String[] stringArray = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        int n = 0;
        if (string.length() < 12) {
            return string;
        }
        String string2 = string.substring(8, 10);
        String string3 = string.substring(5, 7);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            n = 1;
            System.out.println("Cant extract monthname!!");
        }
        String string4 = string.substring(2, 4);
        string3 = n > 0 && n < 13 ? stringArray[n - 1] : "???";
        return string2 + "-" + string3 + "-" + string4;
    }

    public static void writeTXT(File file, AbstractTableModel abstractTableModel) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int n = abstractTableModel.getRowCount();
            int n2 = abstractTableModel.getColumnCount();
            String string = "";
            int n3 = 0;
            while (n3 < n2) {
                String string2 = abstractTableModel.getColumnName(n3);
                string = string + (n3 == 0 ? abstractTableModel.getColumnName(n3) : "\t" + abstractTableModel.getColumnName(n3));
                ++n3;
            }
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            int n4 = 0;
            while (n4 < n) {
                string = "";
                int n5 = 0;
                while (n5 < n2) {
                    String string3 = (String)abstractTableModel.getValueAt(n4, n5);
                    string = string + (n5 == 0 ? string3 : "\t" + string3);
                    ++n5;
                }
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                ++n4;
            }
            bufferedWriter.close();
            System.out.println("Saved file tab-delimited text file " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            System.out.println("Error creating file " + file.getAbsolutePath());
        }
    }

    public static double getCorrectedCurrent(double d, double d2) {
        double d3 = d2 + 273.0;
        double d4 = -7019.0 * (d2 - 20.0) / 293.0 / d3;
        double d5 = Math.exp(d4) * (293.0 / d3) * (293.0 / d3);
        return d * d5;
    }

    public static String getStyleSheet() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<STYLE TYPE=\"text/css\">\n");
        stringBuffer.append("<!--\n");
        stringBuffer.append("p {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
        stringBuffer.append("ul {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
        stringBuffer.append("li {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
        stringBuffer.append("dd {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
        stringBuffer.append("table {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
        stringBuffer.append("td {font-family: Geneva,Arial,sans-serif; font-size: 10pt }\n");
        stringBuffer.append("td.bold {font-family: Geneva,Arial,sans-serif; font-size: 10pt; font-weight: bold }\n");
        stringBuffer.append("h1 {font-family: Arial, sans-serif; font-size: 16pt ; color: navy }\n");
        stringBuffer.append("h2 {font-family: Arial, sans-serif; font-size: 14pt ; color: navy }\n");
        stringBuffer.append("h3 {font-family: Arial, sans-serif; font-size: 12pt ; color: navy }\n");
        stringBuffer.append("b {font-family: Arial, sans-serif; font-size: 10pt; font-weight: bold}\n");
        stringBuffer.append(".bold {font-weight: bold}\n");
        stringBuffer.append(".boldred {font-weight: bold; color: red }\n");
        stringBuffer.append(".boldgreen {font-weight: bold; color: green}\n");
        stringBuffer.append(".boldpurple {font-weight: bold; color: purple }\n");
        stringBuffer.append("-->\n");
        stringBuffer.append("</STYLE>\n");
        return stringBuffer.toString();
    }

    public static String getHTMLHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<html><head>");
        stringBuffer.append(DaveUtils.getStyleSheet());
        stringBuffer.append("<title>title</title>");
        stringBuffer.append("</head><body>\n");
        stringBuffer.append("<h2>" + string + "</h2>\n");
        return stringBuffer.toString();
    }

    public static String getHTMLFooter() {
        return "</body></html>";
    }

    public static String getTodaysDate() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateInstance(3, new Locale("en", "GB"));
        String string = dateFormat.format(date);
        Pattern pattern = Pattern.compile("(\\d+/\\d+/)(\\d+)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            string = string.substring(matcher.start(1), matcher.end(1)) + "20" + string.substring(matcher.start(2), matcher.end(2));
        }
        System.out.println("todays date is " + string);
        return string;
    }
}

