/*
 * Decompiled with CFR 0.152.
 */
package SummaryReader;

public class ScanInfo {
    String type;
    String points;
    String[] values;

    public void setType(String string) {
        this.type = string;
    }

    public void setPoints(String string) {
        this.points = string;
        try {
            this.values = new String[Integer.parseInt(string)];
        }
        catch (Exception exception) {
            this.values = new String[1];
        }
    }

    public void setScanPoint(int n, String string) {
        if (this.values != null && n <= this.values.length - 1) {
            this.values[n] = string;
        }
    }

    public String getSummaryTable() {
        if (this.type == null || this.type.startsWith("Null")) {
            return "<h3>Scan Information</h3>\nNone available.";
        }
        if (this.points == null) {
            this.points = "Unknown";
        }
        StringBuffer stringBuffer = new StringBuffer("<h3>Scan Information</h3>");
        stringBuffer.append("<table border=1>\n");
        stringBuffer.append("<tr><td>Type</td><td>#Points</td><td>Values</td></tr>\n");
        stringBuffer.append("<tr><td>" + this.type + "</td><td>" + this.points + "</td><td>");
        int n = 0;
        while (n < this.values.length) {
            if (n > 0) {
                if (n % 16 == 0) {
                    stringBuffer.append("<br>");
                } else {
                    stringBuffer.append(",");
                }
            }
            stringBuffer.append(this.values[n]);
            ++n;
        }
        stringBuffer.append("</td></tr>");
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }
}

