/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import Preferences.PreferencesInterface;
import ProdDatabase.GeneralUtilities;
import guiUtilities.DaveUtils;
import guiUtilities.userPrompt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Vector;

public class SignoffDataInterface {
    Hashtable data = new Hashtable();
    public static final String[] keywords = new String[]{"%SERIAL NUMBER", "%CATEGORY", "%COMMENT", "%BARREL", "%B56_REASON", "%FAIL_REASON", "%IV_CATEGORY", "%IV_COMMENT", "%ELECTRICAL_CATEGORY", "%ELECTRICAL_COMMENT", "%SCURVE_CATEGORY", "%SCURVE_COMMENT"};
    public static final String[] descriptions = new String[]{"Serial Number", "Overall category", "Overall comment", "Barrel type categorisation", "Reason for B56 assignment", "Reason for FAIL category", "IV categorisation", "Comment on IV performance", "Electrical categorisation", "Comment on electrical performance", "S-curves categorsiation", "Comment on S-curves"};
    public static final int SERIALNO = 0;
    public static final int CATEGORY = 1;
    public static final int COMMENT = 2;
    public static final int BARREL = 3;
    public static final int B56REASON = 4;
    public static final int FAILREASON = 5;
    public static final int IVCATEGORY = 6;
    public static final int IVCOMMENT = 7;
    public static final int ELECTRICALCATEGORY = 8;
    public static final int ELECTRICALCOMMENT = 9;
    public static final int SCURVECATEGORY = 10;
    public static final int SCURVECOMMENT = 11;
    private String location;
    private static final boolean[][] compulsoryFields = new boolean[][]{{true, false, false, false, false, false, true, true, true, true, true, true}, {true, true, true, true, false, false, true, true, true, true, true, true}};
    public static final int INSTITUTE_UPLOAD = 0;
    public static final int SIGNOFF_UPLOAD = 1;

    public SignoffDataInterface(String string, String string2) {
        this.location = string2;
        try {
            String string3 = GeneralUtilities.getSignoffDataTestNo(string, string2);
            Vector vector = GeneralUtilities.getRawData(string3);
            if (vector.size() > 0) {
                this.extractSignoffData((String)vector.elementAt(1));
            }
        }
        catch (Exception exception) {
            System.out.println("FAILED to download signoff data: " + exception.toString());
        }
    }

    private void extractSignoffData(String string) {
        String[] stringArray = string.split("[\\n\\r]");
        String string2 = "None";
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith("#")) {
                if (stringArray[n].startsWith("%")) {
                    string2 = stringArray[n];
                } else if (this.data.containsKey(string2)) {
                    String string3 = (String)this.data.get(string2);
                    string3 = string3 + "\n" + stringArray[n];
                    this.data.put(string2, string3);
                } else {
                    this.data.put(string2, stringArray[n]);
                }
            }
            ++n;
        }
    }

    public String getString(int n) {
        if (this.data.containsKey(keywords[n])) {
            return (String)this.data.get(keywords[n]);
        }
        return null;
    }

    public void setParameter(int n, String string) {
        this.data.put(keywords[n], string);
    }

    public Vector allFieldsPresent(int n) {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < keywords.length) {
            if (compulsoryFields[n][n2] && !this.data.containsKey(keywords[n2])) {
                vector.add(descriptions[n2]);
            }
            ++n2;
        }
        if (this.data.containsKey(keywords[3]) && ((String)this.data.get(keywords[3])).equals("56") && !this.data.containsKey(keywords[4])) {
            vector.add(descriptions[4]);
        }
        if (this.data.containsKey(keywords[1]) && ((String)this.data.get(keywords[1])).equals("FAIL") && !this.data.containsKey(keywords[5])) {
            vector.add(descriptions[5]);
        }
        return vector;
    }

    public String writeUploadFiles(String string) {
        String string2 = null;
        try {
            userPrompt userPrompt2 = new userPrompt(null, "", "Your initials", GeneralUtilities.getNameList(PreferencesInterface.getInstance().getPreference(0)));
            userPrompt2.pack();
            userPrompt2.setVisible(true);
            string2 = userPrompt2.getValidatedText();
            if (string2.equals("None")) {
                return null;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR retrieving list of users from SCTDB: " + exception.toString());
            return null;
        }
        try {
            return this.writeUploadFile(string, this.writeUploadDataFile(string), string2);
        }
        catch (Exception exception) {
            System.out.println("FAILED to create upload file: " + exception.toString());
            return null;
        }
    }

    private File writeUploadDataFile(String string) throws Exception {
        File file = new File(PreferencesInterface.getInstance().getPreference(1), string + "_signoffdata.txt");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        int n = 0;
        while (n < keywords.length) {
            if (this.data.containsKey(keywords[n])) {
                bufferedWriter.write(keywords[n]);
                bufferedWriter.newLine();
                bufferedWriter.write((String)this.data.get(keywords[n]));
                bufferedWriter.newLine();
            }
            ++n;
        }
        bufferedWriter.close();
        return file;
    }

    private String writeUploadFile(String string, File file, String string2) throws Exception {
        PreferencesInterface preferencesInterface = PreferencesInterface.getInstance();
        File file2 = new File(preferencesInterface.getPreference(1), string + "_signoff.upl");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        bufferedWriter.write("%NEWTEST");
        bufferedWriter.newLine();
        bufferedWriter.write("SERIAL NUMBER : " + string);
        bufferedWriter.newLine();
        bufferedWriter.write("TEST MADE BY : " + string2);
        bufferedWriter.newLine();
        bufferedWriter.write("LOCATION NAME : " + this.location);
        bufferedWriter.newLine();
        bufferedWriter.write("Run number : SIGNOFF");
        bufferedWriter.newLine();
        bufferedWriter.write("TEST DATE : " + DaveUtils.getTodaysDate());
        bufferedWriter.newLine();
        bufferedWriter.write("PASSED : YES");
        bufferedWriter.newLine();
        bufferedWriter.write("PROBLEM : NO");
        bufferedWriter.newLine();
        bufferedWriter.write("%bmMOD_RData");
        bufferedWriter.newLine();
        bufferedWriter.write("%TEST Rawdata");
        bufferedWriter.newLine();
        bufferedWriter.write("FILENAME : " + file.getAbsolutePath());
        bufferedWriter.close();
        return file2.getAbsolutePath();
    }
}

