/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import ProdDatabase.BarrelUtilities;
import ProdDatabase.MetrologyTest;
import ProdDatabase.SCTDBInfo;
import ProdDatabase.SCTDBInterface;
import ProdDatabase.WaferUtilities;
import guiUtilities.DaveUtils;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleInfo
implements SCTDBInfo {
    Statement statement;
    ResultSet resultSet;
    StringBuffer sqlStat;
    private Vector sensorList;
    private Vector asicList;
    private Vector metrologyList;
    private Hashtable testDataHash;
    private Hashtable asicMfrHash;
    private Hashtable correctionHash;
    private Hashtable metrologyHash;
    private Hashtable snHash;
    private SCTDBInterface db;
    int recordCount;
    String moduleSerialNo;
    Pattern lotNoPattern = Pattern.compile("(Z\\d+-W\\d+).*");

    public ModuleInfo(String string) {
        this.moduleSerialNo = string;
        this.metrologyList = new Vector();
        this.sensorList = new Vector();
        this.asicList = new Vector();
        this.snHash = new Hashtable();
        this.testDataHash = new Hashtable();
        this.asicMfrHash = new Hashtable();
        this.correctionHash = new Hashtable();
        this.metrologyHash = new Hashtable();
        this.db = SCTDBInterface.getInstance();
        this.fillSNHash();
        this.getDataSheetInfo();
        try {
            this.getMetrologyData();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    public String getSerialNo(int n) {
        if (this.snHash.containsKey(SCTDBInfo.moduleParts[n])) {
            return (String)this.snHash.get(SCTDBInfo.moduleParts[n]);
        }
        return "Not known";
    }

    public Vector getSensorList() {
        return this.sensorList;
    }

    public Vector getAsicList() {
        return this.asicList;
    }

    public int noMetrologyTests() {
        return this.metrologyList.size();
    }

    public MetrologyTest getMetrologyTest(int n) {
        String string = (String)this.metrologyList.elementAt(n);
        return (MetrologyTest)this.metrologyHash.get(string);
    }

    public String getDataSheetTestNo(int n) {
        if (this.testDataHash.containsKey(SCTDBInfo.dataSheetTestDBNames[n])) {
            return (String)this.testDataHash.get(SCTDBInfo.dataSheetTestDBNames[n]);
        }
        return null;
    }

    public String getASICInfo(String string) {
        if (!this.asicMfrHash.containsKey(string)) {
            return null;
        }
        return (String)this.asicMfrHash.get(string);
    }

    public String getASICcorrFactor(String string) {
        if (!this.asicMfrHash.containsKey(string)) {
            return null;
        }
        String string2 = new String((String)this.asicMfrHash.get(string));
        Matcher matcher = this.lotNoPattern.matcher(string2);
        if (matcher.matches()) {
            String string3 = string2.substring(matcher.start(1), matcher.end(1));
            if (this.correctionHash.containsKey(string3)) {
                return (String)this.correctionHash.get(string3);
            }
            return null;
        }
        return null;
    }

    private void fillSNHash() {
        this.snHash.put(SCTDBInfo.moduleParts[0], this.moduleSerialNo);
        String string = this.moduleSerialNo.substring(0, 7) + "8" + this.moduleSerialNo.substring(8);
        this.snHash.put(SCTDBInfo.moduleParts[1], string);
        try {
            this.getChipInfo(string);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        this.snHash.put(SCTDBInfo.moduleParts[2], this.moduleSerialNo.substring(0, 7) + "7" + this.moduleSerialNo.substring(8));
        try {
            String string2 = this.getSensorBaseboardSN(this.moduleSerialNo);
            if (string2 != null) {
                this.sensorList = this.getSensorList(string2);
                this.snHash.put(SCTDBInfo.moduleParts[3], string2);
                this.snHash.put(SCTDBInfo.moduleParts[4], string2.substring(0, 7) + "8" + string2.substring(8));
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    public String getHybridSN(String string) throws Exception {
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        this.sqlStat = new StringBuffer("SELECT ");
        this.sqlStat.append("ser_no, posn from ASSM_ITEMS WHERE assm_ser_no=" + string + " AND (ctype LIKE 'fhHybrid%' OR ctype LIKE 'bmHASIC') ORDER BY posn");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(this.sqlStat.toString());
        this.recordCount = 0;
        String string2 = null;
        boolean bl = this.resultSet.next();
        while (bl) {
            string2 = this.resultSet.getString(1);
            bl = this.resultSet.next();
        }
        this.closeTheStatement();
        return string2;
    }

    public String getSensorBaseboardSN(String string) throws Exception {
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        this.sqlStat = new StringBuffer("SELECT ");
        this.sqlStat.append("ser_no, posn from ASSM_ITEMS WHERE assm_ser_no=" + string + " AND ctype LIKE 'bmSB' ORDER BY posn");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(this.sqlStat.toString());
        this.recordCount = 0;
        String string2 = null;
        boolean bl = this.resultSet.next();
        while (bl) {
            string2 = this.resultSet.getString(1);
            bl = this.resultSet.next();
        }
        this.closeTheStatement();
        return string2;
    }

    public Vector getSensorList(String string) throws Exception {
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        Vector<String> vector = new Vector<String>();
        this.sqlStat = new StringBuffer("SELECT ");
        this.sqlStat.append("ser_no, posn from ASSM_ITEMS WHERE assm_ser_no=" + string + " AND ctype LIKE '%SiDetector%' ORDER BY posn");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(this.sqlStat.toString());
        this.recordCount = 0;
        boolean bl = this.resultSet.next();
        while (bl) {
            vector.addElement(this.resultSet.getString(1));
            bl = this.resultSet.next();
        }
        this.closeTheStatement();
        return vector;
    }

    public void getChipInfo(String string) throws Exception {
        Object object;
        String string2;
        Object object2;
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        this.sqlStat = new StringBuffer("SELECT ");
        this.sqlStat.append("ASSM_ITEMS.ser_no,ASSM_ITEMS.posn,items.mfr_ser_no from ASSM_ITEMS,items WHERE assm_ser_no=" + string);
        this.sqlStat.append(" AND items.ser_no=assm_items.ser_no AND assm_items.ctype = 'chABCD3T'");
        this.sqlStat.append(" ORDER BY ASSM_ITEMS.posn");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(this.sqlStat.toString());
        int n = 0;
        boolean bl = this.resultSet.next();
        while (bl) {
            String string3 = this.resultSet.getString(1);
            object2 = this.resultSet.getString(2);
            string2 = this.resultSet.getString(3);
            this.asicMfrHash.put(string3, string2);
            object = this.lotNoPattern.matcher(string2);
            this.asicList.addElement(string3);
            int n2 = Integer.parseInt((String)object2);
            object2 = Integer.toString(--n2);
            if (((Matcher)object).matches()) {
                string2 = string2.substring(((Matcher)object).start(1), ((Matcher)object).end(1));
                if (((String)object2).length() < 2) {
                    object2 = "0" + (String)object2;
                }
                hashtable.put(object2, string2);
            }
            ++n;
            bl = this.resultSet.next();
        }
        this.closeTheStatement();
        if (hashtable.size() != 12) {
            System.out.println("No asic assembly data for hybrid " + string);
            return;
        }
        int n3 = 0;
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            String string4;
            string2 = (String)object2.nextElement();
            object = (String)hashtable.get(string2);
            if (!this.correctionHash.containsKey(object) && !(string4 = WaferUtilities.getCalCorrFactor((String)object)).equals("")) {
                this.correctionHash.put(object, string4);
            }
            if (!this.correctionHash.containsKey(object)) continue;
            String string5 = (String)this.correctionHash.get(object);
            hashtable.put(string2, string5);
            ++n3;
        }
        if ((n3 = 12 - n3) > 0) {
            System.out.println("WARNING: CalCorr factors not found for " + n3 + " chips");
        }
    }

    public void getDataSheetInfo() {
        String string = this.snHash.containsKey(SCTDBInfo.moduleParts[3]) ? (String)this.snHash.get(SCTDBInfo.moduleParts[3]) : null;
        try {
            this.testDataHash = BarrelUtilities.getDataSheetStatus(this.moduleSerialNo, string);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    public void getMetrologyData() throws Exception {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        StringBuffer stringBuffer = new StringBuffer("SELECT tests.test_no,tests.LOCN_NAME,tests.test_date,SCT_TSTBMSURVEYXY.event,tests.pass,tests.problem");
        stringBuffer.append(" FROM tests,SCT_TSTBMSURVEYXY WHERE tests.ser_no =" + this.moduleSerialNo + " AND SCT_TSTBMSURVEYXY.test_no=tests.test_no");
        stringBuffer.append(" ORDER BY tests.test_date,tests.test_no");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer.toString());
        boolean bl = this.resultSet.next();
        while (bl) {
            String string7 = this.resultSet.getString(1);
            string6 = this.resultSet.getString(2);
            string5 = DaveUtils.extractDate(this.resultSet.getString(3));
            string4 = this.resultSet.getString(4);
            string3 = this.resultSet.getString(5);
            string2 = this.resultSet.getString(6);
            string = "<font color=red>Fail</font>";
            if (string3.equals("YES")) {
                string = string2.equals("YES") ? "<font color=orange>HOLD</font>" : "<font color=green>Good</font>";
            }
            object = new MetrologyTest(string7, string6, string5, string4, "XY", string);
            this.metrologyHash.put(string7, object);
            this.metrologyList.addElement(string7);
            bl = this.resultSet.next();
        }
        this.statement.close();
        stringBuffer = new StringBuffer("SELECT tests.test_no,tests.LOCN_NAME,tests.test_date,SCT_TSTBMSURVEYZ.event,tests.pass,tests.problem");
        stringBuffer.append(" FROM tests,SCT_TSTBMSURVEYZ WHERE tests.ser_no =" + this.moduleSerialNo + " AND SCT_TSTBMSURVEYZ.test_no=tests.test_no");
        stringBuffer.append(" ORDER BY tests.test_date,tests.test_no");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer.toString());
        boolean bl2 = this.resultSet.next();
        while (bl2) {
            string6 = this.resultSet.getString(1);
            string5 = this.resultSet.getString(2);
            string4 = DaveUtils.extractDate(this.resultSet.getString(3));
            string3 = this.resultSet.getString(4);
            string2 = this.resultSet.getString(5);
            string = this.resultSet.getString(6);
            object = "<font color=red>Fail</font>";
            if (string2.equals("YES")) {
                object = string.equals("YES") ? "<font color=orange>HOLD</font>" : "<font color=green>PASS</font>";
            }
            MetrologyTest metrologyTest = new MetrologyTest(string6, string5, string4, string3, "Z", (String)object);
            this.metrologyHash.put(string6, metrologyTest);
            this.metrologyList.addElement(string6);
            bl2 = this.resultSet.next();
        }
        this.statement.close();
    }

    public void closeTheStatement() throws Exception {
        SQLWarning sQLWarning = this.statement.getWarnings();
        while (sQLWarning != null) {
            System.out.println("Warning : " + sQLWarning.getMessage() + ":" + sQLWarning.getSQLState());
            sQLWarning = sQLWarning.getNextWarning();
        }
        this.statement.close();
    }
}

