/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import ProdDatabase.GeneralUtilities;
import ProdDatabase.ModuleIV;
import ProdDatabase.SCTDBInfo;
import ProdDatabase.SCTDBInterface;
import guiUtilities.DaveUtils;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ModuleIVInfo
implements SCTDBInfo {
    Statement statement;
    ResultSet resultSet;
    StringBuffer sqlStat;
    SCTDBInterface db;
    private Vector sensors;
    private Vector modIVs;
    String moduleSerialNo;
    Hashtable i150Hash;
    Hashtable i350Hash;
    Hashtable temperatureHash;
    Hashtable testnoHash;
    Hashtable moduleTestNoHash;
    String dataOrigin;
    private double tMin;
    private double tMax;
    private double i150Total;
    private double i350Total;
    private double i500Total;
    DecimalFormat ivFormatter = new DecimalFormat("#.###");
    DecimalFormat temperatureFormatter = new DecimalFormat("#.#");

    public ModuleIVInfo(String string) {
        this.moduleSerialNo = string;
        this.sensors = new Vector();
        this.initVariables();
    }

    public ModuleIVInfo(String string, Vector vector) {
        this.moduleSerialNo = string;
        this.sensors = vector;
        this.initVariables();
    }

    private void initVariables() {
        this.modIVs = new Vector();
        this.i150Hash = new Hashtable();
        this.i350Hash = new Hashtable();
        this.temperatureHash = new Hashtable();
        this.testnoHash = new Hashtable();
        this.moduleTestNoHash = new Hashtable();
        this.dataOrigin = new String(" - ");
        this.tMin = 100.0;
        this.tMax = 0.0;
        this.i150Total = 0.0;
        this.i350Total = 0.0;
        this.i500Total = 0.0;
        this.db = SCTDBInterface.getInstance();
        try {
            if (this.sensors.size() > 0) {
                this.getSensorIVInfo();
                if (this.i150Hash.size() != this.sensors.size()) {
                    this.getMfrIVInfo();
                }
                if (this.i150Hash.size() == this.sensors.size()) {
                    this.getSensorSums();
                }
            }
            this.getModuleIVs();
            this.getModule500VData();
            this.getModuleIVPlots();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    public double geti150SensorCurrent() {
        return this.i150Total;
    }

    public double geti350SensorCurrent() {
        return this.i350Total;
    }

    public double geti500SensorCurrent() {
        return this.i500Total;
    }

    public String getTemperatureRange() {
        if (this.tMax == 0.0) {
            return " - ";
        }
        return this.temperatureFormatter.format(this.tMin) + "-" + this.temperatureFormatter.format(this.tMax);
    }

    public String getOrigin() {
        return this.dataOrigin;
    }

    public int noModuleIVs() {
        return this.modIVs.size();
    }

    public ModuleIV getModuleIV(int n) {
        String string = (String)this.modIVs.elementAt(n);
        return (ModuleIV)this.moduleTestNoHash.get(string);
    }

    public ModuleIV getLastModuleIV() {
        String string = (String)this.modIVs.lastElement();
        return (ModuleIV)this.moduleTestNoHash.get(string);
    }

    private void getSensorIVInfo() throws Exception {
        if (this.sensors.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.sensors.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)this.sensors.elementAt(n));
            ++n;
        }
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append("tests.ser_no,tstdetivs.i_leak_150,tstdetivs.i_leak_350,tstdetivs.temperature, tests.locn_name,tests.test_no");
        stringBuffer2.append(" FROM tests,tstdetivs");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + stringBuffer.toString() + ")");
        stringBuffer2.append(" AND tests.test_name='DetIVscan'");
        stringBuffer2.append(" AND tstdetivs.test_no=tests.test_no AND tstdetivs.temperature>0");
        stringBuffer2.append(" ORDER BY tests.test_date,tests.test_no");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer2.toString());
        boolean bl = this.resultSet.next();
        while (bl) {
            String string = this.resultSet.getString(1);
            this.i150Hash.put(string, this.resultSet.getString(2));
            this.i350Hash.put(string, this.resultSet.getString(3));
            this.temperatureHash.put(string, this.resultSet.getString(4));
            this.dataOrigin = this.resultSet.getString(5);
            this.testnoHash.put(string, this.resultSet.getString(6));
            bl = this.resultSet.next();
        }
        this.statement.close();
    }

    private void getMfrIVInfo() throws Exception {
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.sensors.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)this.sensors.elementAt(n));
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT tests.ser_no,i_leak_150,i_leak_350,temperature,tests.locn_name");
        stringBuffer2.append(" FROM tests,tstdetmfrs WHERE tstdetmfrs.test_no=tests.test_no");
        stringBuffer2.append(" AND tests.ser_no IN (" + stringBuffer.toString() + ")");
        stringBuffer2.append(" AND tests.test_name='DetMfrSheet'");
        stringBuffer2.append(" ORDER BY tests.test_date,tests.test_no");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer2.toString());
        boolean bl = this.resultSet.next();
        while (bl) {
            String string = this.resultSet.getString(1);
            this.i150Hash.put(string, this.resultSet.getString(2));
            this.i350Hash.put(string, this.resultSet.getString(3));
            this.temperatureHash.put(string, this.resultSet.getString(4));
            this.dataOrigin = this.resultSet.getString(5);
            bl = this.resultSet.next();
        }
        this.statement.close();
    }

    private void getSensorSums() {
        int n = 0;
        Enumeration enumeration = this.i150Hash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.testnoHash.get(string);
            String string3 = (String)this.i150Hash.get(string);
            String string4 = (String)this.i350Hash.get(string);
            double d = Double.parseDouble((String)this.temperatureHash.get(string));
            try {
                double d2 = GeneralUtilities.get500VData(string2);
                if (d2 > 0.0) {
                    ++n;
                }
                this.i500Total += DaveUtils.getCorrectedCurrent(d2, d);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
            this.i150Total += DaveUtils.getCorrectedCurrent(Double.parseDouble(string3), d);
            this.i350Total += DaveUtils.getCorrectedCurrent(Double.parseDouble(string4), d);
            if (d > this.tMax) {
                this.tMax = d;
            }
            if (!(d < this.tMin)) continue;
            this.tMin = d;
        }
        if (n != this.i150Hash.size()) {
            this.i500Total = 0.0;
        }
    }

    private void getModuleIVs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append("tests.ser_no,tests.test_date,tests.locn_name,tests.problem,tests.pass,tstdetivs.i_leak_150,tstdetivs.i_leak_350,tstdetivs.temperature,tests.test_no");
        stringBuffer.append(" FROM tests,tstdetivs");
        stringBuffer.append(" WHERE tests.ser_no=" + this.moduleSerialNo + " AND tests.test_name='DetModIV'");
        stringBuffer.append(" AND tstdetivs.test_no=tests.test_no AND tstdetivs.temperature>0");
        stringBuffer.append(" ORDER BY tests.test_date,tests.test_no");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer.toString());
        boolean bl = this.resultSet.next();
        while (bl) {
            String string = this.resultSet.getString(1);
            String string2 = DaveUtils.extractDate(this.resultSet.getString(2));
            String string3 = this.resultSet.getString(3);
            String string4 = this.resultSet.getString(4);
            String string5 = this.resultSet.getString(5);
            String string6 = this.resultSet.getString(6);
            String string7 = this.resultSet.getString(7);
            String string8 = this.resultSet.getString(8);
            String string9 = this.resultSet.getString(9);
            String string10 = "FAIL";
            if (string5.equals("YES")) {
                string10 = string4.equals("YES") ? "Problem" : "Ok";
            }
            double d = DaveUtils.getCorrectedCurrent(Double.parseDouble(string6), Double.parseDouble(string8));
            double d2 = DaveUtils.getCorrectedCurrent(Double.parseDouble(string7), Double.parseDouble(string8));
            ModuleIV moduleIV = new ModuleIV(string, string2, string10, string8, string3, string9, d, d2);
            this.moduleTestNoHash.put(string9, moduleIV);
            this.modIVs.add(string9);
            bl = this.resultSet.next();
        }
        this.statement.close();
    }

    private void getModule500VData() {
        int n = 0;
        while (n < this.modIVs.size()) {
            String string = (String)this.modIVs.elementAt(n);
            ModuleIV moduleIV = (ModuleIV)this.moduleTestNoHash.get(string);
            String string2 = moduleIV.getTemperature();
            try {
                double d = GeneralUtilities.get500VData(string);
                d = DaveUtils.getCorrectedCurrent(d, Double.parseDouble(string2));
                moduleIV.add500VData(d);
                this.moduleTestNoHash.put(string, moduleIV);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
            ++n;
        }
    }

    private void getModuleIVPlots() throws Exception {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.moduleTestNoHash.keys();
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            ++n;
            stringBuffer.append((String)enumeration.nextElement());
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append("test_no,url FROM web_links");
        stringBuffer2.append(" WHERE test_no IN (" + stringBuffer.toString() + ")");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer2.toString());
        boolean bl = this.resultSet.next();
        while (bl) {
            String string = this.resultSet.getString(1);
            String string2 = this.resultSet.getString(2);
            ModuleIV moduleIV = (ModuleIV)this.moduleTestNoHash.get(string);
            moduleIV.addLink(string2);
            this.moduleTestNoHash.put(string, moduleIV);
            bl = this.resultSet.next();
        }
        this.statement.close();
    }
}

