/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import Preferences.PreferencesInterface;
import ProdDatabase.GeneralUtilities;
import ProdDatabase.MetrologyTest;
import ProdDatabase.ModuleIV;
import ProdDatabase.ModuleIVInfo;
import ProdDatabase.ModuleInfo;
import ProdDatabase.ModuleSCTDAQInfo;
import ProdDatabase.SCTDAQCharacterisation;
import ProdDatabase.SCTDBInfo;
import ProdDatabase.SCTDBInterface;
import guiUtilities.DaveUtils;
import java.io.File;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLReportUtilities
implements SCTDBInfo {
    public static boolean DEBUG = false;
    private static Hashtable sctdaqTestNameHash;
    private static Hashtable sctdaqTestNumberHash;

    private static void fillHashes() {
        if (sctdaqTestNameHash != null) {
            return;
        }
        sctdaqTestNameHash = new Hashtable();
        sctdaqTestNumberHash = new Hashtable();
        int n = 0;
        while (n < SCTDBInfo.sctdaqDBTestNames.length) {
            sctdaqTestNameHash.put(SCTDBInfo.sctdaqDBTestNames[n], SCTDBInfo.sctdaqNormalTestNames[n]);
            sctdaqTestNumberHash.put(SCTDBInfo.sctdaqDBTestNames[n], new Integer(n));
            ++n;
        }
    }

    public static String getHTMLTestInfo(String string) throws Exception {
        HTMLReportUtilities.fillHashes();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("SELECT test_name,ser_no,test_date,locn_name FROM tests WHERE test_no=" + string);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n = 0;
        boolean bl = resultSet.next();
        while (bl) {
            ++n;
            String string2 = resultSet.getString(1);
            if (sctdaqTestNameHash.containsKey(string2)) {
                string2 = (String)sctdaqTestNameHash.get(string2);
            }
            stringBuffer.append(string2 + " test of " + resultSet.getString(2) + " on " + DaveUtils.extractDate(resultSet.getString(3)) + " at " + resultSet.getString(4));
            bl = resultSet.next();
        }
        statement.close();
        if (n == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String getHTMLCommentsTable(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<h2>Comments</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT CMNT_TEXT FROM TEST_CMNTS WHERE TEST_NO=" + string);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            ++n;
            String string2 = resultSet.getString(1);
            ++n2;
            stringBuffer.append(string2 + "<br>\n");
            bl2 = resultSet.next();
        }
        statement.close();
        if (n2 == 0) {
            stringBuffer.append("No comments found\n");
        } else {
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    public static String getHTMLPlotTable(String string) throws Exception {
        String string2 = " AND (tests.TEST_name LIKE 'Hyb%' OR tests.TEST_name LIKE 'DetModIV')";
        StringBuffer stringBuffer = new StringBuffer("<h2>Plots</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT tests.ser_no,tests.test_no,web_links.web_link_desc,web_links.url FROM tests,web_links");
        stringBuffer2.append(" WHERE tests.test_no=web_links.test_no AND tests.test_no=" + string);
        stringBuffer2.append(string2);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        System.out.println("Interrogating web_links table ...");
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n = 0;
        Hashtable hashtable = new Hashtable();
        boolean bl = resultSet.next();
        while (bl) {
            String string3 = resultSet.getString(1);
            String string4 = resultSet.getString(2);
            String string5 = resultSet.getString(3);
            String string6 = resultSet.getString(4);
            if (string6.indexOf("http://hepunx.rl.ac.uk/atlassct/cgibin/getfile.pl?file=") != -1) {
                string6 = string6 + "&module=" + string3;
            }
            if (n == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                int n2 = 0;
                while (n2 < 2) {
                    stringBuffer.append("<col width=*>\n");
                    ++n2;
                }
                stringBuffer.append("<tr><td valign=top align=left><b>Title</b></td><td valign=top align=left><b>Link</b></td></tr>\n");
            }
            ++n;
            String string7 = "Type6&ref=" + string6;
            stringBuffer.append("<tr><td valign=top align=left>" + string5 + "</td><td valign=top align=left><a href=" + string7 + ">" + string6 + "</a></td></tr>\n");
            bl = resultSet.next();
        }
        statement.close();
        if (n == 0) {
            stringBuffer.append("No Plots available.\n");
        } else {
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    public static String getHTMLDCSTable(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<h2>DCS Information</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT T0,T1,VDET,IDET,VCC,ICC,VDD,IDD,TIME_POWERED FROM SCT_TSTDCSINFO WHERE TEST_NO=" + string);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        System.out.println("Interrogating DCS table ...");
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            int n3;
            ++n;
            if (n2 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                n3 = 0;
                while (n3 < 9) {
                    stringBuffer.append("<col width=*>\n");
                    ++n3;
                }
                stringBuffer.append("<tr><td><b>T0</b></td><td><b>T1</b></td><td><b>Vdet</b></td><td><b>Idet</b></td><td><b>Vcc</b></td><td><b>Icc</b></td><td><b>Vdd</b></td><td><b>Idd</b></td><td><b>Time Powered</b></td></tr>\n");
            }
            ++n2;
            stringBuffer.append("<tr>");
            n3 = 0;
            while (n3 < 9) {
                stringBuffer.append("<td>" + resultSet.getString(n3 + 1) + "</td>");
                ++n3;
            }
            stringBuffer.append("</tr>\n");
            bl2 = resultSet.next();
        }
        statement.close();
        if (n2 == 0) {
            stringBuffer.append("<p>No DCS information available\n");
        } else {
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    public static String getHTMLDAQTable(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<h2>DAQ Information</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT HOST,VERSION,DUT,TEST_TIME FROM SCT_TSTDAQINFO WHERE TEST_NO=" + string);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        System.out.println("Interrogating DAQ table ...");
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            int n3;
            ++n;
            if (n2 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                n3 = 0;
                while (n3 < 4) {
                    stringBuffer.append("<col width=*>\n");
                    ++n3;
                }
                stringBuffer.append("<tr><td valign=top align=left><b>Host</b></td><td valign=top align=left><b>DAQ Version</b></td><td valign=top align=left><b>DeviceType</b></td><td valign=top align=left><b>Time</b></td></tr>\n");
            }
            ++n2;
            stringBuffer.append("<tr>");
            n3 = 0;
            while (n3 < 4) {
                stringBuffer.append("<td valign=top align=left>" + resultSet.getString(n3 + 1) + "</td>");
                ++n3;
            }
            stringBuffer.append("</tr>\n");
            bl2 = resultSet.next();
        }
        statement.close();
        if (n2 == 0) {
            stringBuffer.append("No DAQ information available\n");
        } else {
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    public static String getHTMLScanTable(String string) throws Exception {
        String[] stringArray = new String[16];
        StringBuffer stringBuffer = new StringBuffer("<p><h2>Scan Information</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT POINT_TYPE,N_POINTS");
        int n = 0;
        while (n < 16) {
            stringBuffer2.append(",POINT_" + n);
            ++n;
        }
        stringBuffer2.append(" FROM SCT_TSTSCANINFO WHERE TEST_NO=" + string);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        System.out.println("Interrogating SCAN table ...");
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            int n4;
            ++n2;
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            int n5 = Integer.parseInt(string3);
            int n6 = 0;
            while (n6 < 16) {
                stringArray[n6] = resultSet.getString(n6 + 3);
                ++n6;
            }
            if (n3 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                n4 = 0;
                while (n4 < 2 + n5) {
                    stringBuffer.append("<col width=*>\n");
                    ++n4;
                }
                stringBuffer.append("<tr><td valign=top align=left><b>Type</b></td><td valign=top align=left><b># Points</b></td><td valign=top align=left><b>Values</b></td></tr>\n");
            }
            ++n3;
            stringBuffer.append("<tr>");
            stringBuffer.append("<td valign=top align=left>" + string2 + "</td><td valign=top align=left>" + string3 + "</td>");
            stringBuffer.append("<td valign=top align=left>" + stringArray[0]);
            n4 = 1;
            while (n4 < n5) {
                stringBuffer.append("," + stringArray[n4]);
                ++n4;
            }
            stringBuffer.append("</tr>\n");
            bl2 = resultSet.next();
        }
        statement.close();
        if (n3 == 0) {
            stringBuffer.append("<p>No scan information for this test type.\n");
        } else {
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    public static String getSCTDAQHTMLTestData(String string, int n) throws Exception {
        ResultSet resultSet;
        StringBuffer stringBuffer;
        int n2 = 0;
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Statement statement = sCTDBInterface.connection.createStatement();
        StringBuffer stringBuffer2 = new StringBuffer("<h2>Test Data</h2>\n");
        switch (n) {
            case 0: 
            case 1: {
                stringBuffer2.append("No test data available for this test type.");
                return stringBuffer2.toString();
            }
            case 6: {
                stringBuffer = new StringBuffer("SELECT TR_CHARGE,TR_TYPE,TR_ALGORITHM FROM " + SCTDBInfo.sctdaqDBTableNames[n]);
                stringBuffer.append(" WHERE test_no=" + string);
                resultSet = statement.executeQuery(stringBuffer.toString());
                boolean bl = resultSet.next();
                while (bl) {
                    stringBuffer2.append("Charge=" + resultSet.getString(1) + " Type=" + resultSet.getString(2) + " Algorithm=" + resultSet.getString(3));
                    bl = resultSet.next();
                }
                statement.close();
                break;
            }
            case 10: {
                stringBuffer = new StringBuffer("SELECT ICC_MAX,IDD_MAX,ICC_TYP,IDD_TYP FROM " + SCTDBInfo.sctdaqDBTableNames[n]);
                stringBuffer.append(" WHERE test_no=" + string);
                resultSet = statement.executeQuery(stringBuffer.toString());
                boolean bl = resultSet.next();
                while (bl) {
                    stringBuffer2.append("Icc/Idd(max)=" + resultSet.getString(1) + "/" + resultSet.getString(2));
                    stringBuffer2.append(" Icc/Idd(typical)=" + resultSet.getString(3) + "/" + resultSet.getString(4));
                    bl = resultSet.next();
                }
                statement.close();
                break;
            }
        }
        int n3 = n == 0 || n == 10 || n == 11 ? 1 : SCTDBInfo.DBChipParameterNames[n].length;
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer = new StringBuffer("SELECT ");
            switch (n) {
                case 0: {
                    stringBuffer.append(SCTDBInfo.sctdaqDBTableNames[n] + ".ICC_NOCONFIG");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".IDD_NOCONFIG");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".ICC_NOCLOCK");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".IDD_NOCLOCK");
                    break;
                }
                case 10: {
                    stringBuffer.append(SCTDBInfo.sctdaqDBTableNames[n] + ".DURATION");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".FAIL_TIME");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".T0_MIN");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".T0_MAX");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".T1_MIN");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".T1_MAX");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".IDET_MIN");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".IDET_MAX");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".ICC_MIN");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".ICC_MAX");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".IDD_MIN");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".IDD_MAX");
                    break;
                }
                case 11: {
                    stringBuffer.append(SCTDBInfo.sctdaqDBTableNames[n] + ".I_LEAK_150");
                    stringBuffer.append("," + SCTDBInfo.sctdaqDBTableNames[n] + ".I_LEAK_350");
                    break;
                }
                default: {
                    stringBuffer.append(SCTDBInfo.chipDBnames[0] + SCTDBInfo.DBChipParameterNames[n][n4]);
                    int n5 = 1;
                    while (n5 < SCTDBInfo.chipDBnames.length) {
                        stringBuffer.append("," + SCTDBInfo.chipDBnames[n5] + SCTDBInfo.DBChipParameterNames[n][n4]);
                        ++n5;
                    }
                    break block5;
                }
            }
            stringBuffer.append(" FROM " + SCTDBInfo.sctdaqDBTableNames[n]);
            stringBuffer.append(" WHERE test_no=" + string);
            System.out.println("Interrogating tests table ...");
            if (DEBUG) {
                System.out.println(stringBuffer.toString());
            }
            resultSet = statement.executeQuery(stringBuffer.toString());
            int n6 = 0;
            boolean bl = resultSet.next();
            while (bl) {
                int n7;
                int n8;
                if (n2 == 0) {
                    stringBuffer2.append("<table cellspacing=5 border=1>\n");
                    if (n == 10) {
                        stringBuffer2.append("<tr><td><b>Duration</b></td>");
                        stringBuffer2.append("<td><b>Fail Time</b></td>");
                        stringBuffer2.append("<td><b>T0(min)</b></td>");
                        stringBuffer2.append("<td><b>T0(max)</b></td>");
                        stringBuffer2.append("<td><b>T1(min)</b></td>");
                        stringBuffer2.append("<td><b>T1(max)</b></td>");
                        stringBuffer2.append("<td><b>Idet(min)</b></td>");
                        stringBuffer2.append("<td><b>Idet(max)</b></td>");
                        stringBuffer2.append("<td><b>Icc(min)</b></td>");
                        stringBuffer2.append("<td><b>Icc(max)</b></td>");
                        stringBuffer2.append("<td><b>Idd(min)</b></td>");
                        stringBuffer2.append("<td><b>Idd(max)</b></td></tr>");
                    } else if (n == 0) {
                        stringBuffer2.append("<tr><td><b>Icc NoConf</b></td>");
                        stringBuffer2.append("<td><b>Idd NoConf</b></td>");
                        stringBuffer2.append("<td><b>Icc NoClock</b></td>");
                        stringBuffer2.append("<td><b>Idd NoClock</b></td></tr>\n");
                    } else if (n == 11) {
                        stringBuffer2.append("<tr><td><b>I @ 150V</b></td>");
                        stringBuffer2.append("<td><b>I @ 350V</b></td></tr>\n");
                    } else {
                        n8 = 0;
                        while (n8 < 13) {
                            stringBuffer2.append("<col width=*>\n");
                            ++n8;
                        }
                        stringBuffer2.append("<tr><td><b>Parameter</b></td>");
                        n7 = 0;
                        while (n7 < SCTDBInfo.chipDBnames.length) {
                            stringBuffer2.append("<td><b>" + SCTDBInfo.chipDBnames[n7].substring(0, SCTDBInfo.chipDBnames[n7].length() - 1) + "</b></td>");
                            ++n7;
                        }
                        stringBuffer2.append("</tr>\n");
                    }
                }
                ++n2;
                ++n6;
                switch (n) {
                    case 0: 
                    case 10: 
                    case 11: {
                        stringBuffer2.append("<tr>");
                        break;
                    }
                    default: {
                        stringBuffer2.append("<tr><td>" + SCTDBInfo.fullTestParameterNames[n][n4] + "</td>");
                    }
                }
                if (n == 8 && (n4 == 1 || n4 == 2)) {
                    n8 = 0;
                    while (n8 < SCTDBInfo.chipDBnames.length) {
                        String string2 = resultSet.getString(1 + n8);
                        double d = Double.valueOf(string2);
                        DecimalFormat decimalFormat = new DecimalFormat("0.##E0");
                        stringBuffer2.append("<td>" + decimalFormat.format(d) + "</td>");
                        ++n8;
                    }
                } else if (n == 0) {
                    n8 = 0;
                    while (n8 < 4) {
                        stringBuffer2.append("<td>" + resultSet.getString(1 + n8) + "</td>");
                        ++n8;
                    }
                } else if (n == 10) {
                    n7 = 0;
                    while (n7 < 12) {
                        stringBuffer2.append("<td>" + resultSet.getString(1 + n7) + "</td>");
                        ++n7;
                    }
                } else if (n == 11) {
                    int n9 = 0;
                    while (n9 < 2) {
                        stringBuffer2.append("<td>" + resultSet.getString(1 + n9) + "</td>");
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < SCTDBInfo.chipDBnames.length) {
                        stringBuffer2.append("<td>" + resultSet.getString(1 + n10) + "</td>");
                        ++n10;
                    }
                }
                stringBuffer2.append("</tr>\n");
                bl = resultSet.next();
            }
            ++n4;
        }
        statement.close();
        if (n2 == 0) {
            stringBuffer2.append("No test data found\n");
        } else {
            stringBuffer2.append("</table>\n");
        }
        return stringBuffer2.toString();
    }

    public static String getHTMLDefectTable(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<h2>Defects</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT CHAN_1ST,CHAN_LAST,DEFECT_NAME FROM DEFECTS WHERE TEST_NO=" + string);
        stringBuffer2.append(" ORDER BY CHAN_1ST");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        if (DEBUG) {
            System.out.println(stringBuffer2.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            ++n;
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            String string4 = resultSet.getString(3);
            if (n2 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                int n3 = 0;
                while (n3 < 2) {
                    stringBuffer.append("<col width=*>\n");
                    ++n3;
                }
                stringBuffer.append("<tr><td><b>Channel</b></td><td><b>Defect Type</b></td></tr>\n");
            }
            ++n2;
            String string5 = string2.equals(string3) ? string2 : string2 + "-" + string3;
            stringBuffer.append("<tr><td>" + string5 + "</td><td>" + string4 + "</td></tr>\n");
            bl2 = resultSet.next();
        }
        statement.close();
        if (n2 == 0) {
            stringBuffer.append("No defects found\n");
        } else {
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    public static String getModuleReport(String string) {
        String string2;
        Object object;
        String string3;
        Object object2;
        Object object3;
        Object object4;
        try {
            if (!GeneralUtilities.itemExists(string)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        ModuleInfo moduleInfo = new ModuleInfo(string);
        StringBuffer stringBuffer = new StringBuffer(DaveUtils.getHTMLHeader("Module Summary Report for " + string));
        stringBuffer.append("<h3>Assembly Information</h3>");
        stringBuffer.append("<table border=1>");
        stringBuffer.append("<tr><td>Component</td><td>SerialNo</td><td>Position</td><td colspan=2><b>Details</td></tr>\n");
        int n = 0;
        while (n < SCTDBInfo.moduleParts.length) {
            object4 = moduleInfo.getSerialNo(n);
            String string4 = moduleInfo.getDataSheetTestNo(n);
            string4 = string4 == null ? "Datasheet not available" : "<a href=\"Datasheet&sn=" + (String)object4 + "&testno=" + string4 + "\">Datasheet</a>";
            stringBuffer.append("<tr><td>" + SCTDBInfo.moduleParts[n] + "</td><td>" + (String)object4 + "</td><td>n/a</td><td colspan=2>" + string4 + "</td></tr>\n");
            ++n;
        }
        object4 = moduleInfo.getSensorList();
        if (((Vector)object4).size() == 0) {
            stringBuffer.append("<tr><td>Sensors</td><td></td><td></td><td colspan=2>Data not available</td></tr>\n");
        } else {
            int n2 = 0;
            while (n2 < ((Vector)object4).size()) {
                object3 = (String)((Vector)object4).elementAt(n2);
                object2 = "<a href=Type" + Integer.toString(4) + "&ref=" + (String)object3 + ">All Test Data</a>";
                stringBuffer.append("<tr><td>Sensor</td><td>" + (String)object3 + "</td><td>" + Integer.toString(n2 + 1) + "</td><td colspan=2>" + (String)object2 + "</td></tr>\n");
                ++n2;
            }
        }
        Vector vector = moduleInfo.getAsicList();
        if (vector.size() == 0) {
            stringBuffer.append("<tr><td>ASICs</td><td></td><td></td><td>Data not available</td><td></td></tr>\n");
        } else {
            int n3 = 0;
            while (n3 < vector.size()) {
                object2 = (String)vector.elementAt(n3);
                String string5 = moduleInfo.getASICInfo((String)object2);
                string3 = moduleInfo.getASICcorrFactor((String)object2);
                stringBuffer.append("<tr><td>ASIC</td><td>" + (String)object2 + "</td><td>" + Integer.toString(n3 + 1) + "</td><td>" + string5 + "</td><td>cFactor " + string3 + "</td></tr>\n");
                ++n3;
            }
        }
        stringBuffer.append("</table>");
        stringBuffer.append("<h3>Metrology Data</h3>");
        if (moduleInfo.noMetrologyTests() == 0) {
            stringBuffer.append("No data uploaded.");
        } else {
            stringBuffer.append("<table border=1>");
            stringBuffer.append("<tr><td>Type</td><td>Event</td><td>Status</td><td>Location</td><td>Date</td><td>Data</td></tr>\n");
            int n4 = 0;
            while (n4 < moduleInfo.noMetrologyTests()) {
                object2 = moduleInfo.getMetrologyTest(n4);
                int n5 = ((MetrologyTest)object2).getType().equals("XY") ? 2 : 3;
                string3 = "<a href=Type" + Integer.toString(n5) + "&ref=" + ((MetrologyTest)object2).getTestNo() + "\">Datasheet</a>";
                stringBuffer.append("<tr><td>" + ((MetrologyTest)object2).getType() + "</td><td>" + ((MetrologyTest)object2).getEvent() + "</td><td>" + ((MetrologyTest)object2).getStatus() + "</td><td>" + ((MetrologyTest)object2).getLocation() + "</td><td>" + ((MetrologyTest)object2).getDate() + "</td></td>" + string3 + "</td></tr>");
                ++n4;
            }
            stringBuffer.append("</table>");
        }
        stringBuffer.append("<h3>IV Data</h3>");
        stringBuffer.append("<table border=1>");
        stringBuffer.append("<tr><td>Component</td><td>Location</td><td>Date</td><td>150V</td><td>350V</td><td>500V</td><td>Temperature</td><td>Data</td></tr>\n");
        object3 = new ModuleIVInfo(string, (Vector)object4);
        stringBuffer.append("<tr><td>Sensor Sum</td><td>" + ((ModuleIVInfo)object3).getOrigin() + "</td><td> - </td>");
        double d = ((ModuleIVInfo)object3).geti150SensorCurrent();
        double d2 = ((ModuleIVInfo)object3).geti350SensorCurrent();
        double d3 = ((ModuleIVInfo)object3).geti500SensorCurrent();
        stringBuffer.append("<td>" + decimalFormat.format(d) + "</td><td>" + decimalFormat.format(d2) + "</td><td>" + decimalFormat.format(d3) + "</td><td>" + ((ModuleIVInfo)object3).getTemperatureRange() + "</td><td> - </td></tr>");
        int n6 = 0;
        while (n6 < ((ModuleIVInfo)object3).noModuleIVs()) {
            object = ((ModuleIVInfo)object3).getModuleIV(n6);
            stringBuffer.append("<tr><td>Module</td><td>" + ((ModuleIV)object).getLocation() + "</td><td>" + ((ModuleIV)object).getDate() + "</td>");
            double d4 = ((ModuleIV)object).geti150();
            if (d4 == 0.0) {
                stringBuffer.append("<td> - </td>");
            } else if (d4 > d * 1.25) {
                stringBuffer.append("<td><font color=red>" + decimalFormat.format(d4) + "</td>");
            } else {
                stringBuffer.append("<td>" + decimalFormat.format(d4) + "</td>");
            }
            double d5 = ((ModuleIV)object).geti350();
            if (d5 == 0.0) {
                stringBuffer.append("<td> - </td>");
            } else if (d5 > d2 * 1.25) {
                stringBuffer.append("<td><font color=red>" + decimalFormat.format(d5) + "</td>");
            } else {
                stringBuffer.append("<td>" + decimalFormat.format(d5) + "</td>");
            }
            double d6 = ((ModuleIV)object).geti500();
            if (d6 == 0.0) {
                stringBuffer.append("<td> - </td>");
            } else if (d6 > d3 * 1.25) {
                stringBuffer.append("<td><font color=red>" + decimalFormat.format(d6) + "</td>");
            } else {
                stringBuffer.append("<td>" + decimalFormat.format(d6) + "</td>");
            }
            stringBuffer.append("<td>" + ((ModuleIV)object).getTemperature() + "</td>");
            string2 = ((ModuleIV)object).getLink();
            if (string2 == null) {
                stringBuffer.append("<td> - </td>");
            } else {
                String string6 = string2.endsWith(".ps") || string2.endsWith(".gz") ? Integer.toString(6) : Integer.toString(1);
                stringBuffer.append("<td><a href=Type" + string6 + "&ref=" + string2 + "\">Plot</a></td>");
            }
            stringBuffer.append("</tr>");
            ++n6;
        }
        stringBuffer.append("<tr><td colspan=2 align=right><font color=navy>Category: </font></td><td colspan=6>Not Uploaded</td></tr>");
        stringBuffer.append("<tr><td colspan=2 align=right><font color=navy>Comments: </font></td><td colspan=6>None Uploaded</td></tr>");
        stringBuffer.append("</table>");
        object = new ModuleSCTDAQInfo(string);
        stringBuffer.append("<h3>SCTDAQ Characterisations</h3>");
        stringBuffer.append("<table border=1>");
        stringBuffer.append("<tr><td>Location</td><td>Date</td><td>Temperature</td><td>DeltaT</td><td colspan=2 align=center>Excluding Trim Defects</td><td colspan=2 align=center>Including Trim Defects</td><td>Link</td><td>Failed Tests</td></tr>\n");
        stringBuffer.append("<tr><td></td><td></td><td></td><td></td><td>N(defects)</td><td>N(consecutive)</td><td>N(defects)</td><td>N(consecutive)</td><td></td><td></td></tr>");
        int n7 = 0;
        while (n7 < ((ModuleSCTDAQInfo)object).noTests()) {
            SCTDAQCharacterisation sCTDAQCharacterisation = ((ModuleSCTDAQInfo)object).getCharacterisation(n7);
            String string7 = sCTDAQCharacterisation.getTemperature() > 10.0 ? "Warm" : "Cold";
            double d7 = sCTDAQCharacterisation.getDeltaT();
            String string8 = Math.abs(d7) >= 1.0 ? "<font color=red>" + Double.toString(d7) + "</font>" : Double.toString(d7);
            stringBuffer.append("<tr><td>" + sCTDAQCharacterisation.getLocation() + "</td><td>" + sCTDAQCharacterisation.getDate() + "</td><td>" + string7 + "</td><td>" + string8 + "</td>");
            stringBuffer.append("<td>" + Integer.toString(sCTDAQCharacterisation.nDefects(2)) + "</td><td>" + Integer.toString(sCTDAQCharacterisation.nDefects(3)) + "</td>");
            stringBuffer.append("<td>" + Integer.toString(sCTDAQCharacterisation.nDefects(0)) + "</td><td>" + Integer.toString(sCTDAQCharacterisation.nDefects(1)) + "</td>");
            string2 = string + "__" + sCTDAQCharacterisation.getLocation() + "__" + sCTDAQCharacterisation.getDate() + "__" + string7;
            stringBuffer.append("<td><a href=Type" + Integer.toString(8) + "&ref=" + string2 + "\">SCTDAQ Report</a></td>");
            stringBuffer.append("<td> - </td>");
            stringBuffer.append("</tr>");
            ++n7;
        }
        stringBuffer.append("<tr><td colspan=2 align=right><font color=navy>Category: </font></td><td colspan=8>Not Uploaded</td></tr>");
        stringBuffer.append("<tr><td colspan=2 align=right><font color=navy>Comments: </font></td><td colspan=8>None Uploaded</td></tr>");
        stringBuffer.append("</table>");
        stringBuffer.append(DaveUtils.getHTMLFooter());
        return stringBuffer.toString();
    }

    public static String getSensorMfrHTMLTable(Vector vector) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<h2>General Wafer Properties</h2>\n");
        String string = (String)vector.elementAt(0);
        int n = 1;
        while (n < vector.size()) {
            string = string + "," + vector.elementAt(n);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append(" tests.ser_no,substr_orient,substr_origin,thickness,i_leak_150,i_leak_350,temperature FROM tests,tstdetmfrs");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string + ") AND tests.test_name='DetMfrSheet' AND tstdetmfrs.test_no=tests.test_no");
        stringBuffer2.append(" ORDER BY tests.ser_no");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n2 = 0;
        boolean bl = resultSet.next();
        while (bl) {
            int n3;
            if (n2 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                n3 = 0;
                while (n3 < 4) {
                    stringBuffer.append("<col width=*>\n");
                    ++n3;
                }
                stringBuffer.append("<tr><td><b>Serial Number</b></td><td><b>Orientation</b></td><td><b>Origin</b></td><td><b>Thickness(um)</b></td></tr>");
            }
            ++n2;
            stringBuffer.append("<tr>");
            n3 = 1;
            while (n3 <= 4) {
                stringBuffer.append("<td>" + resultSet.getString(n3) + "</td>");
                ++n3;
            }
            stringBuffer.append("</tr>\n");
            bl = resultSet.next();
        }
        statement.close();
        if (n2 == 0) {
            stringBuffer.append("<p>No data available\n");
        } else {
            stringBuffer.append("</table>");
        }
        return stringBuffer.toString();
    }

    public static String getSensorIVHTMLTable(Vector vector) throws Exception {
        String string;
        Object object;
        Vector vector2;
        String string2;
        Hashtable hashtable;
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
        Vector<Hashtable> vector3 = new Vector<Hashtable>();
        StringBuffer stringBuffer = new StringBuffer("<h2>IV Data</h2>\n");
        String string3 = (String)vector.elementAt(0);
        int n = 1;
        while (n < vector.size()) {
            string3 = string3 + "," + vector.elementAt(n);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append(" tests.ser_no,tests.locn_name,tests.test_date,i_leak_150,i_leak_350,temperature FROM tests,tstdetmfrs");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string3 + ") AND tests.test_name='DetMfrSheet' AND tstdetmfrs.test_no=tests.test_no");
        stringBuffer2.append(" ORDER BY tests.ser_no");
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n2 = 0;
        boolean bl = resultSet.next();
        while (bl) {
            String string4 = resultSet.getString(1);
            hashtable = new Hashtable();
            hashtable.put("SERIALNO", string4);
            hashtable.put("NAME", resultSet.getString(2));
            hashtable.put("DATE", DaveUtils.extractDate(resultSet.getString(3)));
            hashtable.put("I150", resultSet.getString(4));
            hashtable.put("I350", resultSet.getString(5));
            hashtable.put("TEMP", resultSet.getString(6));
            hashtable.put("STATUS", "Pass");
            hashtable.put("COMNTS", "None.");
            vector3.addElement(hashtable);
            ++n2;
            bl = resultSet.next();
        }
        statement.close();
        stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append("tests.test_no,tests.ser_no,tests.locn_name,tests.test_date,tests.problem,tests.pass,tstdetivs.temperature,tstdetivs.i_leak_150,tstdetivs.i_leak_350");
        stringBuffer2.append(" FROM tests,tstdetivs");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string3 + ")");
        stringBuffer2.append(" AND tests.test_name='DetIVscan'");
        stringBuffer2.append(" AND tstdetivs.test_no=tests.test_no");
        stringBuffer2.append(" ORDER BY tests.ser_no,tests.test_no");
        statement = sCTDBInterface.connection.createStatement();
        resultSet = statement.executeQuery(stringBuffer2.toString());
        boolean bl2 = resultSet.next();
        while (bl2) {
            hashtable = new Hashtable();
            string2 = resultSet.getString(2);
            vector2 = hashtable2.containsKey(string2) ? (Vector)hashtable2.get(string2) : new Vector();
            hashtable.put("TESTNO", resultSet.getString(1));
            hashtable.put("SERIALNO", resultSet.getString(2));
            hashtable.put("NAME", resultSet.getString(3));
            hashtable.put("DATE", DaveUtils.extractDate(resultSet.getString(4)));
            object = resultSet.getString(5);
            String string5 = resultSet.getString(6);
            string = string5.equals("YES") ? (((String)object).equals("YES") ? "PROBLEM" : "Pass") : "FAIL";
            hashtable.put("STATUS", string);
            hashtable.put("TEMP", resultSet.getString(7));
            hashtable.put("I150", resultSet.getString(8));
            hashtable.put("I350", resultSet.getString(9));
            vector2.addElement(hashtable);
            hashtable2.put(string2, vector2);
            ++n2;
            bl2 = resultSet.next();
        }
        statement.close();
        string2 = stringBuffer2.toString();
        string2 = string2.substring(string2.indexOf("WHERE"), string2.indexOf("AND tstdetivs") - 1);
        object = GeneralUtilities.testComments(string2);
        int n3 = 0;
        while (n3 < vector3.size()) {
            if (n3 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                int n4 = 0;
                while (n4 < 8) {
                    stringBuffer.append("<col width=*>\n");
                    ++n4;
                }
                stringBuffer.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>I@150V</b></td><td nowrap><b>I@350V</b></td><td nowrap><b>Temp(C)</b></td><td nowrap><b>Status</b></td><td nowrap><b>Remarks</b></td></tr>\n");
            }
            stringBuffer.append("<tr>");
            hashtable = (Hashtable)vector3.elementAt(n3);
            string = (String)hashtable.get("SERIALNO");
            String string6 = (String)hashtable.get("NAME");
            String string7 = (String)hashtable.get("DATE");
            String string8 = (String)hashtable.get("I150");
            String string9 = (String)hashtable.get("I350");
            String string10 = (String)hashtable.get("TEMP");
            String string11 = (String)hashtable.get("STATUS");
            String string12 = (String)hashtable.get("COMNTS");
            stringBuffer.append("<td>" + string + "</td><td>" + string6 + "</td><td>" + string7 + "</td><td>" + string8 + "</td><td>" + string9 + "</td><td>" + string10 + "</td><td>" + string11 + "</td><td>" + string12 + "</td></tr>\n");
            if (hashtable2.containsKey(string)) {
                vector2 = (Vector)hashtable2.get(string);
                int n5 = 0;
                while (n5 < vector2.size()) {
                    hashtable = (Hashtable)vector2.elementAt(n5);
                    String string13 = (String)hashtable.get("TESTNO");
                    string = (String)hashtable.get("SERIALNO");
                    string6 = "<font color=green>" + (String)hashtable.get("NAME") + "</font>";
                    string7 = (String)hashtable.get("DATE");
                    string8 = (String)hashtable.get("I150");
                    string9 = (String)hashtable.get("I350");
                    string10 = (String)hashtable.get("TEMP");
                    string11 = (String)hashtable.get("STATUS");
                    if (!string11.equals("Pass")) {
                        string11 = "<font color=red>" + string11 + "</font>";
                    }
                    string12 = "None.";
                    if (((Hashtable)object).containsKey(string13)) {
                        string12 = (String)((Hashtable)object).get(string13);
                    }
                    if (!string12.equals("None.")) {
                        string12 = "<font color=red>" + string12 + "</font>";
                    }
                    stringBuffer.append("<tr><td>" + string + "</td><td>" + string6 + "</td><td>" + string7 + "</td><td>" + string8 + "</td><td>" + string9 + "</td><td>" + string10 + "</td><td>" + string11 + "</td><td nowrap>" + string12 + "</td></tr>\n");
                    ++n5;
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            stringBuffer.append("<p>No data available\n");
        } else {
            stringBuffer.append("</table>");
        }
        return stringBuffer.toString();
    }

    public static String getSensorDepletionHTMLTable(Vector vector) throws Exception {
        String string;
        Object object;
        Vector vector2;
        String string2;
        Hashtable hashtable;
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
        Vector<Hashtable> vector3 = new Vector<Hashtable>();
        StringBuffer stringBuffer = new StringBuffer("<h2>Depletion Voltages</h2>\n");
        String string3 = (String)vector.elementAt(0);
        int n = 1;
        while (n < vector.size()) {
            string3 = string3 + "," + vector.elementAt(n);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append(" tests.ser_no,tests.locn_name,tests.test_date,v_dep FROM tests,tstdetmfrs");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string3 + ") AND tests.test_name='DetMfrSheet' AND tstdetmfrs.test_no=tests.test_no");
        stringBuffer2.append(" ORDER BY tests.ser_no");
        Statement statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating tests and tstdetmfrs tables for depletion...");
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n2 = 0;
        boolean bl = resultSet.next();
        while (bl) {
            String string4 = resultSet.getString(1);
            hashtable = new Hashtable();
            hashtable.put("SERIALNO", string4);
            hashtable.put("NAME", resultSet.getString(2));
            hashtable.put("DATE", DaveUtils.extractDate(resultSet.getString(3)));
            hashtable.put("VDEP", resultSet.getString(4));
            hashtable.put("STATUS", "Pass");
            hashtable.put("COMNTS", "None.");
            vector3.addElement(hashtable);
            ++n2;
            bl = resultSet.next();
        }
        statement.close();
        stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append("tests.test_no,tests.ser_no,tests.locn_name,tests.test_date,tests.problem,tests.pass,tstdetopts.v_dep");
        stringBuffer2.append(" FROM tests,tstdetopts");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string3 + ")");
        stringBuffer2.append(" AND tests.test_name='DetVDep'");
        stringBuffer2.append(" AND tstdetopts.test_no=tests.test_no");
        stringBuffer2.append(" ORDER BY tests.ser_no,tests.test_no");
        statement = sCTDBInterface.connection.createStatement();
        resultSet = statement.executeQuery(stringBuffer2.toString());
        boolean bl2 = resultSet.next();
        while (bl2) {
            hashtable = new Hashtable();
            string2 = resultSet.getString(2);
            vector2 = hashtable2.containsKey(string2) ? (Vector)hashtable2.get(string2) : new Vector();
            hashtable.put("TESTNO", resultSet.getString(1));
            hashtable.put("SERIALNO", resultSet.getString(2));
            hashtable.put("NAME", resultSet.getString(3));
            hashtable.put("DATE", DaveUtils.extractDate(resultSet.getString(4)));
            object = resultSet.getString(5);
            String string5 = resultSet.getString(6);
            string = string5.equals("YES") ? (((String)object).equals("YES") ? "PROBLEM" : "Pass") : "FAIL";
            hashtable.put("STATUS", string);
            hashtable.put("VDEP", resultSet.getString(7));
            vector2.addElement(hashtable);
            hashtable2.put(string2, vector2);
            ++n2;
            bl2 = resultSet.next();
        }
        statement.close();
        string2 = stringBuffer2.toString();
        string2 = string2.substring(string2.indexOf("WHERE"), string2.indexOf("AND tstdetopts") - 1);
        object = GeneralUtilities.testComments(string2);
        int n3 = 0;
        while (n3 < vector3.size()) {
            if (n3 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                int n4 = 0;
                while (n4 < 8) {
                    stringBuffer.append("<col width=*>\n");
                    ++n4;
                }
                stringBuffer.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>Depletion</b></td><td nowrap><b>Status</b></td><td nowrap><b>Remarks</b></td></tr>\n");
            }
            stringBuffer.append("<tr>");
            hashtable = (Hashtable)vector3.elementAt(n3);
            string = (String)hashtable.get("SERIALNO");
            String string6 = (String)hashtable.get("NAME");
            String string7 = (String)hashtable.get("DATE");
            String string8 = (String)hashtable.get("VDEP");
            String string9 = (String)hashtable.get("STATUS");
            String string10 = (String)hashtable.get("COMNTS");
            stringBuffer.append("<td>" + string + "</td><td>" + string6 + "</td><td>" + string7 + "</td><td>" + string8 + "</td><td>" + string9 + "</td><td>" + string10 + "</td></tr>\n");
            if (hashtable2.containsKey(string)) {
                vector2 = (Vector)hashtable2.get(string);
                int n5 = 0;
                while (n5 < vector2.size()) {
                    hashtable = (Hashtable)vector2.elementAt(n5);
                    String string11 = (String)hashtable.get("TESTNO");
                    string = (String)hashtable.get("SERIALNO");
                    string6 = "<font color=green>" + (String)hashtable.get("NAME") + "</font>";
                    string7 = (String)hashtable.get("DATE");
                    string8 = (String)hashtable.get("VDEP");
                    string9 = (String)hashtable.get("STATUS");
                    if (!string9.equals("Pass")) {
                        string9 = "<font color=red>" + string9 + "</font>";
                    }
                    string10 = "None.";
                    if (((Hashtable)object).containsKey(string11)) {
                        string10 = (String)((Hashtable)object).get(string11);
                    }
                    if (!string10.equals("None.")) {
                        string10 = "<font color=red>" + string10 + "</font>";
                    }
                    stringBuffer.append("<tr><td>" + string + "</td><td>" + string6 + "</td><td>" + string7 + "</td><td>" + string8 + "</td><td>" + string9 + "</td><td nowrap>" + string10 + "</td></tr>\n");
                    ++n5;
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            stringBuffer.append("<p>No data available\n");
        } else {
            stringBuffer.append("</table>");
        }
        return stringBuffer.toString();
    }

    public static String getSensorDefectHTMLTable(Vector vector) throws Exception {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string2;
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Vector vector2 = new Vector();
        String string3 = (String)vector.elementAt(0);
        int n6 = 1;
        while (n6 < vector.size()) {
            string3 = string3 + "," + vector.elementAt(n6);
            ++n6;
        }
        Vector<String> vector3 = new Vector<String>();
        String[] stringArray = new String[]{"Pinhole", "Oxide-Punchthrough", "Short", "Open", "Implant-Open", "Implant-Short", "Resistor-Break"};
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n7 = stringArray.length;
        Hashtable[] hashtableArray = new Hashtable[n7];
        Hashtable[] hashtableArray2 = new Hashtable[n7];
        StringBuffer stringBuffer = new StringBuffer("<h2>Defects Summary</h2>\n");
        int n8 = 0;
        while (n8 < n7) {
            hashtable.put(stringArray[n8], new Integer(n8));
            hashtableArray[n8] = new Hashtable();
            hashtableArray2[n8] = new Hashtable();
            ++n8;
        }
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
        String string4 = "";
        String string5 = "";
        StringBuffer stringBuffer2 = new StringBuffer("SELECT tests.test_no,tests.ser_no,tests.test_date,tests.locn_name FROM tests");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string3 + ")");
        stringBuffer2.append(" AND ( tests.test_name='DetDefect' OR tests.test_name='DetMfrSheet')");
        stringBuffer2.append(" ORDER BY tests.ser_no,tests.test_no");
        String string6 = stringBuffer2.toString();
        System.out.println("Interrogating tests table for defects");
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string6);
        int n9 = 0;
        boolean bl = resultSet.next();
        while (bl) {
            ++n9;
            string4 = resultSet.getString(2);
            string5 = resultSet.getString(1);
            string2 = resultSet.getString(3);
            string2 = DaveUtils.extractDate(string2);
            hashtable4.put(string5, string2);
            String string7 = resultSet.getString(4);
            hashtable5.put(string5, string7);
            n5 = 0;
            while (n5 < n7) {
                hashtableArray[n5].put(string5, new Integer(0));
                hashtableArray2[n5].put(string5, "");
                ++n5;
            }
            hashtable2.put(string5, new Integer(0));
            hashtable3.put(string5, string4);
            vector3.addElement(string5);
            bl = resultSet.next();
        }
        statement.close();
        string2 = string6;
        int n10 = string2.indexOf("FROM");
        n5 = string2.indexOf("ORDER") - 1;
        string2 = "SELECT tests.test_no " + string2.substring(n10, n5);
        stringBuffer2 = new StringBuffer("SELECT tests.ser_no,tests.test_no,defect_name,chan_1st,chan_last");
        stringBuffer2.append(" FROM tests,defects");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string3 + ")");
        stringBuffer2.append(" AND defects.test_no=tests.test_no");
        stringBuffer2.append(" AND tests.test_no IN (" + string2 + ")");
        stringBuffer2.append(" ORDER BY tests.ser_no,tests.test_no");
        String string8 = stringBuffer2.toString();
        System.out.println("Interrogating defects table");
        statement = sCTDBInterface.connection.createStatement();
        resultSet = statement.executeQuery(string8);
        boolean bl2 = resultSet.next();
        while (bl2) {
            ++n9;
            string4 = resultSet.getString(1);
            string5 = resultSet.getString(2);
            String string9 = resultSet.getString(3);
            String string10 = resultSet.getString(4);
            String string11 = resultSet.getString(5);
            n4 = Integer.parseInt(string10);
            n3 = Integer.parseInt(string11);
            if (hashtable.containsKey(string9)) {
                n2 = (Integer)hashtable.get(string9);
                int n11 = (Integer)hashtableArray[n2].get(string5);
                n = (Integer)hashtable2.get(string5);
                string = (String)hashtableArray2[n2].get(string5);
                int n12 = n4;
                while (n12 <= n3) {
                    if (!string.equals("")) {
                        string = string + ",";
                    }
                    string = string + Integer.toString(n12);
                    ++n11;
                    ++n;
                    ++n12;
                }
                hashtableArray[n2].put(string5, new Integer(n11));
                hashtableArray2[n2].put(string5, string);
                hashtable2.put(string5, new Integer(n));
            } else {
                System.out.println("**WARNING** Strange defect declaration for " + string4 + " was ignored: " + string9);
            }
            bl2 = resultSet.next();
        }
        statement.close();
        n4 = 0;
        while (n4 < vector3.size()) {
            if (n4 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                n3 = 0;
                while (n3 < 11) {
                    stringBuffer.append("<col width=* nowrap>\n");
                    ++n3;
                }
                stringBuffer.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>#Defects</b></td>");
                n2 = 0;
                while (n2 < n7) {
                    if (stringArray[n2].equals("Oxide-Punchthrough")) {
                        stringBuffer.append("<td nowrap><b>Oxide-PT</b></td>");
                    } else if (stringArray[n2].equals("Implant-Open")) {
                        stringBuffer.append("<td nowrap><b>Implant-O</b></td>");
                    } else if (stringArray[n2].equals("Implant-Short")) {
                        stringBuffer.append("<td nowrap><b>Implant-S</b></td>");
                    } else if (stringArray[n2].equals("Resistor-Break")) {
                        stringBuffer.append("<td nowrap><b>Resistor</b></td>");
                    } else {
                        stringBuffer.append("<td nowrap><b>" + stringArray[n2] + "</b></td>");
                    }
                    ++n2;
                }
            }
            stringBuffer.append("\n<tr>");
            Vector vector4 = new Vector();
            String string12 = (String)vector3.elementAt(n4);
            String string13 = (String)hashtable3.get(string12);
            stringBuffer.append("<td>" + string13 + "</td>");
            String string14 = (String)hashtable5.get(string12);
            if (!string14.equals("Hamamatsu") && !string14.equals("CiS")) {
                string14 = "<font color=green>" + string14 + "</font>";
            }
            stringBuffer.append("<td>" + string14 + "</td>");
            stringBuffer.append("<td>" + (String)hashtable4.get(string12) + "</td>");
            stringBuffer.append("<td>" + ((Integer)hashtable2.get(string12)).toString() + "</td>");
            n = 0;
            while (n < n7) {
                string = (String)hashtableArray2[n].get(string12);
                if (!string.equals("")) {
                    string = " (" + string + ")";
                }
                stringBuffer.append("<td nowrap>" + ((Integer)hashtableArray[n].get(string12)).toString() + string + "</td>");
                ++n;
            }
            stringBuffer.append("</tr>");
            ++n4;
        }
        if (n9 == 0) {
            stringBuffer.append("No data available...");
        } else {
            stringBuffer.append("\n</table>");
        }
        return stringBuffer.toString();
    }

    public static String getSensorVisualTestHTMLTable(Vector vector) throws Exception {
        CharSequence charSequence;
        Object object;
        Object object2;
        Object object3;
        String string = "TESTNO";
        String string2 = "SERIALNO";
        String string3 = "DATE";
        String string4 = "LOCN";
        String string5 = "FLAG";
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Vector<Object> vector2 = new Vector<Object>();
        String string6 = (String)vector.elementAt(0);
        int n = 1;
        while (n < vector.size()) {
            string6 = string6 + "," + vector.elementAt(n);
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer("<h2>Visual Inspection Results</h2>\n");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT ");
        stringBuffer2.append("tests.test_no,tests.ser_no,tests.test_date,tests.locn_name,tests.problem,tests.pass");
        stringBuffer2.append(" FROM tests");
        stringBuffer2.append(" WHERE tests.ser_no IN (" + string6 + ")");
        stringBuffer2.append(" AND tests.test_name='Visual_Inspection'");
        stringBuffer2.append(" ORDER BY tests.ser_no,tests.test_no");
        System.out.println("Interrogating tests and tstdetivs tables for visual inspections...");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        int n2 = 0;
        boolean bl = resultSet.next();
        while (bl) {
            object3 = new Hashtable();
            ++n2;
            object2 = resultSet.getString(1);
            ((Hashtable)object3).put(string2, resultSet.getString(2));
            object = resultSet.getString(3);
            ((Hashtable)object3).put(string3, DaveUtils.extractDate((String)object));
            ((Hashtable)object3).put(string4, "<font color=green>" + resultSet.getString(4) + "</font>");
            charSequence = resultSet.getString(5);
            String string7 = resultSet.getString(6);
            String string8 = string7.equals("YES") ? (((String)charSequence).equals("YES") ? "<font color=red>PROBLEM</font>" : "Pass") : "<font color=red>FAIL</font>";
            ((Hashtable)object3).put(string5, string8);
            hashtable.put(object2, object3);
            vector2.addElement(object2);
            bl = resultSet.next();
        }
        statement.close();
        object3 = stringBuffer2.toString();
        object3 = ((String)object3).substring(((String)object3).indexOf("WHERE"), ((String)object3).indexOf("ORDER") - 1);
        object2 = GeneralUtilities.testComments((String)object3);
        object = GeneralUtilities.testImages((String)object3);
        charSequence = new StringBuffer("\n<h2>Image List:</h2>\n");
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector2.size()) {
            if (n4 == 0) {
                stringBuffer.append("<table cellspacing=5 border=1>\n");
                int n5 = 0;
                while (n5 < 6) {
                    stringBuffer.append("<col width=* nowrap>\n");
                    ++n5;
                }
                stringBuffer.append("<tr><td nowrap><b>Serial Number</b></td><td nowrap><b>Location</b></td><td nowrap><b>Date</b></td><td nowrap><b>Status</b></td><td nowrap><b>Remarks</b></td><td><b>Pictures</b></td>");
            }
            stringBuffer.append("\n<tr>");
            String string9 = (String)vector2.elementAt(n4);
            Hashtable hashtable2 = (Hashtable)hashtable.get(string9);
            stringBuffer.append("<td>" + (String)hashtable2.get(string2) + "</td>");
            stringBuffer.append("<td>" + (String)hashtable2.get(string4) + "</td>");
            stringBuffer.append("<td>" + (String)hashtable2.get(string3) + "</td>");
            stringBuffer.append("<td>" + (String)hashtable2.get(string5) + "</td>");
            if (((Hashtable)object2).containsKey(string9)) {
                stringBuffer.append("<td nowrap>" + (String)((Hashtable)object2).get(string9) + "</td>");
            } else {
                stringBuffer.append("<td></td>");
            }
            if (((Hashtable)object).containsKey(string9)) {
                Vector vector3 = (Vector)((Hashtable)object).get(string9);
                int n6 = 0;
                while (n6 < vector3.size() / 2) {
                    ++n3;
                    String string10 = (String)vector3.elementAt(2 * n6);
                    String string11 = (String)vector3.elementAt(2 * n6 + 1);
                    File file = new File(PreferencesInterface.getInstance().getPreference(3), string11);
                    GeneralUtilities.saveImage(string9, string11, file);
                    ((StringBuffer)charSequence).append("\n<p>" + string10 + ":");
                    ((StringBuffer)charSequence).append("\n<p><img src=" + string11 + ">");
                    if (n6 == 0) {
                        stringBuffer.append("<td nowrap>" + string10 + "</td></tr>");
                    } else {
                        stringBuffer.append("\n<tr>");
                        stringBuffer.append("<td>" + (String)hashtable2.get(string2) + "</td>");
                        stringBuffer.append("<td></td>");
                        stringBuffer.append("<td></td>");
                        stringBuffer.append("<td></td>");
                        stringBuffer.append("<td></td>");
                        stringBuffer.append("<td nowrap>" + string10 + "</td>");
                        stringBuffer.append("</tr>");
                    }
                    ++n6;
                }
            } else {
                stringBuffer.append("<td></td></tr>");
            }
            ++n4;
        }
        if (n2 == 0) {
            stringBuffer.append("No data available ...");
        } else {
            stringBuffer.append("</table>");
        }
        if (n3 > 0) {
            stringBuffer.append((StringBuffer)charSequence);
        }
        return stringBuffer.toString();
    }

    public static String getHTMLModuleSummaryData(String string) throws Exception {
        int n;
        String string2;
        Object object;
        Object object2;
        String string3;
        int n2;
        String string4;
        String string5;
        Object object3;
        Object object4;
        Object object5;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        String string6;
        String string7;
        Object object6;
        int n10;
        Object object7;
        HTMLReportUtilities.fillHashes();
        String[] stringArray = string.split("__");
        String string8 = stringArray[0];
        String string9 = stringArray[1];
        String string10 = stringArray[2];
        boolean bl = stringArray[3].equals("Warm");
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        StringBuffer stringBuffer = new StringBuffer(" AND (tests.test_name LIKE 'Hyb%' OR tests.test_name LIKE 'DetModIV')");
        stringBuffer.append(" AND tests.locn_name='" + string9 + "' AND tests.test_date='" + string10 + "'");
        if (bl) {
            stringBuffer.append(" AND sct_tstdcsinfo.t0>10 AND sct_tstdcsinfo.test_no=tests.test_no");
        } else {
            stringBuffer.append(" AND sct_tstdcsinfo.t0<=10 AND sct_tstdcsinfo.test_no=tests.test_no");
        }
        StringBuffer stringBuffer2 = new StringBuffer("<h2>Test Data</h2>\n");
        StringBuffer stringBuffer3 = new StringBuffer("SELECT tests.test_no,defects.CHAN_1ST,defects.CHAN_LAST FROM tests,DEFECTS,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=defects.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        Statement statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating defects table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer3.toString());
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl2 = resultSet.next();
        while (bl2) {
            object7 = resultSet.getString(1);
            n10 = Integer.parseInt(resultSet.getString(2));
            int n11 = Integer.parseInt(resultSet.getString(3));
            int n12 = 0;
            int n13 = n10;
            while (n13 <= n11) {
                ++n12;
                ++n13;
            }
            if (hashtable.containsKey(object7)) {
                object6 = (String)hashtable.get(object7);
                int n14 = Integer.parseInt((String)object6);
                hashtable.put(object7, Integer.toString(n14 += n12));
            } else {
                hashtable.put(object7, Integer.toString(n12));
            }
            bl2 = resultSet.next();
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no,tests.test_name,test_rawdata.filename FROM tests,test_rawdata,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=test_rawdata.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        object7 = new Hashtable();
        n10 = resultSet.next() ? 1 : 0;
        while (n10 == 1) {
            String string11 = resultSet.getString(1);
            String string12 = resultSet.getString(2);
            String string13 = resultSet.getString(3);
            object6 = "Raw Data";
            if (string12.equals("Hyb3PGain") || string12.equals("HybRC")) {
                object6 = "RC";
            }
            if (string12.equals("HybTrim")) {
                object6 = "Trim/Mask";
            }
            String string14 = "Type7&ref=" + string11;
            if (((Hashtable)object7).containsKey(string11)) {
                string7 = (String)((Hashtable)object7).get(string11);
                string7 = string7 + "<br><a href=" + string14 + ">" + (String)object6 + "</a>";
                ((Hashtable)object7).put(string11, string7);
            } else {
                ((Hashtable)object7).put(string11, "<a href=" + string14 + ">" + (String)object6 + "</a>");
            }
            n10 = resultSet.next() ? 1 : 0;
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no,tests.ser_no,web_links.web_link_desc,web_links.url FROM tests,web_links,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=web_links.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating web_links table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        boolean bl3 = resultSet.next();
        while (bl3) {
            String string15 = resultSet.getString(1);
            object6 = resultSet.getString(2);
            String string16 = resultSet.getString(3);
            string7 = resultSet.getString(4);
            if (string7.indexOf("http://hepunx.rl.ac.uk/atlassct/cgibin/getfile.pl?file=") != -1) {
                string7 = string7 + "&module=" + (String)object6;
            }
            string7 = "Type6&ref=" + string7;
            if (hashtable2.containsKey(string15)) {
                string6 = (String)hashtable2.get(string15);
                string6 = string6 + "<br><a href=" + string7 + ">" + string16 + "</a>";
                hashtable2.put(string15, string6);
            } else {
                hashtable2.put(string15, "<a href=" + string7 + ">" + string16 + "</a>");
            }
            bl3 = resultSet.next();
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no,tr_type");
        int n15 = 0;
        while (n15 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n15] + "tr_ntrim");
            ++n15;
        }
        stringBuffer3.append(" FROM tests,sct_tsthybtrim,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=sct_tsthybtrim.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(" AND tests.test_name LIKE 'HybTrim'");
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating HybTrim table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        object6 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        boolean bl4 = resultSet.next();
        while (bl4) {
            string6 = resultSet.getString(1);
            String string17 = resultSet.getString(2);
            ((Hashtable)object6).put(string6, string17);
            int n16 = 0;
            n9 = 0;
            while (n9 < SCTDBInfo.chipDBnames.length) {
                String string18 = resultSet.getString(3 + n9);
                n8 = Integer.parseInt(string18);
                n16 += 128 - n8;
                ++n9;
            }
            if (n16 > 0) {
                hashtable3.put(string6, Integer.toString(n16) + " channels masked");
            }
            bl4 = resultSet.next();
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no");
        int n17 = 0;
        while (n17 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n17] + "DELAY");
            ++n17;
        }
        stringBuffer3.append(" FROM tests,sct_tsthybdelay,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=sct_tsthybdelay.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(" AND tests.test_name LIKE 'HybDelay'");
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating HybDelay table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        boolean bl5 = resultSet.next();
        while (bl5) {
            String string19 = resultSet.getString(1);
            n9 = 1000;
            int n18 = 0;
            n8 = 0;
            while (n8 < SCTDBInfo.chipDBnames.length) {
                String string20 = resultSet.getString(2 + n8);
                n7 = Integer.parseInt(string20);
                if (n7 > n18) {
                    n18 = n7;
                }
                if (n7 < n9) {
                    n9 = n7;
                }
                ++n8;
            }
            hashtable3.put(string19, "Delay from " + n9 + " to " + n18);
            bl5 = resultSet.next();
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no");
        int n19 = 0;
        while (n19 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n19] + "RC_MN_GAIN");
            ++n19;
        }
        n9 = 0;
        while (n9 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n9] + "RC_MN_ENC");
            ++n9;
        }
        stringBuffer3.append(" FROM tests,sct_tsthybrc,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=sct_tsthybrc.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating HybRC table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        boolean bl6 = resultSet.next();
        while (bl6) {
            String string21 = resultSet.getString(1);
            double d = 1000.0;
            double d2 = 0.0;
            n6 = 99000;
            int n20 = 0;
            int n21 = 0;
            while (n21 < SCTDBInfo.chipDBnames.length) {
                double d3 = Double.valueOf(resultSet.getString(2 + n21));
                if (d3 > d2) {
                    d2 = d3;
                }
                if (d3 < d) {
                    d = d3;
                }
                ++n21;
            }
            n5 = 0;
            while (n5 < SCTDBInfo.chipDBnames.length) {
                n4 = Integer.valueOf(resultSet.getString(14 + n5));
                if (n4 > n20) {
                    n20 = n4;
                }
                if (n4 < n6) {
                    n6 = n4;
                }
                ++n5;
            }
            hashtable3.put(string21, "Gain from " + d + " to " + d2 + "mV/fC<br>Noise from " + n6 + " to " + n20 + " ENC");
            bl6 = resultSet.next();
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no");
        int n22 = 0;
        while (n22 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n22] + "NO_MN_OCC");
            ++n22;
        }
        int n23 = 0;
        while (n23 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n23] + "NO_NSE");
            ++n23;
        }
        stringBuffer3.append(" FROM tests,sct_tsthybnoise,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=sct_tsthybnoise.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(" AND tests.test_name LIKE 'HybNoise'");
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating noise table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        n7 = resultSet.next() ? 1 : 0;
        while (n7 == 1) {
            String string22 = resultSet.getString(1);
            double d = 1000.0;
            double d4 = 0.0;
            n5 = 99000;
            n4 = 0;
            int n24 = 0;
            while (n24 < SCTDBInfo.chipDBnames.length) {
                double d5 = Double.valueOf(resultSet.getString(2 + n24));
                if (d5 > d4) {
                    d4 = d5;
                }
                if (d5 < d) {
                    d = d5;
                }
                ++n24;
            }
            n3 = 0;
            while (n3 < SCTDBInfo.chipDBnames.length) {
                int n25 = Integer.valueOf(resultSet.getString(14 + n3));
                if (n25 > n4) {
                    n4 = n25;
                }
                if (n25 < n5) {
                    n5 = n25;
                }
                ++n3;
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.##E0");
            object5 = decimalFormat.format(d);
            object4 = decimalFormat.format(d4);
            hashtable3.put(string22, "Occupancy at 1fC from " + (String)object5 + " to " + (String)object4 + "<brEstimated ENC from " + n5 + " to " + n4 + " ENC");
            n7 = resultSet.next() ? 1 : 0;
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no");
        int n26 = 0;
        while (n26 < SCTDBInfo.chipDBnames.length) {
            stringBuffer3.append("," + SCTDBInfo.chipDBnames[n26] + "TW");
            ++n26;
        }
        stringBuffer3.append(" FROM tests,sct_tsthybTW,sct_tstdcsinfo");
        stringBuffer3.append(" WHERE tests.test_no=sct_tsthybtw.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating TimeWalk table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        int n27 = 0;
        n6 = resultSet.next() ? 1 : 0;
        while (n6 == 1) {
            String string23 = resultSet.getString(1);
            double d = 1000.0;
            double d6 = 0.0;
            ++n27;
            n3 = 0;
            while (n3 < SCTDBInfo.chipDBnames.length) {
                double d7 = Double.valueOf(resultSet.getString(2 + n3));
                if (d7 > d6) {
                    d6 = d7;
                }
                if (d7 < d) {
                    d = d7;
                }
                ++n3;
            }
            hashtable3.put(string23, "Timewalk from " + d + " to " + d6 + " ns");
            n6 = resultSet.next() ? 1 : 0;
        }
        statement.close();
        stringBuffer3 = new StringBuffer("SELECT tests.test_no,tests.test_name,tests.test_date,tests.locn_name,tests.pass,tests.problem,sct_tstdcsinfo.t0,sct_tstdcsinfo.t1");
        stringBuffer3.append(" FROM tests,sct_tstdcsinfo WHERE tests.test_no=sct_tstdcsinfo.test_no AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        stringBuffer3.append(" ORDER BY tests.test_date,tests.test_no");
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating tests table ...");
        resultSet = statement.executeQuery(stringBuffer3.toString());
        int n28 = 0;
        boolean bl7 = resultSet.next();
        while (bl7) {
            String string24;
            if (n28 == 0) {
                stringBuffer2.append("<table cellspacing=5 border=1>\n");
                int n29 = 0;
                while (n29 < 10) {
                    stringBuffer2.append("<col width=*>\n");
                    ++n29;
                }
                stringBuffer2.append("<tr><td valign=top align=left><b>Test</b></td><td valign=top align=left><b>Date</b></td><td valign=top align=left><b>Location</b></td><td valign=top align=left><b>Status</b></td><td valign=top align=left><b>T0</b></td><td valign=top align=left><b>T1</b></td><td valign=top align=left><b>Comments</b></td><td valign=top align=left><b>Summary</b></td><td valign=top align=left><b>Raw Data</b></td><td valign=top align=left><b>Plots</b></td></tr>\n");
            }
            String string25 = resultSet.getString(1);
            String string26 = resultSet.getString(2);
            String string27 = string24 = sctdaqTestNameHash.containsKey(string26) ? (String)sctdaqTestNameHash.get(string26) : string26;
            if (((Hashtable)object6).containsKey(string25)) {
                string24 = string24 + "Range " + (String)((Hashtable)object6).get(string25);
            }
            String string28 = DaveUtils.extractDate(resultSet.getString(3));
            String string29 = resultSet.getString(4);
            object5 = resultSet.getString(5);
            object4 = resultSet.getString(6);
            object3 = "FAIL";
            if (((String)object5).equals("YES")) {
                object3 = ((String)object4).equals("YES") ? "Problem" : "Pass";
            }
            String string30 = resultSet.getString(7);
            string5 = resultSet.getString(8);
            string4 = "";
            if (hashtable3.containsKey(string25)) {
                if (!string4.equals("")) {
                    string4 = string4 + "<br>";
                }
                string4 = string4 + (String)hashtable3.get(string25);
            }
            if (hashtable.containsKey(string25)) {
                if (!string4.equals("")) {
                    string4 = string4 + "<br>";
                }
                string4 = string4 + "<b>" + (String)hashtable.get(string25) + " defect(s)</b>";
            } else {
                if (!string4.equals("")) {
                    string4 = string4 + "<br>";
                }
                string4 = string4 + "No defects";
            }
            n2 = -1;
            if (sctdaqTestNumberHash.containsKey(string26)) {
                n2 = (Integer)sctdaqTestNumberHash.get(string26);
            }
            string3 = string24.indexOf("TrimRange") != -1 ? "TrimRange" : string24;
            Object object8 = object2 = n2 == -1 ? "" : "<a href=\"Type5&ref=" + string25 + "__" + Integer.toString(n2) + "\">Test Report</a>";
            if (!sctdaqTestNameHash.containsKey(string26)) {
                object2 = "";
            }
            object = ((Hashtable)object7).containsKey(string25) ? (String)((Hashtable)object7).get(string25) : "";
            string2 = hashtable2.containsKey(string25) ? (String)hashtable2.get(string25) : "";
            stringBuffer2.append("<tr><td valign=top align=left>" + string24 + "</td><td valign=top align=left>" + string28 + "</td><td valign=top align=left>" + string29 + "</td>");
            stringBuffer2.append("<td valign=top align=left>" + (String)object3 + "</td><td valign=top align=left>" + string30 + "</td><td valign=top align=left>" + string5 + "</td><td valign=top align=left>" + string4 + "</td>");
            stringBuffer2.append("<td valign=top align=left>" + (String)object2 + "</td><td valign=top align=left>" + (String)object + "</td><td valign=top align=left>" + string2 + "</td></tr>\n");
            ++n28;
            bl7 = resultSet.next();
        }
        statement.close();
        if (n28 == 0) {
            stringBuffer2.append("<p>No tests found for " + string8 + "\n");
            return stringBuffer2.toString();
        }
        stringBuffer2.append("</table>\n");
        stringBuffer2.append("<p><font face=Arial color=NAVY size=+1>Defects</font>\n");
        stringBuffer3 = new StringBuffer("SELECT tests.test_no,tests.test_name,tests.test_date,tests.locn_name,CHAN_1ST,CHAN_LAST,DEFECT_NAME FROM DEFECTS,tests,sct_tstdcsinfo WHERE tests.test_no=defects.test_no");
        stringBuffer3.append(" AND tests.ser_no=" + string8);
        stringBuffer3.append(stringBuffer);
        stringBuffer3.append(" ORDER by defects.chan_1st,tests.test_date,tests.test_no");
        statement = sCTDBInterface.connection.createStatement();
        System.out.println("Interrogating defects table ...");
        if (DEBUG) {
            System.out.println(stringBuffer3.toString());
        }
        resultSet = statement.executeQuery(stringBuffer3.toString());
        boolean bl8 = false;
        n28 = 0;
        int n30 = 0;
        int n31 = 0;
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        object5 = new Hashtable();
        object4 = new Vector();
        object3 = new Vector();
        boolean bl9 = resultSet.next();
        while (bl9) {
            Object object9;
            string5 = resultSet.getString(1);
            string4 = resultSet.getString(2);
            String string31 = string4 = sctdaqTestNameHash.containsKey(string4) ? (String)sctdaqTestNameHash.get(string4) : string4;
            if (((Hashtable)object6).containsKey(string5)) {
                string4 = string4 + "Range " + (String)((Hashtable)object6).get(string5);
            }
            n2 = string4.indexOf("Trim") != -1 ? 1 : 0;
            string3 = DaveUtils.extractDate(resultSet.getString(3));
            object2 = resultSet.getString(4);
            object = resultSet.getString(5);
            string2 = resultSet.getString(6);
            int n32 = Integer.parseInt((String)object);
            n = Integer.parseInt(resultSet.getString(6));
            String string32 = resultSet.getString(7);
            int n33 = n - n32;
            Object object10 = n33 > 0 ? (String)object + "-" + string2 : object;
            String string33 = string32 + " (" + string4 + " at " + (String)object2 + " on " + string3 + ")";
            int n34 = n32;
            while (n34 <= n) {
                object9 = Integer.toString(n34);
                if (!((Hashtable)object5).containsKey(object9)) {
                    int n35 = n2 != 0 ? 1 : 2;
                    ((Hashtable)object5).put(object9, new Integer(n35));
                } else {
                    Integer n36 = (Integer)((Hashtable)object5).get(object9);
                    int n37 = n36;
                    n37 = n2 != 0 ? (n37 |= 1) : (n37 |= 2);
                    ((Hashtable)object5).put(object9, new Integer(n37));
                }
                ++n34;
            }
            if (n33 > 0) {
                n30 = ++n33 > n30 ? n33 : n30;
                int n38 = n31 = n33 > n31 && n2 == 0 ? n33 : n31;
            }
            if (string4.indexOf("Trim") == -1) {
                if (hashtable4.containsKey(object10)) {
                    object9 = (Vector)hashtable4.get(object10);
                    if (!((Vector)object9).contains(string33)) {
                        ((Vector)object9).addElement(string33);
                    }
                    hashtable4.put(object10, object9);
                } else {
                    ((Vector)object4).addElement(object10);
                    object9 = new Vector<String>();
                    ((Vector)object9).addElement(string33);
                    hashtable4.put(object10, object9);
                }
            } else if (hashtable5.containsKey(object10)) {
                object9 = (Vector)hashtable5.get(object10);
                if (!((Vector)object9).contains(string33)) {
                    ((Vector)object9).addElement(string33);
                }
                hashtable5.put(object10, object9);
            } else {
                ((Vector)object3).addElement(object10);
                object9 = new Vector();
                ((Vector)object9).addElement(string33);
                hashtable5.put(object10, object9);
            }
            bl9 = resultSet.next();
        }
        statement.close();
        int n39 = 0;
        int n40 = 0;
        n2 = 0;
        int n41 = 0;
        object2 = ((Hashtable)object5).elements();
        while (object2.hasMoreElements()) {
            object = (Integer)object2.nextElement();
            int n42 = (Integer)object;
            if (n42 > 0) {
                ++n39;
            }
            if ((n42 & 1) > 0) {
                ++n40;
            }
            if ((n42 & 2) > 0) {
                ++n2;
            }
            if ((n42 & 3) != 3) continue;
            ++n41;
        }
        stringBuffer2.append("<br><br><b>Statistics</b>\n");
        stringBuffer2.append("<br><table cellspacing=5 border=1>\n");
        stringBuffer2.append("<col width=*><col width=*>\n");
        stringBuffer2.append("<tr><td align=left>Channels with any defect(s)</td><td align=left>" + n39 + "</td></tr>\n");
        stringBuffer2.append("<tr><td align=left>Channels with non-trim defect(s)</td><td align=left>" + n2 + "</td></tr>\n");
        stringBuffer2.append("<tr><td align=left>Channels with trim defect(s)</td><td align=left>" + n40 + "</td></tr>\n");
        stringBuffer2.append("<tr><td align=left>Channels with non-trim and trim defect(s)</td><td align=left>" + n41 + "</td></tr>\n");
        stringBuffer2.append("<tr><td align=left>Max consecutive bad channels (non-trim defects only)</td><td align=left>" + n31 + "</td></tr>\n");
        stringBuffer2.append("<tr><td align=left>Max consecutive bad channels (any defect)</td><td align=left>" + n30 + "</td></tr>\n");
        stringBuffer2.append("</table>");
        stringBuffer2.append("<br>");
        stringBuffer2.append("<br><b>Non-Trim Defects</b>");
        if (((Vector)object4).size() == 0) {
            stringBuffer2.append("<br>No defective channels");
        } else {
            stringBuffer2.append("<table cellspacing=5 border=1>\n");
            stringBuffer2.append("<col width=*><col width=*>\n");
            stringBuffer2.append("<tr><td align=left><b>Channel(s)</b></td><td align=left><b>Non-Trim Defects</b></td></tr>");
            int n43 = 0;
            while (n43 < ((Vector)object4).size()) {
                String string34 = (String)((Vector)object4).elementAt(n43);
                Vector vector = (Vector)hashtable4.get(string34);
                stringBuffer2.append("<tr><td align=left>" + string34 + "</td><td align=left>");
                n = 0;
                while (n < vector.size()) {
                    if (n > 0) {
                        stringBuffer2.append("<br>");
                    }
                    stringBuffer2.append((String)vector.elementAt(n));
                    ++n;
                }
                stringBuffer2.append("</td></tr>");
                ++n43;
            }
            stringBuffer2.append("</table>");
        }
        stringBuffer2.append("<br>");
        stringBuffer2.append("<br><b>Trim Defects</b>");
        if (((Vector)object3).size() == 0) {
            stringBuffer2.append("<br>No defective channels");
        } else {
            stringBuffer2.append("<table cellspacing=5 border=1>\n");
            stringBuffer2.append("<col width=*><col width=*>\n");
            stringBuffer2.append("<tr><td align=left><b>Channel(s)</b></td><td align=left><b>Trim Defects</b></td></tr>");
            int n44 = 0;
            while (n44 < ((Vector)object3).size()) {
                String string35 = (String)((Vector)object3).elementAt(n44);
                Vector vector = (Vector)hashtable5.get(string35);
                stringBuffer2.append("<tr><td align=left>" + string35 + "</td><td align=left>");
                n = 0;
                while (n < vector.size()) {
                    if (n > 0) {
                        stringBuffer2.append("<br>");
                    }
                    stringBuffer2.append((String)vector.elementAt(n));
                    ++n;
                }
                stringBuffer2.append("</td></tr>");
                ++n44;
            }
            stringBuffer2.append("</table><br>");
        }
        return stringBuffer2.toString();
    }
}

