/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import Preferences.Preference;
import Preferences.PreferencesInterface;
import ProdDatabase.SCTDBInterface;
import guiUtilities.HTMLViewer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GeneralUtilities {
    public static Hashtable generalHash;

    public static void itemExists(String string, String string2, boolean bl) throws Exception {
        if (bl || generalHash == null) {
            generalHash = new Hashtable();
        }
        Vector vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append("ser_no,ctype,locn_name FROM items WHERE ser_no >=" + string + " AND ser_no <=" + string2);
        stringBuffer.append(" ORDER BY ser_no");
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        int n = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            ++n;
            String string3 = resultSet.getString(1);
            String string4 = resultSet.getString(2);
            String string5 = resultSet.getString(3);
            generalHash.put(string3, string4);
            System.out.println(string3 + "(" + string4 + ") already exists, located at " + string5);
            bl2 = resultSet.next();
        }
        statement.close();
    }

    public static boolean itemExists(String string) throws Exception {
        boolean bl = false;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("SELECT ctype FROM items WHERE ser_no=" + string);
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        boolean bl2 = resultSet.next();
        while (bl2) {
            string2 = resultSet.getString(1);
            if (string2.indexOf("Module") != -1) {
                bl = true;
            }
            bl2 = resultSet.next();
        }
        statement.close();
        if (!bl) {
            if (string2 == null) {
                JOptionPane.showMessageDialog(null, string + " does not exist in the database!", "No such device", 1);
            } else {
                JOptionPane.showMessageDialog(null, string + " is a " + string2 + " (not a module)", "Not a module", 1);
            }
        }
        return bl;
    }

    public static String validateLocation(String string) throws Exception {
        String string2 = "unknown";
        boolean bl = true;
        try {
            int n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT locn_name FROM LOCNS");
        if (bl) {
            stringBuffer.append(" WHERE locn=" + string);
        } else {
            stringBuffer.append(" WHERE (locn_name='" + string + "' OR username='" + string + "')");
        }
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        boolean bl2 = false;
        boolean bl3 = resultSet.next();
        while (bl3) {
            string2 = resultSet.getString(1);
            bl3 = resultSet.next();
        }
        statement.close();
        return string2;
    }

    public static String validatePersonInitial(String string) throws Exception {
        String string2 = "unknown";
        StringBuffer stringBuffer = new StringBuffer("SELECT initls FROM persons WHERE initls='" + string + "'");
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        resultSet = statement.executeQuery(stringBuffer.toString());
        boolean bl = false;
        boolean bl2 = resultSet.next();
        while (bl2) {
            string2 = resultSet.getString(1);
            bl2 = resultSet.next();
        }
        statement.close();
        return string2;
    }

    public static Vector getNameList(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("SELECT initls FROM persons");
        stringBuffer.append(" WHERE persons.locn_name LIKE '" + string + "'");
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        int n = 0;
        Vector<String> vector = new Vector<String>();
        boolean bl = resultSet.next();
        while (bl) {
            ++n;
            vector.addElement(resultSet.getString(1));
            bl = resultSet.next();
        }
        System.out.println("Retrieved " + n + " names in total.");
        statement.close();
        if (vector.size() > 0) {
            return vector;
        }
        System.out.println("As there are no users defined at " + string + " I will return all users in the database.");
        stringBuffer = new StringBuffer("SELECT initls FROM persons ORDER BY initls");
        statement = sCTDBInterface.connection.createStatement();
        resultSet = statement.executeQuery(stringBuffer.toString());
        n = 0;
        boolean bl2 = resultSet.next();
        while (bl2) {
            ++n;
            vector.addElement(resultSet.getString(1));
            bl2 = resultSet.next();
        }
        statement.close();
        System.out.println("Retrieved " + n + " names in total.");
        return vector;
    }

    public static Vector getRawData(String string) throws Exception {
        Vector vector = new Vector();
        String string2 = "SELECT filename from test_rawdata WHERE test_no=" + string;
        SCTDBInterface sCTDBInterface = SCTDBInterface.getInstance();
        Statement statement = sCTDBInterface.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        String string3 = null;
        boolean bl = resultSet.next();
        while (bl) {
            string3 = resultSet.getString(1);
            bl = resultSet.next();
        }
        statement.close();
        if (string3 == null) {
            System.out.println("No raw data file found");
            return vector;
        }
        File file = new File(PreferencesInterface.getInstance().getPreference(3), string3);
        if (GeneralUtilities.downloadFile(string, file) == 0) {
            return vector;
        }
        try {
            vector = GeneralUtilities.unZipFile(file);
        }
        catch (Exception exception) {
            vector = GeneralUtilities.getFileContent(file);
            File file2 = new File(string3);
            vector.insertElementAt(file2.getName(), 0);
        }
        boolean bl2 = file.delete();
        return vector;
    }

    public static Vector getFileContent(File file) throws Exception {
        String string;
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null) {
            if (!bl) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string);
            bl = false;
        }
        bufferedReader.close();
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    public static int downloadFile(String string, File file) throws Exception {
        String string2 = "";
        byte[] byArray = new byte[32000];
        String string3 = "SELECT raw_data FROM test_rawdata WHERE test_no=" + string;
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        int n = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        boolean bl = resultSet.next();
        while (bl) {
            InputStream inputStream = resultSet.getBinaryStream(1);
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                n += n2;
                fileOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            bl = resultSet.next();
        }
        fileOutputStream.close();
        statement.close();
        if (n == 0) {
            System.out.println("No raw data available for test " + string);
        } else {
            System.out.println("Downloaded " + file.getName() + ", size " + n + " bytes.");
        }
        return n;
    }

    public static Vector unZipFile(File file) throws Exception {
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        ZipFile zipFile = new ZipFile(file);
        System.out.println("Unzipping raw data file, entries in zip = " + zipFile.size());
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            vector.addElement(zipEntry.getName());
            byte[] byArray = new byte[2048];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            vector.addElement(stringBuffer.toString());
        }
        zipInputStream.close();
        return vector;
    }

    public static double get500VData(String string) throws Exception {
        Pattern pattern = Pattern.compile(".*500[\\.\\d]*\\s*([\\.\\d]+).*");
        Pattern pattern2 = Pattern.compile("[0-9\\.]");
        Vector vector = GeneralUtilities.getRawData(string);
        String[] stringArray = ((String)vector.elementAt(1)).split("[\\r\\n]");
        int n = stringArray.length - 1;
        while (n >= 0) {
            Matcher matcher = pattern.matcher(stringArray[n]);
            if (matcher.matches()) {
                String string2 = stringArray[n].substring(matcher.start(1), matcher.end(1));
                return Double.parseDouble(string2);
            }
            --n;
        }
        return 0.0;
    }

    public static Vector getLocationList() throws Exception {
        System.out.println("Retrieving list of valid institute names from database ...");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT locn_name FROM locns ORDER BY locn_name");
        Vector<String> vector = new Vector<String>();
        boolean bl = resultSet.next();
        while (bl) {
            vector.addElement(resultSet.getString(1));
            bl = resultSet.next();
        }
        statement.close();
        return vector;
    }

    public static void downloadPSFile(JFrame jFrame, URL uRL) {
        Object object;
        Object object2;
        int n;
        String string = null;
        String string2 = null;
        String string3 = uRL.getFile();
        string = uRL.toString();
        System.out.println("Downloading " + string);
        string = string.substring(0, string.indexOf(string3));
        String string4 = uRL.getQuery();
        string3 = string4 != null ? string4 : uRL.getFile();
        int n2 = string3.lastIndexOf("=");
        if (n2 != -1) {
            string3 = string3.substring(n2 + 1);
        }
        if ((n = string3.lastIndexOf("/")) != -1) {
            string3 = string3.substring(n + 1);
        }
        if (!string3.endsWith(".ps")) {
            string3 = string3 + ".ps";
        }
        File file = new File(PreferencesInterface.getInstance().getPreference(3), string3);
        try {
            GeneralUtilities.downloadURL(file, uRL, string3);
        }
        catch (Exception exception) {
            object2 = exception.toString();
            int n3 = ((String)object2).indexOf("no protocol: ");
            if (n3 == -1) {
                System.out.println("Error downloading from URL: " + (String)object2);
                return;
            }
            object = ((String)object2).substring(n3 + 13);
            string2 = string + (String)object;
        }
        try {
            if (string2 != null) {
                int n4;
                System.out.println("Invalid URL - maybe relative pathname - reconstructing new URL from relative pathname...");
                uRL = new URL(string2);
                string3 = uRL.getFile();
                n = string3.lastIndexOf("/");
                if (n != -1) {
                    string3 = string3.substring(n + 1);
                }
                if ((n4 = string3.indexOf(".gz")) != -1) {
                    string3 = string3.substring(0, n4);
                }
                file = new File(PreferencesInterface.getInstance().getPreference(3), string3);
                GeneralUtilities.downloadURL(file, uRL, string3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception downloading from relative pathname in URL: " + exception.toString());
            return;
        }
        String string5 = PreferencesInterface.getInstance().getPreference(2);
        if (string5.equals("Not defined")) {
            object2 = new Preference(jFrame, 2);
            string5 = PreferencesInterface.getInstance().getPreference(2);
        }
        if (string5.equals("Not defined")) {
            return;
        }
        try {
            object2 = new File(string5);
            if (!((File)object2).exists()) {
                return;
            }
            String string6 = string5 + " " + file.getAbsolutePath();
            System.out.println(string6);
            object = Runtime.getRuntime().exec(string6);
        }
        catch (Exception exception) {
            System.out.println("Exception invoking ps viewer: " + exception.toString());
        }
    }

    public static void downloadURL(File file, URL uRL, String string) throws Exception {
        byte[] byArray = new byte[128000];
        int n = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = uRL.openStream();
        int n2 = inputStream.read(byArray);
        while (n2 > 0) {
            n += n2;
            fileOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        fileOutputStream.close();
        inputStream.close();
        System.out.println("Wrote " + n + " bytes to " + file.getAbsolutePath());
        HTMLViewer.getInstance().addImageFile(file.getAbsolutePath());
    }

    public static String getSignoffDataTestNo(String string, String string2) throws Exception {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer("SELECT test_no FROM tests");
        stringBuffer.append(" WHERE ser_no=" + string + " AND run_no='SIGNOFF' AND test_name='bmMOD_RData'");
        if (!string2.equals("Any")) {
            stringBuffer.append(" AND locn_name='" + string2 + "'");
        }
        stringBuffer.append(" ORDER BY test_date DESC, test_no DESC");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        boolean bl = resultSet.next();
        if (bl) {
            string3 = resultSet.getString(1);
        }
        statement.close();
        return string3;
    }

    public static Vector getSignoffDataTestNo(String string) throws Exception {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer("SELECT test_locn,test_no FROM tests");
        stringBuffer.append(" WHERE ser_no=" + string + " AND run_no='SIGNOFF' AND test_name='bmMOD_RData'");
        stringBuffer.append(" ORDER BY test_date DESC, test_no DESC");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = resultSet.next();
        while (bl) {
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            if (!hashtable.containsKey(string2)) {
                hashtable.put(string2, string3);
                vector.addElement(string3);
            }
            bl = resultSet.next();
        }
        statement.close();
        return vector;
    }

    public static Hashtable testComments(String string) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuffer stringBuffer = new StringBuffer("SELECT test_no,cmnt_text FROM test_cmnts WHERE test_no IN (SELECT tests.test_no FROM tests ");
        stringBuffer.append(string + ")");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        int n = 0;
        boolean bl = resultSet.next();
        while (bl) {
            if (++n % 100 == 0) {
                System.out.println("Retrieved " + n + " comments so far...");
            }
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            String string4 = hashtable.containsKey(string2) ? (String)hashtable.get(string2) + " " + string3 : string3;
            hashtable.put(resultSet.getString(1), string4);
            bl = resultSet.next();
        }
        statement.close();
        return hashtable;
    }

    public static Hashtable testImages(String string) throws Exception {
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        System.out.println("Checking for test images...");
        StringBuffer stringBuffer = new StringBuffer("SELECT test_no,title,name FROM test_images WHERE test_no IN (SELECT tests.test_no FROM tests ");
        stringBuffer.append(string + ")");
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        int n = 0;
        boolean bl = resultSet.next();
        while (bl) {
            if (++n % 100 == 0) {
                System.out.println("Retrieved " + n + " test images so far...");
            }
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            String string4 = resultSet.getString(3);
            Vector vector = hashtable.containsKey(string2) ? (Vector)hashtable.get(string2) : new Vector();
            vector.addElement(string3);
            vector.addElement(string4);
            hashtable.put(string2, vector);
            bl = resultSet.next();
        }
        System.out.println("Retrieved " + n + " test images in total.");
        statement.close();
        return hashtable;
    }

    public static void saveImage(String string, String string2, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[128000];
        String string3 = "SELECT data FROM test_images WHERE test_no=" + string + " AND name='" + string2 + "'";
        Statement statement = SCTDBInterface.getInstance().connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        System.out.println("Retrieving " + string2 + " ...");
        int n = 0;
        boolean bl = resultSet.next();
        while (bl) {
            InputStream inputStream = resultSet.getBinaryStream(1);
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                n += n2;
                fileOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            fileOutputStream.close();
            System.out.println("Saved image " + string2 + " with size " + n + " bytes...");
            HTMLViewer.getInstance().addImageFile(file.getAbsolutePath());
            bl = resultSet.next();
        }
        statement.close();
    }
}

