/*
 * Decompiled with CFR 0.152.
 */
package Preferences;

import Preferences.PreferencesInterface;
import ProdDatabase.GeneralUtilities;
import guiUtilities.userPrompt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Preference
extends JDialog {
    private JLabel titleLabel;
    private JButton updateButton;
    private JButton closeButton;
    private JLabel valueLabel;
    private int parameter;
    private PreferencesInterface preferences = PreferencesInterface.getInstance();
    private JFrame topFrame;

    public Preference(JFrame jFrame, int n) {
        super(jFrame, "Set Preference", true);
        this.topFrame = jFrame;
        this.parameter = n;
        this.initComponents();
        this.setLocationRelativeTo(this.topFrame);
        this.setVisible(true);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.updateButton = new JButton();
        this.closeButton = new JButton();
        this.valueLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Preference.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Arial", 1, 12));
        this.titleLabel.setForeground(new Color(255, 0, 0));
        this.titleLabel.setText(this.preferences.getDescription(this.parameter));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.valueLabel.setFont(new Font("Arial", 0, 12));
        this.valueLabel.setText(this.preferences.getPreference(this.parameter));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weighty = 0.3;
        this.getContentPane().add((Component)this.valueLabel, gridBagConstraints);
        this.updateButton.setFont(new Font("Arial", 0, 12));
        this.updateButton.setText("Change...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 0.3;
        this.getContentPane().add((Component)this.updateButton, gridBagConstraints);
        this.closeButton.setFont(new Font("Arial", 0, 12));
        this.closeButton.setText("Close");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 0.3;
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preference.this.closeForm();
            }
        });
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("clicked update, parameter=" + Preference.this.parameter);
                switch (Preference.this.parameter) {
                    case 2: {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setDialogTitle("Find a postscript viewer executable:");
                        int n = jFileChooser.showOpenDialog(Preference.this.topFrame);
                        if (n != 0) break;
                        File file = jFileChooser.getSelectedFile();
                        if (!file.exists()) {
                            JOptionPane.showMessageDialog(null, file.getAbsolutePath() + " does not exist", "Error", 0);
                            break;
                        }
                        Preference.this.valueLabel.setText(file.getAbsolutePath());
                        Preference.this.preferences.setPreference(2, file.getAbsolutePath());
                        Preference.this.pack();
                        break;
                    }
                    case 3: {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setDialogTitle("Select a suitable scratch disk:");
                        jFileChooser.setFileSelectionMode(1);
                        int n = jFileChooser.showOpenDialog(Preference.this.topFrame);
                        if (n != 0) break;
                        File file = jFileChooser.getSelectedFile();
                        if (!file.exists()) {
                            JOptionPane.showMessageDialog(null, file.getAbsolutePath() + " does not exist", "Error", 0);
                            break;
                        }
                        Preference.this.valueLabel.setText(file.getAbsolutePath());
                        Preference.this.preferences.setPreference(3, file.getAbsolutePath());
                        Preference.this.pack();
                        break;
                    }
                    case 1: {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setDialogTitle("Select a suitable upload directory:");
                        jFileChooser.setFileSelectionMode(1);
                        int n = jFileChooser.showOpenDialog(Preference.this.topFrame);
                        if (n != 0) break;
                        File file = jFileChooser.getSelectedFile();
                        if (!file.exists()) {
                            JOptionPane.showMessageDialog(null, file.getAbsolutePath() + " does not exist", "Error", 0);
                            break;
                        }
                        Preference.this.valueLabel.setText(file.getAbsolutePath());
                        Preference.this.preferences.setPreference(1, file.getAbsolutePath());
                        Preference.this.pack();
                        break;
                    }
                    case 0: {
                        System.out.println("Institute");
                        Vector vector = new Vector();
                        try {
                            vector = GeneralUtilities.getLocationList();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        userPrompt userPrompt2 = new userPrompt((Frame)Preference.this.topFrame, "Any", "Institute", vector);
                        userPrompt2.pack();
                        userPrompt2.setLocationRelativeTo(Preference.this.topFrame);
                        userPrompt2.setVisible(true);
                        String string = userPrompt2.getValidatedText();
                        if (string.equals("None")) break;
                        Preference.this.valueLabel.setText(string);
                        Preference.this.preferences.setPreference(0, string);
                        Preference.this.pack();
                        break;
                    }
                }
            }
        });
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.closeForm();
    }

    private void closeForm() {
        this.setVisible(false);
        this.dispose();
    }
}

