/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.TestDataInfo;
import DisplayGUI.gui;
import GuiComponents.System.ISInterface;
import Sct.IS.SctNames;
import Sct_CalibrationController.TestData;
import is.Info;
import is.InfoEvent;
import is.InfoListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class TestDataInterface
implements TestDataInfo,
InfoListener {
    gui guiControl;
    Hashtable serverHash;
    String theObjectName;
    Vector ISTests;
    int testIndex;
    int listFilterIndex;
    TestData testData;
    Pattern objectPattern;
    String resultObjectPattern;
    String serversPattern;
    String controlPattern;
    String testsPattern;
    String resultObjectHeader;
    String sctdbObjectHeader;
    String testObjectHeader;
    private ISInterface is;

    public TestDataInterface(gui gui2) {
        this.guiControl = gui2;
        this.is = ISInterface.getInstance();
        this.serverHash = new Hashtable();
        this.ISTests = new Vector();
        this.controlPattern = ".*TestData\\.[0-9]+\\.[0-9]+";
        this.objectPattern = Pattern.compile(this.controlPattern);
        this.resultObjectPattern = ".*(Summary).*";
        this.testIndex = -1;
        this.listFilterIndex = -1;
    }

    protected void subscribe(int n) {
        this.listFilterIndex = n;
        try {
            String string;
            String string2 = SctNames.getTestISServer();
            if (!this.serverHash.containsKey(string2)) {
                this.is.subscribe(string2, this.resultObjectPattern, true, this);
                this.serverHash.put(string2, this.resultObjectPattern);
            }
            if (!this.serverHash.containsKey(string = SctNames.getControlISServer())) {
                this.is.subscribe(string, this.controlPattern, true, this);
                this.serverHash.put(string, this.controlPattern);
            }
            String[] stringArray = this.is.getISObjects(string, this.controlPattern);
            this.ISTests = new Vector();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Matcher matcher = this.objectPattern.matcher(stringArray[n2]);
                if (matcher.matches()) {
                    String string3 = stringArray[n2];
                    if (this.listFilterIndex == -1) {
                        this.ISTests.addElement(string3);
                    } else {
                        try {
                            String string4;
                            TestData testData = new TestData();
                            this.is.getRepository().getValue(string3, (Info)testData);
                            String string5 = string4 = this.listFilterIndex == 5 ? TestDataInfo.testNames[7] : TestDataInfo.testNames[this.listFilterIndex];
                            if (testData.testName.indexOf(string4) != -1) {
                                this.ISTests.addElement(string3);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("***ERROR reading " + string3 + ": Test MISSED");
                        }
                    }
                }
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't subscribe to one or more IS Server(s): " + runtimeException.getMessage());
        }
    }

    protected void unsubscribe() {
        Enumeration enumeration = this.serverHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.serverHash.get(string);
            this.is.unsubscribe(string, string2);
        }
        this.serverHash = new Hashtable();
        this.testIndex = -1;
        this.listFilterIndex = -1;
    }

    public void infoCreated(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Matcher matcher = TestDataInterface.this.objectPattern.matcher(TestDataInterface.this.theObjectName);
                if (matcher.matches() && !TestDataInterface.this.ISTests.contains(TestDataInterface.this.theObjectName)) {
                    TestDataInterface.this.ISTests.addElement(TestDataInterface.this.theObjectName);
                }
                TestDataInterface.this.guiControl.tablesDisplayPane.updateTables();
                TestDataInterface.this.guiControl.displayPane.setDisplayColors();
                TestDataInterface.this.guiControl.displayPane.refreshDisplay();
            }
        });
    }

    public void infoDeleted(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TestDataInterface.this.ISTests.contains(TestDataInterface.this.theObjectName)) {
                    TestDataInterface.this.ISTests.removeElement(TestDataInterface.this.theObjectName);
                }
                TestDataInterface.this.guiControl.displayPane.setDisplayColors();
                TestDataInterface.this.guiControl.displayPane.refreshDisplay();
            }
        });
    }

    public void infoUpdated(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        if (this.theObjectName.indexOf("ControlData") != -1) {
            this.guiControl.tablesDisplayPane.updateTestTable(this.theObjectName, this.ISTests.indexOf(this.theObjectName));
        }
    }

    public Vector getTestTableList() {
        Vector<Object> vector = new Vector<Object>();
        Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>();
        vector.addElement("Test");
        vector.addElement("Status");
        vector.addElement("Run");
        vector.addElement("Scan");
        vector.addElement("#Scans");
        vector2.addElement(vector);
        int n = 0;
        while (n < this.ISTests.size()) {
            TestData testData = new TestData();
            this.is.getRepository().getValue((String)this.ISTests.elementAt(n), (Info)testData);
            vector = new Vector();
            if (testData.testName.equals("NPtGainTest") && testData.nScans == 3) {
                testData.testName = "3PtGainTest";
            }
            vector.addElement(testData.testName);
            switch (testData.status) {
                case 0: {
                    vector.addElement("Executing");
                    break;
                }
                case 1: {
                    vector.addElement("Completed");
                    break;
                }
                case 2: {
                    vector.addElement("Aborted");
                    break;
                }
                default: {
                    vector.addElement("Unknown");
                }
            }
            vector.addElement(new Integer(testData.runNumber));
            vector.addElement(new Integer(testData.startScanNumber));
            vector.addElement(new Integer(testData.nScans));
            vector2.addElement(vector);
            ++n;
        }
        return vector2;
    }

    public void setTestFilter(int n) {
        if (n == -1) {
            this.resultObjectHeader = null;
            this.sctdbObjectHeader = null;
            this.testObjectHeader = null;
            this.testIndex = -1;
            return;
        }
        String string = (String)this.ISTests.elementAt(n);
        this.testData = new TestData();
        this.is.getRepository().getValue(string, (Info)this.testData);
        String string2 = this.testData.testName;
        this.testIndex = -1;
        int n2 = 0;
        while (n2 < TestDataInfo.testNames.length) {
            if (string2.indexOf(TestDataInfo.testNames[n2]) != -1) {
                if (string2.equals("NPtGainTest") && this.testData.nScans == 3) {
                    this.testIndex = 5;
                    break;
                }
                this.testIndex = n2;
                break;
            }
            ++n2;
        }
        if (this.testIndex == -1) {
            System.out.println("sctGui TestDataInterface : Unrecognised testname: " + string2);
            this.resultObjectHeader = null;
            this.sctdbObjectHeader = null;
            this.testObjectHeader = null;
            return;
        }
        this.testObjectHeader = "TestData.SctData::" + string2 + "Result." + Integer.toString(this.testData.runNumber) + "." + Integer.toString(this.testData.startScanNumber) + ".";
        this.resultObjectHeader = "TestData.Summary." + Integer.toString(this.testData.runNumber) + "." + Integer.toString(this.testData.startScanNumber) + ".";
        this.sctdbObjectHeader = "SCTDBData." + TestDataInfo.testNames[this.testIndex] + "." + this.guiControl.sctdbDataInterface.getLocation() + ".";
    }

    public String getResultObjectHeader() {
        return this.resultObjectHeader;
    }

    public String getTestObjectHeader() {
        return this.testObjectHeader;
    }

    public String getSCTDBObjectHeader() {
        return this.sctdbObjectHeader;
    }

    public int getTestIndex() {
        return this.testIndex;
    }

    public int getListFilterIndex() {
        return this.listFilterIndex;
    }

    public int getRunNo() {
        if (this.testData == null) {
            return -1;
        }
        return this.testData.runNumber;
    }

    public int getScanNo() {
        if (this.testData == null) {
            return -1;
        }
        return this.testData.startScanNumber;
    }
}

