/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ColorScale;
import DisplayGUI.ModuleCell;
import DisplayGUI.SCTDB_Data;
import DisplayGUI.TestDataInfo;
import DisplayGUI.displayParams;
import DisplayGUI.gui;
import DisplayGUI.guiTableAdapter;
import Sct.IS.SctNames;
import Sct_CalibrationController.TestData;
import is.Info;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class TablesDisplayPane
extends JPanel
implements TestDataInfo,
TableModelListener,
ListSelectionListener,
displayParams {
    gui guiControl;
    guiTableAdapter[] resultTable = new guiTableAdapter[2];
    JTable[] table = new JTable[2];
    Vector[] objectNames = new Vector[2];
    ListSelectionModel[] rowSM = new ListSelectionModel[2];
    String table1;
    String table2;
    int rowSelected = -1;
    boolean selectionListenerIsActive = true;
    public JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    public JLabel table1Title;
    public JLabel table2Title;

    public TablesDisplayPane(gui gui2) {
        this.guiControl = gui2;
        int n = 0;
        while (n < 2) {
            this.resultTable[n] = new guiTableAdapter();
            this.resultTable[n].addTableModelListener(this);
            this.table[n] = new JTable(this.resultTable[n]);
            this.table[n].setFont(displayParams.tableFont);
            this.table[n].setSelectionMode(1);
            this.rowSM[n] = this.table[n].getSelectionModel();
            this.rowSM[n].addListSelectionListener(this);
            ++n;
        }
        this.table1 = "null";
        this.table2 = "null";
        this.initComponents();
        this.table[0].addMouseListener(new tables0MouseAdapter());
        this.table[1].addMouseListener(new tables1MouseAdapter());
        this.setBorder(new TitledBorder(null, "Data", 0, 0, new Font("Arial", 0, 11), new Color(0, 0, 153)));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane(this.table[0]);
        this.table1Title = new JLabel();
        this.jScrollPane2 = new JScrollPane(this.table[1]);
        this.table2Title = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBorder(new BevelBorder(1));
        this.jScrollPane1.setMinimumSize(new Dimension(300, 150));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.4;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.table1Title.setFont(new Font("Arial", 0, 12));
        this.table1Title.setForeground(new Color(51, 0, 153));
        this.table1Title.setText("Table 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.05;
        this.add((Component)this.table1Title, gridBagConstraints);
        this.jScrollPane2.setBorder(new BevelBorder(1));
        this.jScrollPane2.setMinimumSize(new Dimension(300, 150));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.4;
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.table2Title.setFont(new Font("Arial", 0, 12));
        this.table2Title.setForeground(new Color(51, 0, 153));
        this.table2Title.setText("Table 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.05;
        this.add((Component)this.table2Title, gridBagConstraints);
        this.jScrollPane1.addMouseListener(new tables0MouseAdapter());
        this.jScrollPane2.addMouseListener(new tables1MouseAdapter());
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.table1.equals("null")) {
            this.table1Title.setText("");
        } else {
            this.table1Title.setText(this.table1 + " : " + Integer.toString(this.resultTable[0].getRowCount()));
        }
        if (this.table2.equals("null")) {
            this.table2Title.setText("");
        } else {
            this.table2Title.setText(this.table2 + " : " + Integer.toString(this.resultTable[1].getRowCount()));
        }
    }

    public void setTableTitles(String string, String string2) {
        this.table1 = new String(string);
        this.table2 = new String(string2);
        this.table1Title.setText(this.table1 + " : " + Integer.toString(this.resultTable[0].getRowCount()));
        this.table2Title.setText(this.table2 + " : " + Integer.toString(this.resultTable[1].getRowCount()));
    }

    public int getRowCount(int n) {
        if (this.resultTable[n] == null) {
            return 0;
        }
        return this.resultTable[n].getRowCount();
    }

    public void setTable1Title(String string) {
        this.table2 = new String(string);
        this.table2Title.setText(this.table2 + " : " + Integer.toString(this.resultTable[1].getRowCount()));
    }

    public void refresh(int n, Vector vector) {
        this.selectionListenerIsActive = false;
        this.resultTable[n].reTable(vector);
        this.selectionListenerIsActive = true;
        TableColumn tableColumn = this.table[n].getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
    }

    public void refresh(Vector[] vectorArray, int n, int n2) {
        this.selectionListenerIsActive = false;
        int n3 = 0;
        while (n3 < 2) {
            this.objectNames[n3] = new Vector();
            this.resultTable[n3].reTable(vectorArray[n3]);
            TableColumn tableColumn = this.table[n3].getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(110);
            ++n3;
        }
        this.selectionListenerIsActive = true;
        if (n != -1) {
            this.rowSM[0].setSelectionInterval(n, n);
        }
    }

    public void refresh1(Vector vector, Vector vector2, String string) {
        this.objectNames[1] = new Vector(vector);
        this.table2 = new String(string);
        this.selectionListenerIsActive = false;
        this.resultTable[1].reTable(vector2);
        this.selectionListenerIsActive = true;
        TableColumn tableColumn = this.table[1].getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(110);
    }

    public String getSelectedObject() {
        int n = this.rowSM[1].getMinSelectionIndex();
        if (n == -1 || this.objectNames[1].size() == 0) {
            return null;
        }
        return (String)this.objectNames[1].elementAt(n);
    }

    public int getSelectedTest() {
        return this.rowSM[0].getMinSelectionIndex();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        if (!this.selectionListenerIsActive) {
            this.selectionListenerIsActive = true;
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        boolean bl2 = bl = listSelectionModel != this.rowSM[0];
        if (listSelectionModel.isSelectionEmpty()) {
            if (!bl) {
                this.guiControl.isInterface.setISFilter(-1);
                this.guiControl.testDataInterface.setTestFilter(-1);
                this.guiControl.sctdbDataInterface.setTestFilter(-1);
                this.guiControl.displayPane.setDisplayColors();
                this.guiControl.displayPane.refreshDisplay();
                this.rowSelected = -1;
            }
        } else {
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            int n3 = n2 - n + 1;
            if (this.guiControl.displayStatus.getStatus() == 2) {
                if (n3 > 1) {
                    int n4 = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete these " + n3 + " objects from IS?", "Confirm Deletion Request", 0, 3);
                    if (n4 == 1) {
                        listSelectionModel.setSelectionInterval(n, n);
                        return;
                    }
                    if (!bl) {
                        this.guiControl.isInterface.removeTests(n, n2);
                    }
                    this.updateTables();
                    return;
                }
                if (bl) {
                    return;
                }
                this.rowSelected = -1;
                this.guiControl.isInterface.setISFilter(n);
                this.guiControl.selectorPane.initParamList();
                this.guiControl.colorScalePane.setColorScale();
                this.guiControl.displayPane.setDisplayColors();
                this.guiControl.displayPane.refreshDisplay();
                ModuleCell moduleCell = this.guiControl.displayPane.getLastClickedCell();
                if (moduleCell != null) {
                    this.listISObjects(moduleCell);
                }
            } else if (this.guiControl.displayStatus.getStatus() == 3) {
                if (bl) {
                    return;
                }
                this.rowSelected = n;
                this.guiControl.testDataInterface.setTestFilter(n);
                this.guiControl.selectorPane.initParamList();
                this.guiControl.colorScalePane.setColorScale();
                this.guiControl.displayPane.setDisplayColors();
                this.guiControl.displayPane.refreshDisplay();
                this.listTestResults();
            } else if (this.guiControl.displayStatus.getStatus() == 4) {
                if (bl) {
                    return;
                }
                this.rowSelected = n;
                this.guiControl.sctdbDataInterface.setTestFilter(n);
                this.guiControl.selectorPane.initParamList();
                this.guiControl.colorScalePane.setColorScale();
                this.guiControl.displayPane.setDisplayColors();
                this.guiControl.displayPane.refreshDisplay();
                this.listTestResults();
            }
        }
    }

    public void listISObjects(ModuleCell moduleCell) {
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("Serial No");
        vector2.addElement("Run No");
        vector2.addElement("Scan No");
        vector2.addElement("Data");
        vector.addElement(vector2);
        String string = "null";
        String string2 = moduleCell.getSerialNo();
        String[] stringArray = this.guiControl.isInterface.getISObjects(string2);
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector3.addElement(stringArray[n]);
            String[] stringArray2 = stringArray[n].split("\\.");
            vector2 = new Vector();
            vector2.addElement(stringArray2[4]);
            vector2.addElement(stringArray2[2]);
            vector2.addElement(stringArray2[3]);
            vector2.addElement(stringArray2[1]);
            vector.addElement(vector2);
            ++n;
        }
        string = this.guiControl.selectorPane.getDisplayParameter() + " for " + string2;
        this.refresh1(vector3, vector, string);
    }

    public void listTestResults() {
        String string;
        int n = this.guiControl.displayStatus.getStatus();
        String string2 = this.guiControl.selectorPane.getDisplayParameter();
        Vector vector = this.guiControl.config.getSortedVector(this.guiControl.displayPane.getSCTView());
        Vector<String> vector2 = new Vector<String>();
        Vector<Vector<String>> vector3 = new Vector<Vector<String>>();
        Vector vector4 = new Vector();
        vector2.addElement("Serial No");
        if (n == 4) {
            vector2.addElement("Location");
            vector2.addElement("Date");
        }
        vector2.addElement(string2);
        vector3.addElement(vector2);
        int n2 = 0;
        while (n2 < vector.size()) {
            block10: {
                ColorScale colorScale;
                ModuleCell moduleCell;
                block9: {
                    string = (String)vector.elementAt(n2);
                    moduleCell = this.guiControl.config.getModuleCell(this.guiControl.displayPane.getSCTView(), string);
                    vector2 = new Vector();
                    vector2.addElement(string);
                    if (n != 4) break block9;
                    int n3 = this.guiControl.sctdbDataInterface.getTestIndex();
                    if (n3 < 0) break block10;
                    String string3 = "SCTDBData." + TestDataInfo.testNames[n3] + "." + this.guiControl.sctdbDataInterface.getLocation() + "." + string;
                    if (SctNames.getISRepository().contains(string3)) {
                        SCTDB_Data sCTDB_Data = new SCTDB_Data();
                        SctNames.getISRepository().getValue(string3, (Info)sCTDB_Data);
                        vector2.addElement(sCTDB_Data.testLocation);
                        vector2.addElement(sCTDB_Data.testDate);
                    } else {
                        vector2.addElement(" - ");
                        vector2.addElement(" - ");
                    }
                }
                if ((colorScale = this.guiControl.colorScalePane.getColorScale()) != null) {
                    vector2.addElement(colorScale.getLabel(moduleCell.getData()));
                } else {
                    vector2.addElement("No Data");
                }
                vector3.addElement(vector2);
            }
            ++n2;
        }
        string = n == 3 && this.guiControl.displayPane.getDisplayOption() == 2 ? string2 + " Comparisons" : string2 + " Results ";
        this.refresh1(vector4, vector3, string);
    }

    public void updateTables(boolean bl) {
        this.changeTables(bl);
    }

    public void updateTables() {
        this.changeTables(false);
    }

    private void changeTables(boolean bl) {
        Vector<String> vector = new Vector<String>();
        int n = -1;
        int n2 = -1;
        String string = "";
        String string2 = "";
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        Vector[] vectorArray2 = new Vector[]{new Vector(), new Vector()};
        int n3 = bl ? this.getSelectedTest() : -1;
        int n4 = this.guiControl.displayPane.getSCTView();
        switch (this.guiControl.displayStatus.getStatus()) {
            case 1: {
                string = "Group 1 modules";
                string2 = "Group 2 modules";
                vector.addElement("Serial No");
                String string3 = n4 < 4 ? "Row" : "Quadrant";
                vector.addElement(string3);
                vector.addElement("Posn");
                vector.addElement("MUR");
                vectorArray[0].addElement(vector);
                vectorArray[1].addElement(vector);
                Vector vector2 = this.guiControl.config.getSortedVector(n4);
                int n5 = 0;
                while (n5 < vector2.size()) {
                    String string4 = (String)vector2.elementAt(n5);
                    ModuleCell moduleCell = this.guiControl.config.getModuleCell(n4, string4);
                    int n6 = moduleCell.getModuleGroup();
                    if (n6 >= 0) {
                        vector = new Vector();
                        vector.addElement(string4);
                        if (n4 < 4) {
                            vector.addElement(Integer.toString(moduleCell.getRow()));
                            vector.addElement(Integer.toString(moduleCell.getPosition()));
                        } else {
                            vector.addElement(moduleCell.getQuadrant());
                            vector.addElement(moduleCell.getEndCapPosition());
                        }
                        vector.addElement(Integer.toString(moduleCell.getMUR()));
                        vectorArray[n6].addElement(vector);
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                string = "Tests";
                string2 = "IS Raw Data Objects";
                vector = new Vector();
                vector.addElement("Serial No");
                vector.addElement("Run No");
                vector.addElement("Scan No");
                vector.addElement("Data");
                vectorArray[1].addElement(vector);
                vectorArray[0] = this.guiControl.isInterface.getTestTableList();
                if (vectorArray[0].size() <= 1) break;
                n = vectorArray[0].size() - 2;
                break;
            }
            case 3: {
                int n7 = this.guiControl.testDataInterface.getListFilterIndex();
                string = n7 == -1 ? "Number of Tests " : "Number of " + TestDataInfo.testMenuNames[n7] + " Tests ";
                String string5 = this.guiControl.selectorPane.getDisplayParameter();
                string2 = string5 + " Results";
                vector = new Vector();
                vector.addElement("Serial No");
                vector.addElement(string5);
                vectorArray[1].addElement(vector);
                vectorArray[0] = this.guiControl.testDataInterface.getTestTableList();
                if (vectorArray[0].size() <= 1) break;
                if (n3 <= vectorArray[0].size() - 2 && n3 >= 0) {
                    n = n3;
                    break;
                }
                n = vectorArray[0].size() - 2;
                break;
            }
            case 4: {
                int n8 = this.guiControl.sctdbDataInterface.getListFilterIndex();
                string = n8 == -1 ? "Number of Tests " : "Number of " + TestDataInfo.testMenuNames[n8] + " Tests ";
                String string6 = this.guiControl.selectorPane.getDisplayParameter();
                string2 = string6 + " Results";
                vector = new Vector();
                vector.addElement("Serial No");
                vector.addElement(string6);
                vectorArray[1].addElement(vector);
                vectorArray[0] = this.guiControl.sctdbDataInterface.getTestTableList();
                if (vectorArray[0].size() <= 1) break;
                if (n3 <= vectorArray[0].size() - 2 && n3 >= 0) {
                    n = n3;
                    break;
                }
                n = vectorArray[0].size() - 2;
                break;
            }
            default: {
                return;
            }
        }
        this.refresh(vectorArray, n, n2);
        this.setTableTitles(string, string2);
        if (this.getSelectedTest() == -1) {
            this.guiControl.isInterface.setISFilter(-1);
            this.guiControl.testDataInterface.setTestFilter(-1);
            this.guiControl.sctdbDataInterface.setTestFilter(-1);
            this.guiControl.displayPane.setDisplayColors();
            this.guiControl.displayPane.refreshDisplay();
            this.rowSelected = -1;
            this.guiControl.displayPane.setDisplayColors();
            this.guiControl.displayPane.refreshDisplay();
        }
    }

    public void updateTestTable(String string, int n) {
        if (n == -1) {
            return;
        }
        try {
            TestData testData = new TestData();
            SctNames.getISRepository().getValue(string, (Info)testData);
            switch (testData.status) {
                case 0: {
                    this.resultTable[0].setValueAt("Executing", n, 1);
                    break;
                }
                case 1: {
                    this.resultTable[0].setValueAt("Completed", n, 1);
                    break;
                }
                case 2: {
                    this.resultTable[0].setValueAt("Aborted", n, 1);
                    break;
                }
                default: {
                    this.resultTable[0].setValueAt("Unknown", n, 1);
                }
            }
            this.resultTable[0].fireTableCellUpdated(n, 1);
        }
        catch (Exception exception) {
            System.err.println("***ERROR updating test status in table list : " + exception.toString());
        }
    }

    class tables0MouseAdapter
    extends MouseAdapter {
        tables0MouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    TablesDisplayPane.this.guiControl.menuBar.showTablesPopupMenu(0, mouseEvent);
                    break;
                }
            }
        }
    }

    class tables1MouseAdapter
    extends MouseAdapter {
        tables1MouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    TablesDisplayPane.this.guiControl.menuBar.showTablesPopupMenu(1, mouseEvent);
                    break;
                }
            }
        }
    }
}

