/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ModuleCell;
import DisplayGUI.SCTInfo;
import DisplayGUI.TestDataInfo;
import DisplayGUI.displayParams;
import DisplayGUI.gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectorPane
extends JPanel
implements ListSelectionListener,
displayParams,
SCTInfo,
TestDataInfo {
    private JList displayParameters;
    private JList sctViews;
    private JList mouseOptions;
    private JSplitPane splitPane;
    private String[] defaultString = new String[]{"...None"};
    private String[][] displayParameterStrings = new String[][]{new String[0], {"Module Group"}, {"Raw Data", "Fitted Data", "Analysed Data"}};
    private String[][] mouseOptionStrings = new String[][]{new String[0], {"Add to Group 1", "Add to Group 2"}, {"List Data objects"}, new String[0], new String[0]};
    private gui guiControl;
    private boolean selectionListenerIsActive = true;

    public SelectorPane(gui gui2) {
        this.guiControl = gui2;
        this.sctViews = new JList<String>(SCTInfo.SCTViewNames);
        this.sctViews.setFont(displayParams.displayScaleFont);
        this.sctViews.setSelectionMode(0);
        this.sctViews.setSelectedIndex(0);
        this.sctViews.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.sctViews);
        JLabel jLabel = new JLabel("Views");
        jLabel.setForeground(displayParams.darkBlueColor);
        jLabel.setBackground(displayParams.backgroundColor);
        jLabel.setFont(displayParams.displayTextFont);
        jScrollPane.setColumnHeaderView(jLabel);
        jScrollPane.getColumnHeader().setBackground(displayParams.backgroundColor);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getVerticalScrollBar().setBackground(displayParams.backgroundColor);
        this.displayParameters = new JList();
        this.displayParameters.setFont(displayParams.displayScaleFont);
        this.displayParameters.setSelectionMode(0);
        this.displayParameters.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.displayParameters);
        JLabel jLabel2 = new JLabel("Parameters");
        jLabel2.setForeground(displayParams.darkBlueColor);
        jLabel2.setBackground(displayParams.backgroundColor);
        jLabel2.setFont(displayParams.displayTextFont);
        jScrollPane2.setColumnHeaderView(jLabel2);
        jScrollPane2.getColumnHeader().setBackground(displayParams.backgroundColor);
        jScrollPane2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.getVerticalScrollBar().setBackground(displayParams.backgroundColor);
        this.mouseOptions = new JList();
        this.mouseOptions.setFont(displayParams.displayScaleFont);
        this.mouseOptions.setSelectionMode(0);
        this.mouseOptions.addListSelectionListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.mouseOptions);
        JLabel jLabel3 = new JLabel("Options");
        jLabel3.setForeground(displayParams.darkBlueColor);
        jLabel3.setBackground(displayParams.backgroundColor);
        jLabel3.setFont(displayParams.displayTextFont);
        jScrollPane3.setColumnHeaderView(jLabel3);
        jScrollPane3.getColumnHeader().setBackground(displayParams.backgroundColor);
        jScrollPane3.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.getVerticalScrollBar().setBackground(displayParams.backgroundColor);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane3);
        jSplitPane.setDividerSize(8);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.splitPane = new JSplitPane(0, jSplitPane, jScrollPane);
        this.splitPane.setDividerLocation(0.65);
        this.splitPane.setDividerSize(8);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        Dimension dimension = new Dimension(95, 16);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane3.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        this.splitPane.setPreferredSize(new Dimension(95, 717));
        this.add(this.splitPane);
        this.setBackground(displayParams.backgroundColor);
        this.setBorder(new TitledBorder(null, "Display", 0, 0, new Font("Arial", 0, 11), new Color(0, 0, 153)));
    }

    public void initParamList() {
        int n = this.guiControl.displayStatus.getStatus();
        boolean bl = true;
        boolean bl2 = true;
        int n2 = -1;
        if (n == 0) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: {
                this.displayParameters.setListData(this.displayParameterStrings[n]);
                this.mouseOptions.setListData(this.mouseOptionStrings[n]);
                bl = false;
                bl2 = false;
                break;
            }
            case 3: {
                n2 = this.guiControl.testDataInterface.getTestIndex();
                if (n2 != -1) {
                    this.displayParameters.setListData(TestDataInfo.testParameters[n2]);
                    bl = false;
                }
                this.mouseOptions.setListData(TestDataInfo.chipOptions);
                bl2 = false;
                break;
            }
            case 4: {
                n2 = this.guiControl.sctdbDataInterface.getTestIndex();
                if (n2 != -1) {
                    this.displayParameters.setListData(TestDataInfo.testParameters[n2]);
                    bl = false;
                }
                this.mouseOptions.setListData(TestDataInfo.chipOptions);
                bl2 = false;
                break;
            }
            default: {
                this.displayParameters = new JList();
                this.mouseOptions = new JList();
            }
        }
        if (this.displayParameters.getModel().getSize() > 0) {
            this.selectionListenerIsActive = false;
            this.displayParameters.setSelectedIndex(0);
        }
        if (this.mouseOptions.getModel().getSize() > 0) {
            this.selectionListenerIsActive = false;
            this.mouseOptions.setSelectedIndex(0);
        }
        if (bl) {
            this.displayParameters.setListData(this.defaultString);
        }
        if (bl2) {
            this.mouseOptions.setListData(this.defaultString);
        }
        this.setVisible(true);
    }

    public int getDisplayParameterIndex() {
        return this.displayParameters.getSelectedIndex();
    }

    public int getMouseClickIndex() {
        return this.mouseOptions.getSelectedIndex();
    }

    public String getOption() {
        return (String)this.mouseOptions.getSelectedValue();
    }

    public String getDisplayParameter() {
        return (String)this.displayParameters.getSelectedValue();
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (!jList.isSelectionEmpty()) {
            if (!this.selectionListenerIsActive) {
                this.selectionListenerIsActive = true;
                return;
            }
            int n = jList.getSelectedIndex();
            if (jList == this.sctViews) {
                this.guiControl.displayPane.setSCTView(n);
                return;
            }
            switch (this.guiControl.displayStatus.getStatus()) {
                case 2: {
                    this.guiControl.isInterface.setServerName(n);
                    this.guiControl.colorScalePane.setColorScale();
                    this.guiControl.displayPane.setDisplayColors();
                    this.guiControl.displayPane.refreshDisplay();
                    ModuleCell moduleCell = this.guiControl.displayPane.getLastClickedCell();
                    if (moduleCell == null) break;
                    this.guiControl.tablesDisplayPane.listISObjects(moduleCell);
                    break;
                }
                case 3: 
                case 4: {
                    this.guiControl.colorScalePane.setColorScale();
                    this.guiControl.displayPane.setDisplayColors();
                    this.guiControl.displayPane.refreshDisplay();
                    this.guiControl.tablesDisplayPane.listTestResults();
                    break;
                }
            }
        }
    }
}

