/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.SCTDBTestDownloader;
import DisplayGUI.TestDataInfo;
import DisplayGUI.gui;
import GuiComponents.System.ISInterface;
import Sct.IS.SctNames;
import Sct_CalibrationController.TestData;
import is.Info;
import is.InfoEvent;
import is.InfoListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class SCTDBDataInterface
implements TestDataInfo,
InfoListener {
    gui guiControl;
    Hashtable serverHash;
    String theObjectName;
    Vector ISTests;
    int testIndex;
    int listFilterIndex;
    TestData testData;
    String testLocation;
    Pattern objectPattern;
    String controlPattern;
    String resultObjectHeader;
    String SCTDBServer = "SCTDBData";
    private ISInterface is;

    public SCTDBDataInterface(gui gui2) {
        this.guiControl = gui2;
        this.is = ISInterface.getInstance();
        this.serverHash = new Hashtable();
        this.ISTests = new Vector();
        this.controlPattern = "(.*)TestData\\.([0-9])+\\.([0-9])+";
        this.objectPattern = Pattern.compile(this.controlPattern);
        this.testIndex = -1;
        this.listFilterIndex = -1;
        this.testLocation = "Any";
    }

    protected void subscribe(int n) {
        this.listFilterIndex = n;
        try {
            String string = SctNames.getControlISServer();
            if (!this.serverHash.containsKey(string)) {
                this.is.subscribe(string, this.controlPattern, true, this);
                this.serverHash.put(string, this.controlPattern);
            }
            if (!this.serverHash.containsKey(this.SCTDBServer)) {
                this.is.subscribe(this.SCTDBServer, ".*", true, this);
                this.serverHash.put(this.SCTDBServer, ".*");
            }
            String[] stringArray = this.is.getISObjects(string, this.controlPattern);
            this.ISTests = new Vector();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Matcher matcher = this.objectPattern.matcher(stringArray[n2]);
                if (matcher.matches()) {
                    String string2 = stringArray[n2];
                    if (this.listFilterIndex == -1) {
                        this.ISTests.addElement(string2);
                    } else {
                        TestData testData = new TestData();
                        this.is.getRepository().getValue(string2, (Info)testData);
                        if (testData.testName.indexOf(TestDataInfo.testNames[this.listFilterIndex]) != -1) {
                            this.ISTests.addElement(string2);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't subscribe to one or more IS Server(s): " + runtimeException.getMessage());
        }
    }

    protected void unsubscribe() {
        Enumeration enumeration = this.serverHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.serverHash.get(string);
            this.is.unsubscribe(string, string2);
        }
        this.serverHash = new Hashtable();
        this.testIndex = -1;
        this.listFilterIndex = -1;
    }

    public void infoCreated(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string;
                Matcher matcher = SCTDBDataInterface.this.objectPattern.matcher(SCTDBDataInterface.this.theObjectName);
                if (matcher.matches() && !SCTDBDataInterface.this.ISTests.contains(string = "ControlData.TestData." + SCTDBDataInterface.this.theObjectName.substring(matcher.start(2), matcher.end(2)) + "." + SCTDBDataInterface.this.theObjectName.substring(matcher.start(3), matcher.end(3)))) {
                    SCTDBDataInterface.this.ISTests.addElement(string);
                }
                SCTDBDataInterface.this.guiControl.tablesDisplayPane.updateTables(true);
                SCTDBDataInterface.this.guiControl.displayPane.setDisplayColors();
                SCTDBDataInterface.this.guiControl.displayPane.refreshDisplay();
            }
        });
    }

    public void infoDeleted(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SCTDBDataInterface.this.ISTests.contains(SCTDBDataInterface.this.theObjectName)) {
                    SCTDBDataInterface.this.ISTests.removeElement(SCTDBDataInterface.this.theObjectName);
                }
                SCTDBDataInterface.this.guiControl.displayPane.setDisplayColors();
                SCTDBDataInterface.this.guiControl.displayPane.refreshDisplay();
            }
        });
    }

    public void infoUpdated(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        if (this.theObjectName.indexOf("ControlData") != -1) {
            this.guiControl.tablesDisplayPane.updateTestTable(this.theObjectName, this.ISTests.indexOf(this.theObjectName));
        }
    }

    public Vector getTestTableList() {
        Vector<String> vector = new Vector<String>();
        Vector<Vector<String>> vector2 = new Vector<Vector<String>>();
        vector.addElement("Test");
        vector.addElement("Status");
        vector.addElement("Run");
        vector.addElement("Scan");
        vector.addElement("#Scans");
        vector2.addElement(vector);
        int n = 0;
        while (n < this.ISTests.size()) {
            TestData testData = new TestData();
            this.is.getRepository().getValue((String)this.ISTests.elementAt(n), (Info)testData);
            vector = new Vector();
            if (testData.testName.equals("NPtGainTest") && testData.nScans == 3) {
                testData.testName = "3PtGainTest";
            }
            vector.addElement(testData.testName);
            switch (testData.status) {
                case 0: {
                    vector.addElement("Executing");
                    break;
                }
                case 1: {
                    vector.addElement("Completed");
                    break;
                }
                case 2: {
                    vector.addElement("Aborted");
                    break;
                }
                default: {
                    vector.addElement("Unknown");
                }
            }
            vector.addElement(Integer.toString(testData.runNumber));
            vector.addElement(Integer.toString(testData.startScanNumber));
            vector.addElement(Integer.toString(testData.nScans));
            vector2.addElement(vector);
            ++n;
        }
        return vector2;
    }

    public void setTestFilter(int n) {
        if (n == -1) {
            this.resultObjectHeader = null;
            this.testIndex = -1;
            return;
        }
        String string = (String)this.ISTests.elementAt(n);
        this.testData = new TestData();
        this.is.getRepository().getValue(string, (Info)this.testData);
        String string2 = this.testData.testName;
        this.testIndex = -1;
        int n2 = 0;
        while (n2 < TestDataInfo.testNames.length) {
            if (string2.indexOf(TestDataInfo.testNames[n2]) != -1) {
                if (string2.equals("NPtGainTest") && this.testData.nScans == 3) {
                    this.testIndex = 5;
                    break;
                }
                this.testIndex = n2;
                break;
            }
            ++n2;
        }
        this.resultObjectHeader = "SCTDBData." + TestDataInfo.testNames[this.testIndex] + "." + this.testLocation + ".";
    }

    public String getResultObjectHeader() {
        return this.resultObjectHeader;
    }

    public int getTestIndex() {
        return this.testIndex;
    }

    public int getListFilterIndex() {
        return this.listFilterIndex;
    }

    public int getRunNo() {
        if (this.testData == null) {
            return -1;
        }
        return this.testData.runNumber;
    }

    public int getScanNo() {
        if (this.testData == null) {
            return -1;
        }
        return this.testData.startScanNumber;
    }

    public void downloadTests(int n) {
        boolean bl = false;
        if (n == -1) {
            n = this.testIndex;
            bl = true;
        }
        if (this.testIndex == -1) {
            return;
        }
        SCTDBTestDownloader sCTDBTestDownloader = new SCTDBTestDownloader(this.guiControl.config.getSortedVector(this.guiControl.displayPane.getSCTView()), this.testIndex, this.testLocation, true, bl);
        if (sCTDBTestDownloader.downloadsRequired() && sCTDBTestDownloader.isOkToStart()) {
            sCTDBTestDownloader.start();
        }
    }

    public void setLocation(String string) {
        this.testLocation = string;
    }

    public String getLocation() {
        return this.testLocation;
    }
}

