/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.displayParams;
import DisplayGUI.gui;
import GuiComponents.System.ISInterface;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ISTree
extends JFrame
implements ActionListener,
displayParams {
    gui guiControl;
    JButton closeButton;
    JButton refreshButton;
    protected JTree trISServers;
    JMenu popupOptionMenu;
    protected DefaultMutableTreeNode rootNode;

    public ISTree(gui gui2, DefaultMutableTreeNode defaultMutableTreeNode) {
        super("Information Service Status");
        this.guiControl = gui2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.popupOptionMenu = this.getTreeOptionMenu();
        this.trISServers = new JTree();
        this.trISServers.setEditable(false);
        this.trISServers.setBorder(new EtchedBorder());
        JScrollPane jScrollPane = new JScrollPane(this.trISServers);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.closeButton = new JButton("Close");
        this.refreshButton = new JButton("Refresh");
        this.closeButton.setEnabled(true);
        this.closeButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        this.refreshButton.addActionListener(this);
        jPanel2.add(this.refreshButton);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.closeButton);
        jPanel.add(jPanel2);
        jPanel.setToolTipText("Keyboard Options:\nALT_DELETE to delete the selection(s)\nALT_V to view the IS data");
        this.trISServers.addMouseListener(new isTreeMouseAdapter());
        this.setContentPane(jPanel);
        this.pack();
        this.setTree(defaultMutableTreeNode);
    }

    public Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.setVisible(false);
        } else {
            this.setTree(this.guiControl.isInterface.getISTree());
        }
    }

    public void setTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.trISServers.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.setVisible(true);
    }

    private JMenu getTreeOptionMenu() {
        JMenu jMenu = new JMenu("TreeOptions");
        jMenu.setFont(displayParams.menuFont);
        JMenuItem jMenuItem = new JMenuItem("Delete selection(s)");
        JMenuItem jMenuItem2 = new JMenuItem("View Selection");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem2.setFont(displayParams.menuFont);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = ISTree.this.trISServers.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ISInterface iSInterface = ISInterface.getInstance();
                int n = treePathArray.length - 1;
                while (n >= 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                    ((DefaultTreeModel)ISTree.this.trISServers.getModel()).removeNodeFromParent(defaultMutableTreeNode);
                    System.out.println(iSInterface.remove(defaultMutableTreeNode.toString()));
                    --n;
                }
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = ISTree.this.trISServers.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                ISTree.this.guiControl.isInterface.viewISData(treePath.getLastPathComponent().toString());
            }
        });
        return jMenu;
    }

    class isTreeMouseAdapter
    extends MouseAdapter {
        isTreeMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    if (ISTree.this.trISServers.getSelectionPaths() == null) {
                        return;
                    }
                    JPopupMenu jPopupMenu = ISTree.this.popupOptionMenu.getPopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu.setInvoker(ISTree.this.popupOptionMenu);
                    break;
                }
            }
        }
    }
}

