/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.gui;
import GuiComponents.Console.ExternalProcess;
import GuiComponents.Inspector.InspectorPanel;
import Sct.IS.NameIS;
import Sct.IS.ObjectManagerIS;
import Sct.IS.SctNames;
import Sct.Serializable;
import Sct_CalibrationController.TestData;
import is.Info;
import is.InfoEvent;
import is.InfoListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ISInterface
implements InfoListener {
    gui guiControl;
    Hashtable serverHash;
    String theObjectName;
    Vector ISTests;
    String isFilterHeader;
    String isFilterRunInfo;
    TestData testData;
    String serverName;
    int noScans;
    String eventServerRegex;
    String fitServerRegex;
    String controlPattern;
    String testServerRegex;
    int serverIndex = 0;
    private GuiComponents.System.ISInterface is;

    public ISInterface(gui gui2) {
        this.guiControl = gui2;
        this.is = GuiComponents.System.ISInterface.getInstance();
        this.serverHash = new Hashtable();
        this.ISTests = new Vector();
        this.noScans = 0;
        this.eventServerRegex = ".*RawScanResult.*[0-9]+\\.[0-9]+(\\.[0-9]{14}|\\.SCTTestAPI_PseudoModule)?";
        this.fitServerRegex = ".*FitScanResult.*[0-9]+\\.[0-9]+(\\.[0-9]{14}|\\.SCTTestAPI_PseudoModule)?";
        this.testServerRegex = ".*Result.*[0-9]+\\.[0-9]+(\\.[0-9]{14}|\\.SCTTestAPI_PseudoModule)?";
        this.controlPattern = "TestData\\.[0-9]+\\.[0-9]+";
    }

    protected void subscribe() {
        try {
            String string = SctNames.getEventISServer();
            String string2 = SctNames.getFitISServer();
            String string3 = SctNames.getTestISServer();
            String string4 = SctNames.getControlISServer();
            if (!this.serverHash.containsKey(string)) {
                this.is.subscribe(string, this.eventServerRegex, true, this);
                this.serverHash.put(string, this.eventServerRegex);
            }
            if (!this.serverHash.containsKey(string2)) {
                this.is.subscribe(string2, this.fitServerRegex, true, this);
                this.serverHash.put(string2, this.fitServerRegex);
            }
            if (!this.serverHash.containsKey(string3)) {
                this.is.subscribe(string3, this.testServerRegex, true, this);
                this.serverHash.put(string3, this.testServerRegex);
            }
            if (!this.serverHash.containsKey(string4)) {
                this.is.subscribe(string4, this.controlPattern, true, this);
                this.serverHash.put(string4, this.controlPattern);
            }
            String[] stringArray = this.is.getISObjects(string4, this.controlPattern);
            this.ISTests = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                this.ISTests.addElement(stringArray[n]);
                ++n;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't subscribe to one or more IS Server(s): " + runtimeException.getMessage());
        }
        this.guiControl.displayPane.setDisplayColors();
        this.guiControl.displayPane.refreshDisplay();
    }

    protected void unsubscribe() {
        Enumeration enumeration = this.serverHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.serverHash.get(string);
            this.is.unsubscribe(string, string2);
        }
        this.serverHash = new Hashtable();
    }

    public DefaultMutableTreeNode getISTree() {
        String[] stringArray = this.is.getISServers();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("IS Servers");
        int n = 0;
        while (n < stringArray.length) {
            this.is.subscribe(stringArray[n], this);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n]);
            String[] stringArray2 = this.is.getISObjects(stringArray[n], ".*");
            int n2 = 0;
            while (n2 < stringArray2.length) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringArray2[n2]);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                ++n2;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
        return defaultMutableTreeNode;
    }

    public void infoCreated(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ISInterface.this.theObjectName.startsWith(SctNames.getControlISServer())) {
                    if (!ISInterface.this.ISTests.contains(ISInterface.this.theObjectName)) {
                        ISInterface.this.ISTests.addElement(ISInterface.this.theObjectName);
                    }
                    ISInterface.this.guiControl.tablesDisplayPane.updateTables();
                }
                ISInterface.this.guiControl.displayPane.setDisplayColors();
                ISInterface.this.guiControl.displayPane.refreshDisplay();
            }
        });
    }

    public void infoDeleted(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ISInterface.this.ISTests.contains(ISInterface.this.theObjectName)) {
                    ISInterface.this.ISTests.removeElement(ISInterface.this.theObjectName);
                }
                ISInterface.this.guiControl.displayPane.setDisplayColors();
                ISInterface.this.guiControl.displayPane.refreshDisplay();
            }
        });
    }

    public void infoUpdated(InfoEvent infoEvent) {
        this.theObjectName = infoEvent.getName();
        if (this.theObjectName.indexOf("ControlData") != -1) {
            this.guiControl.tablesDisplayPane.updateTestTable(this.theObjectName, this.ISTests.indexOf(this.theObjectName));
        }
    }

    public Vector getTestTableList() {
        Vector<String> vector = new Vector<String>();
        Vector<Vector<String>> vector2 = new Vector<Vector<String>>();
        vector.addElement("Test");
        vector.addElement("Status");
        vector.addElement("Run");
        vector.addElement("Scan");
        vector.addElement("#Scans");
        vector2.addElement(vector);
        int n = 0;
        while (n < this.ISTests.size()) {
            TestData testData = new TestData();
            this.is.getRepository().getValue((String)this.ISTests.elementAt(n), (Info)testData);
            vector = new Vector();
            if (testData.testName.equals("NPtGainTest") && testData.nScans == 3) {
                testData.testName = "3PtGainTest";
            }
            vector.addElement(testData.testName);
            switch (testData.status) {
                case 0: {
                    vector.addElement("Executing");
                    break;
                }
                case 1: {
                    vector.addElement("Completed");
                    break;
                }
                case 2: {
                    vector.addElement("Aborted");
                    break;
                }
                default: {
                    vector.addElement("Unknown");
                }
            }
            vector.addElement(Integer.toString(testData.runNumber));
            vector.addElement(Integer.toString(testData.startScanNumber));
            vector.addElement(Integer.toString(testData.nScans));
            vector2.addElement(vector);
            ++n;
        }
        return vector2;
    }

    public void removeTests(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            String string = (String)this.ISTests.elementAt(n3);
            TestData testData = new TestData();
            this.is.getRepository().getValue(string, (Info)testData);
            int n4 = testData.runNumber;
            int n5 = testData.startScanNumber;
            StringBuffer stringBuffer = new StringBuffer(".*(");
            int n6 = testData.startScanNumber;
            while (n6 < testData.startScanNumber + testData.nScans) {
                if (n6 > testData.startScanNumber) {
                    stringBuffer.append("|");
                }
                stringBuffer.append("\\.");
                stringBuffer.append(Integer.toString(n4));
                stringBuffer.append("\\.");
                stringBuffer.append(Integer.toString(n6));
                stringBuffer.append("\\.");
                ++n6;
            }
            stringBuffer.append(").*");
            String[] stringArray = this.is.getISObjects(SctNames.getEventISServer(), stringBuffer.toString());
            int n7 = 0;
            while (n7 < stringArray.length) {
                System.out.println(this.is.remove(stringArray[n7]));
                ++n7;
            }
            stringArray = this.is.getISObjects(SctNames.getFitISServer(), stringBuffer.toString());
            int n8 = 0;
            while (n8 < stringArray.length) {
                System.out.println(this.is.remove(stringArray[n8]));
                ++n8;
            }
            stringArray = this.is.getISObjects(SctNames.getTestISServer(), stringBuffer.toString());
            int n9 = 0;
            while (n9 < stringArray.length) {
                System.out.println(this.is.remove(stringArray[n9]));
                ++n9;
            }
            System.out.println(this.is.remove(string));
            this.ISTests.removeElementAt(n3);
            --n3;
        }
    }

    public void removeObjects(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            System.out.println(this.is.remove((String)vector.elementAt(n)));
            ++n;
        }
    }

    public void setISFilter(int n) {
        if (n == -1) {
            this.testData = null;
            return;
        }
        String string = (String)this.ISTests.elementAt(n);
        this.testData = new TestData();
        this.is.getRepository().getValue(string, (Info)this.testData);
        this.setIsFilterHeader();
        this.setIsFilterRunInfo();
    }

    public void setServerName(int n) {
        this.serverIndex = n;
        this.setIsFilterHeader();
    }

    public int getNumberOfISObjects(String string) {
        int n = this.is.getNumberOfISObjects(this.getServerName(), this.isFilterHeader + this.isFilterRunInfo + string);
        return n;
    }

    public String[] getISObjects(String string) {
        return this.is.getISObjects(this.getServerName(), this.isFilterHeader + this.isFilterRunInfo + string);
    }

    public int getNoScans() {
        if (this.testData == null) {
            return 0;
        }
        return this.testData.nScans;
    }

    public int getRunNo() {
        if (this.testData == null) {
            return -1;
        }
        return this.testData.runNumber;
    }

    public int getScanNo() {
        if (this.testData == null) {
            return -1;
        }
        return this.testData.startScanNumber;
    }

    public void launchExternalViewer(String string) {
        try {
            NameIS nameIS = new NameIS(string);
            String string2 = nameIS.getISServer();
            if (string2.equals(SctNames.getEventISServer())) {
                this.launchExternalRaw(string);
                return;
            }
            if (string2.equals(SctNames.getFitISServer())) {
                this.launchExternalFit(string);
                return;
            }
            if (string.indexOf("NPtGainTestResult") != -1) {
                this.launchExternalNPtGain(string);
                return;
            }
            if (string.indexOf("TrimRangeTestResult") != -1) {
                this.launchExternalTrimRange(string);
                return;
            }
            if (string.indexOf("StrobeDelayTestResult") != -1) {
                this.launchExternalStrobeDelay(string);
                return;
            }
            if (string.indexOf("NoiseOccupancyTestResult") != -1) {
                this.launchExternalNoiseOccupancy(string);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.out.println("Couldn't launch external viewer for: " + string);
    }

    public void launchExternalRaw(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestRetrieve " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalFit(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestRetrieveFit " + string + " 0 36");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalNPtGain(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestNPtGain " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalStrobeDelay(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestStrobeDelay " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalTrimRange(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestTrimRange " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void launchExternalNoiseOccupancy(String string) {
        try {
            ExternalProcess externalProcess = new ExternalProcess("TestNO " + string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void viewISData(String string) {
        try {
            Serializable serializable = ObjectManagerIS.getInstance().readObject(string);
            InspectorPanel inspectorPanel = new InspectorPanel(string, serializable);
            JFrame jFrame = new JFrame("TreeTable");
            jFrame.getContentPane().add(new JScrollPane(inspectorPanel.treeTable));
            jFrame.pack();
            jFrame.show();
        }
        catch (IOException iOException) {
            System.err.println("Error reading object from IS: " + iOException + "  " + iOException.getMessage() + "\n");
        }
        System.out.println("IS Object: " + string + " plotted\n");
    }

    private void setIsFilterHeader() {
        switch (this.serverIndex) {
            case 0: {
                this.isFilterHeader = "SctData::RawScanResult";
                break;
            }
            case 1: {
                this.isFilterHeader = "SctData::FitScanResult";
                break;
            }
            default: {
                this.isFilterHeader = "SctData::" + this.testData.testName + "Result";
            }
        }
    }

    private void setIsFilterRunInfo() {
        StringBuffer stringBuffer = new StringBuffer("\\." + Integer.toString(this.testData.runNumber) + "\\.(");
        int n = this.testData.startScanNumber;
        while (n < this.testData.startScanNumber + this.testData.nScans) {
            if (n > this.testData.startScanNumber) {
                stringBuffer.append("|");
            }
            stringBuffer.append(Integer.toString(n));
            stringBuffer.append("\\.");
            ++n;
        }
        stringBuffer.append(").*");
        this.isFilterRunInfo = stringBuffer.toString();
    }

    private String getServerName() {
        String string = SctNames.getEventISServer();
        switch (this.serverIndex) {
            case 0: {
                string = SctNames.getEventISServer();
                break;
            }
            case 1: {
                string = SctNames.getFitISServer();
                break;
            }
            default: {
                string = SctNames.getTestISServer();
            }
        }
        return string;
    }
}

