/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ColorScale;
import DisplayGUI.ConfigurationInterface;
import DisplayGUI.DisplayStatus;
import DisplayGUI.ModuleCell;
import DisplayGUI.SCTDB_Data;
import DisplayGUI.SCTInfo;
import DisplayGUI.TestDataInfo;
import DisplayGUI.TestSummaryIS;
import DisplayGUI.displayParams;
import DisplayGUI.gui;
import DisplayGUI.guiInterface;
import ProdDatabase.ReportDownloader;
import Sct.IS.SctNames;
import SummaryReader.Reader;
import SummaryReader.ReaderReportUtilities;
import TestGUI.ModuleConfigurationPanel;
import is.Info;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class DisplayPanel
extends JPanel
implements guiInterface,
TestDataInfo {
    gui guiControl;
    private int selectedView = 0;
    FontMetrics metrics;
    int maxWidth;
    private int displayOption = 0;
    private JMenu popupMenu;
    private Rectangle draggedRectangle;
    private boolean firstTime = true;
    private Rectangle area;
    private Dimension dim;
    private ModuleCell redCell;
    private ModuleCell lastClickedCell;
    private ModuleCell popupCell;
    private String mouseLocationText;
    ConfigurationInterface config;
    boolean writeAccess;

    public DisplayPanel(gui gui2) {
        this.guiControl = gui2;
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.dim = this.getSize();
        this.maxWidth = (int)this.dim.getWidth();
        this.setMinimumSize(new Dimension(490, 741));
        this.setPreferredSize(new Dimension(490, 741));
        this.writeAccess = false;
        this.config = ConfigurationInterface.getInstance();
        this.config.setWindowSize(this.maxWidth, (int)this.dim.getHeight());
        this.getTestDataOptionMenu();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.writeAccess) {
            return;
        }
        this.draggedRectangle = new Rectangle(new Point(mouseEvent.getX(), mouseEvent.getY()));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.writeAccess || this.guiControl.displayStatus.getStatus() != 1) {
            return;
        }
        this.redCell = null;
        int n = mouseEvent.getX() - (int)this.draggedRectangle.getX();
        int n2 = mouseEvent.getY() - (int)this.draggedRectangle.getY();
        int n3 = this.guiControl.selectorPane.getMouseClickIndex();
        if (n < 0 || n2 < 0) {
            int n4 = (int)this.draggedRectangle.getWidth();
            int n5 = (int)this.draggedRectangle.getHeight();
            this.draggedRectangle = new Rectangle(new Point(mouseEvent.getX(), mouseEvent.getY()), new Dimension(Math.abs(n) + n4, Math.abs(n2) + n5));
        } else {
            this.draggedRectangle.setSize(new Dimension(n, n2));
        }
        Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
        block3: while (enumeration.hasMoreElements()) {
            ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
            if (moduleCell.getSctComponent() != this.selectedView || !moduleCell.intersects(this.draggedRectangle)) continue;
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    if (moduleCell.getModuleGroup() != n3) continue block3;
                    moduleCell.setModuleGroup(-1);
                    break;
                }
                default: {
                    if (moduleCell.isSelected()) continue block3;
                    moduleCell.setModuleGroup(n3);
                }
            }
        }
        if (this.guiControl.displayStatus.getStatus() == 1) {
            this.setDisplayColors();
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.draggedRectangle != null && this.writeAccess) {
            this.draggedRectangle = null;
            this.repaint();
            if (this.guiControl.displayStatus.getStatus() == 1) {
                this.guiControl.tablesDisplayPane.updateTables();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.draggedRectangle != null) {
            return;
        }
        ModuleCell moduleCell = this.config.getCell(this.selectedView, mouseEvent.getX(), mouseEvent.getY());
        if (moduleCell == null) {
            this.redCell = null;
            if (this.mouseLocationText != null) {
                this.mouseLocationText = null;
                this.repaint();
            }
            return;
        }
        if (moduleCell == this.redCell) {
            return;
        }
        this.redCell = moduleCell;
        switch (this.guiControl.displayStatus.getStatus()) {
            case 2: {
                if (this.guiControl.isInterface.testData == null) break;
                this.mouseLocationText = new String(moduleCell.getSerialNo() + " : " + moduleCell.getData() + " data objects");
                break;
            }
            case 1: {
                if (this.selectedView < 4) {
                    this.mouseLocationText = new String(moduleCell.getSerialNo() + " MUR: " + moduleCell.getMUR() + " Position: " + moduleCell.getModulePosition());
                    break;
                }
                this.mouseLocationText = new String(moduleCell.getSerialNo() + " MUR: " + moduleCell.getMUR() + " Quadrant/Position: " + moduleCell.getQuadrant() + "/" + moduleCell.getEndCapPosition());
                break;
            }
            default: {
                this.mouseLocationText = new String(moduleCell.getSerialNo() + " : " + moduleCell.getData());
            }
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ModuleCell moduleCell = this.config.getCell(this.selectedView, mouseEvent.getX(), mouseEvent.getY());
        if (moduleCell == null) {
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    this.guiControl.menuBar.showPopupMenu(mouseEvent);
                    break;
                }
            }
            return;
        }
        this.lastClickedCell = moduleCell;
        block3 : switch (this.guiControl.displayStatus.getStatus()) {
            case 1: {
                if (!this.writeAccess) {
                    return;
                }
                int n = this.guiControl.selectorPane.getMouseClickIndex();
                switch (mouseEvent.getModifiers()) {
                    case 4: 
                    case 8: {
                        if (moduleCell.getModuleGroup() != n) break;
                        moduleCell.setModuleGroup(-1);
                        break;
                    }
                    default: {
                        if (moduleCell.isSelected()) break;
                        moduleCell.setModuleGroup(n);
                    }
                }
                this.guiControl.tablesDisplayPane.updateTables();
                this.setDisplayColors();
                this.repaint();
                break;
            }
            case 2: {
                this.guiControl.tablesDisplayPane.listISObjects(moduleCell);
                break;
            }
            case 3: {
                switch (mouseEvent.getModifiers()) {
                    case 4: 
                    case 8: {
                        this.popupCell = moduleCell;
                        JPopupMenu jPopupMenu = this.popupMenu.getPopupMenu();
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        jPopupMenu.setInvoker(this.popupMenu);
                        break block3;
                    }
                }
                break;
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void refreshDisplay() {
        this.redCell = null;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.firstTime) {
            this.dim = this.getSize();
            this.area = new Rectangle(this.dim);
            this.maxWidth = (int)this.dim.getWidth();
            this.firstTime = false;
            graphics2D.setFont(displayParams.displayTextFont);
            this.metrics = graphics2D.getFontMetrics();
            this.config.setWindowSize(this.maxWidth, (int)this.dim.getHeight());
        }
        graphics2D.setPaint(Color.white);
        graphics2D.fill(this.area);
        this.config.drawSCTViewOutline(graphics2D, this.selectedView);
        this.drawTitle(graphics2D);
        if (this.mouseLocationText != null) {
            this.drawMouseLocation(graphics2D, this.mouseLocationText);
        }
        this.drawGraphicsCells(graphics2D);
        this.drawMouseSelections(graphics2D);
    }

    public void drawGraphicsCells(Graphics2D graphics2D) {
        ColorScale colorScale = this.guiControl.colorScalePane.getColorScale();
        if (this.selectedView < 4) {
            Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
            while (enumeration.hasMoreElements()) {
                ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
                if (moduleCell.getSctComponent() != this.selectedView) continue;
                graphics2D.setPaint(moduleCell.getColor());
                graphics2D.fill(moduleCell);
                graphics2D.setColor(Color.black);
                graphics2D.draw(moduleCell);
            }
        } else {
            Object object;
            Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
            while (enumeration.hasMoreElements()) {
                int n;
                object = (ModuleCell)enumeration.nextElement();
                if (((ModuleCell)object).getSctComponent() != this.selectedView || (n = ((ModuleCell)object).getPosition()) < 13 || n > 22) continue;
                graphics2D.setPaint(((ModuleCell)object).getColor());
                graphics2D.fill((Shape)object);
                graphics2D.setColor(Color.black);
                graphics2D.draw((Shape)object);
            }
            object = this.config.getSerialNumberMap(this.selectedView).elements();
            while (object.hasMoreElements()) {
                int n;
                ModuleCell moduleCell = (ModuleCell)object.nextElement();
                if (moduleCell.getSctComponent() != this.selectedView || (n = moduleCell.getPosition()) >= 13 && n <= 22) continue;
                graphics2D.setPaint(moduleCell.getColor());
                graphics2D.fill(moduleCell);
                graphics2D.setColor(Color.black);
                graphics2D.draw(moduleCell);
            }
        }
    }

    public void drawMouseSelections(Graphics2D graphics2D) {
        if (this.redCell != null) {
            graphics2D.setColor(Color.red);
            graphics2D.draw(this.redCell);
        }
        if (this.draggedRectangle != null) {
            graphics2D.setColor(Color.red);
            graphics2D.draw(this.draggedRectangle);
        }
        graphics2D.setColor(Color.lightGray);
    }

    public void drawMouseLocation(Graphics2D graphics2D, String string) {
        graphics2D.setFont(displayParams.displayTextFont);
        graphics2D.setPaint(Color.white);
        this.metrics = graphics2D.getFontMetrics();
        int n = this.metrics.stringWidth(string);
        int n2 = this.metrics.getHeight();
        graphics2D.drawString(string, this.maxWidth / 2 + 245 - n - 5, 57 - n2);
    }

    public void drawTitle(Graphics2D graphics2D) {
        graphics2D.setPaint(Color.blue);
        int n = this.maxWidth / 2 - 210;
        Rectangle rectangle = new Rectangle(n, 0, 455, 45);
        graphics2D.fill(rectangle);
        String string = DisplayStatus.statusNames[this.guiControl.displayStatus.getStatus()];
        graphics2D.setFont(displayParams.displayTextFont);
        graphics2D.setPaint(Color.white);
        String string2 = "View: " + SCTInfo.SCTViewNames[this.selectedView];
        graphics2D.drawString(string2, n += 5, 57 - graphics2D.getFontMetrics().getHeight());
        switch (this.guiControl.displayStatus.getStatus()) {
            case 1: {
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.yellow);
                this.metrics = graphics2D.getFontMetrics();
                graphics2D.drawString(string, n, this.metrics.getHeight());
                graphics2D.setFont(displayParams.displayTextFont);
                graphics2D.setPaint(Color.yellow);
                String[] stringArray = new String[]{"Group2", "Group1", "Modules"};
                String[] stringArray2 = new String[]{Integer.toString(this.guiControl.tablesDisplayPane.getRowCount(1)), Integer.toString(this.guiControl.tablesDisplayPane.getRowCount(0)), Integer.toString(this.config.getNumberOfModules(this.selectedView))};
                int n2 = 80;
                int n3 = this.maxWidth / 2 + 245;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    int n5 = n3 - n4 * n2 - graphics2D.getFontMetrics().stringWidth(stringArray[n4]) - 5;
                    int n6 = graphics2D.getFontMetrics().getHeight();
                    graphics2D.drawString(stringArray[n4], n5, n6);
                    n5 = n3 - n4 * n2 - graphics2D.getFontMetrics().stringWidth(stringArray2[n4]) - 5;
                    n6 += n6;
                    graphics2D.drawString(stringArray2[n4], n5, n6 - 2);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n7 = this.guiControl.testDataInterface.getListFilterIndex();
                int n8 = this.guiControl.testDataInterface.getTestIndex();
                if (n8 >= 0) {
                    string = TestDataInfo.testMenuNames[n8] + " Result";
                } else if (n7 >= 0) {
                    string = TestDataInfo.testMenuNames[n7] + " Result";
                }
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.yellow);
                this.metrics = graphics2D.getFontMetrics();
                graphics2D.drawString(string, n, this.metrics.getHeight());
                int n9 = this.guiControl.testDataInterface.getRunNo();
                String string3 = "No data";
                graphics2D.setFont(displayParams.displayTitleFont);
                this.metrics = graphics2D.getFontMetrics();
                switch (this.displayOption) {
                    case 0: {
                        if (n9 != -1) {
                            string3 = "Run " + Integer.toString(n9) + " Scan " + Integer.toString(this.guiControl.testDataInterface.getScanNo());
                        }
                        graphics2D.setPaint(Color.yellow);
                        int n10 = graphics2D.getFontMetrics().stringWidth(string3);
                        graphics2D.drawString(string3, this.maxWidth / 2 + 245 - n10 - 5, graphics2D.getFontMetrics().getHeight());
                        String string4 = this.guiControl.selectorPane.getDisplayParameter();
                        if (string4 == null) break;
                        graphics2D.setPaint(Color.white);
                        int n11 = graphics2D.getFontMetrics().stringWidth(string4);
                        graphics2D.drawString(string4, this.maxWidth / 2 + 245 - n10 - 20 - n11, graphics2D.getFontMetrics().getHeight());
                        break;
                    }
                    case 1: {
                        string3 = "SCTDB Reference Data";
                        graphics2D.setPaint(Color.red);
                        int n12 = graphics2D.getFontMetrics().stringWidth(string3);
                        graphics2D.drawString(string3, this.maxWidth / 2 + 245 - n12 - 5, graphics2D.getFontMetrics().getHeight());
                        break;
                    }
                    case 2: {
                        string3 = "Comparison with SCTDB";
                        graphics2D.setPaint(Color.red);
                        int n13 = graphics2D.getFontMetrics().stringWidth(string3);
                        graphics2D.drawString(string3, this.maxWidth / 2 + 245 - n13 - 5, graphics2D.getFontMetrics().getHeight());
                        break;
                    }
                    default: {
                        string3 = "No Data";
                        graphics2D.setPaint(Color.white);
                        int n14 = graphics2D.getFontMetrics().stringWidth(string3);
                        graphics2D.drawString(string3, this.maxWidth / 2 + 245 - n14 - 5, graphics2D.getFontMetrics().getHeight());
                    }
                }
                graphics2D.setFont(displayParams.displayTextFont);
                graphics2D.setPaint(Color.white);
                String string5 = this.guiControl.selectorPane.getOption();
                if (string5 == null) break;
                int n15 = graphics2D.getFontMetrics().stringWidth(string5);
                graphics2D.drawString(string5, this.maxWidth / 2 - n15 / 2 - 20, 57 - graphics2D.getFontMetrics().getHeight());
                break;
            }
            case 4: {
                String string6;
                int n16;
                int n17 = this.guiControl.sctdbDataInterface.getListFilterIndex();
                int n18 = this.guiControl.sctdbDataInterface.getTestIndex();
                if (n18 >= 0) {
                    string = TestDataInfo.testMenuNames[n18] + " (SCTDB)";
                } else if (n17 >= 0) {
                    string = TestDataInfo.testMenuNames[n17] + " (SCTDB)";
                }
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.yellow);
                this.metrics = graphics2D.getFontMetrics();
                graphics2D.drawString(string, n, this.metrics.getHeight());
                int n19 = this.guiControl.sctdbDataInterface.getRunNo();
                String string7 = "Reference";
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.red);
                this.metrics = graphics2D.getFontMetrics();
                int n20 = graphics2D.getFontMetrics().stringWidth(string7);
                graphics2D.drawString(string7, this.maxWidth / 2 + 245 - n20 - 5, graphics2D.getFontMetrics().getHeight());
                String string8 = this.guiControl.selectorPane.getDisplayParameter();
                if (string8 != null) {
                    graphics2D.setPaint(Color.white);
                    n16 = graphics2D.getFontMetrics().stringWidth(string8);
                    graphics2D.drawString(string8, this.maxWidth / 2 + 245 - n20 - 20 - n16, graphics2D.getFontMetrics().getHeight());
                }
                if ((string6 = this.guiControl.selectorPane.getOption()) == null) break;
                graphics2D.setFont(displayParams.displayTextFont);
                n16 = graphics2D.getFontMetrics().stringWidth(string6);
                graphics2D.drawString(string6, this.maxWidth / 2 - n16 / 2 - 20, 57 - graphics2D.getFontMetrics().getHeight());
                break;
            }
            case 2: {
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.yellow);
                this.metrics = graphics2D.getFontMetrics();
                graphics2D.drawString(string, n, this.metrics.getHeight());
                int n21 = this.guiControl.isInterface.getRunNo();
                String string9 = "No data";
                if (n21 != -1) {
                    string9 = "Run " + Integer.toString(n21) + " Scan " + Integer.toString(this.guiControl.isInterface.getScanNo());
                }
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.yellow);
                this.metrics = graphics2D.getFontMetrics();
                int n22 = graphics2D.getFontMetrics().stringWidth(string9);
                graphics2D.drawString(string9, this.maxWidth / 2 + 245 - n22 - 5, graphics2D.getFontMetrics().getHeight());
                String string10 = this.guiControl.selectorPane.getDisplayParameter();
                if (string10 == null) break;
                graphics2D.setPaint(Color.white);
                n22 = graphics2D.getFontMetrics().stringWidth(string10);
                graphics2D.drawString(string10, this.maxWidth / 2 - n22 / 2, graphics2D.getFontMetrics().getHeight());
                break;
            }
            default: {
                graphics2D.setFont(displayParams.displayTitleFont);
                graphics2D.setPaint(Color.yellow);
                this.metrics = graphics2D.getFontMetrics();
                graphics2D.drawString(string, n, this.metrics.getHeight());
            }
        }
    }

    public void setWriteAccess(boolean bl) {
        this.writeAccess = bl;
    }

    public void setSCTView(int n) {
        this.selectedView = n;
        this.setDisplayColors();
        this.refreshDisplay();
        this.guiControl.tablesDisplayPane.updateTables();
    }

    public void setDisplayOption(int n) {
        this.displayOption = n;
        this.guiControl.colorScalePane.setColorScale();
        this.setDisplayColors();
        this.refreshDisplay();
        this.guiControl.tablesDisplayPane.listTestResults();
    }

    public int getDisplayOption() {
        return this.displayOption;
    }

    public void resetDisplayOption() {
        this.displayOption = 0;
    }

    public int getSCTView() {
        return this.selectedView;
    }

    public ModuleCell getLastClickedCell() {
        return this.lastClickedCell;
    }

    public void setDisplayColors() {
        switch (this.guiControl.displayStatus.getStatus()) {
            case 3: {
                String string = this.guiControl.testDataInterface.getResultObjectHeader();
                int n = this.guiControl.testDataInterface.getTestIndex();
                Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
                block10: while (enumeration.hasMoreElements()) {
                    ColorScale colorScale;
                    String string2;
                    ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
                    if (string == null) {
                        moduleCell.setData("No Data", Color.white);
                        continue;
                    }
                    String string3 = moduleCell.getSerialNo();
                    switch (this.displayOption) {
                        case 1: {
                            string = this.guiControl.testDataInterface.getSCTDBObjectHeader();
                            string2 = this.getSCTDBData(string + string3, n);
                            if (string2 != null) break;
                            moduleCell.setData("No Data", Color.white);
                            continue block10;
                        }
                        case 2: {
                            string2 = this.getTestData(string + string3, n);
                            if (string2 == null) {
                                moduleCell.setData("No Data", Color.white);
                                continue block10;
                            }
                            String string4 = this.getSCTDBData(this.guiControl.testDataInterface.getSCTDBObjectHeader() + string3, n);
                            if (string4 == null) {
                                moduleCell.setData("No Data", Color.white);
                                continue block10;
                            }
                            double d = Double.parseDouble(string2);
                            double d2 = Double.parseDouble(string4);
                            double d3 = Math.abs(d - d2);
                            if (n == 2 && this.guiControl.selectorPane.getDisplayParameterIndex() > 2) {
                                string2 = "1";
                                break;
                            }
                            string2 = Math.abs(d - d2) > TestDataInfo.testDataTolerances[n][this.guiControl.selectorPane.getDisplayParameterIndex()] ? "2" : "1";
                            break;
                        }
                        default: {
                            string2 = this.getTestData(string + string3, n);
                            if (string2 != null) break;
                            moduleCell.setData("No Data", Color.white);
                            continue block10;
                        }
                    }
                    if ((colorScale = this.guiControl.colorScalePane.getColorScale()) != null) {
                        moduleCell.setData(string2, colorScale.getColor(Double.parseDouble(string2)));
                        continue;
                    }
                    moduleCell.setData("No Data", Color.white);
                }
                break;
            }
            case 4: {
                String string = this.guiControl.sctdbDataInterface.getResultObjectHeader();
                int n = this.guiControl.sctdbDataInterface.getTestIndex();
                Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
                while (enumeration.hasMoreElements()) {
                    ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
                    if (string == null) {
                        moduleCell.setData("No Data", Color.white);
                        continue;
                    }
                    String string5 = this.getSCTDBData(string + moduleCell.getSerialNo(), n);
                    if (string5 == null) {
                        moduleCell.setData("No Data", Color.white);
                        continue;
                    }
                    ColorScale colorScale = this.guiControl.colorScalePane.getColorScale();
                    if (colorScale != null) {
                        if (string5 != null) {
                            moduleCell.setData(string5, colorScale.getColor(Double.parseDouble(string5)));
                            continue;
                        }
                        moduleCell.setData("No Data", Color.white);
                        continue;
                    }
                    moduleCell.setData("No Data", Color.white);
                }
                break;
            }
            case 2: {
                Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
                while (enumeration.hasMoreElements()) {
                    ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
                    if (this.guiControl.isInterface.testData == null) {
                        moduleCell.setData("No data", Color.white);
                        continue;
                    }
                    double d = this.guiControl.isInterface.getNumberOfISObjects(moduleCell.getSerialNo());
                    moduleCell.setData(Integer.toString(this.guiControl.isInterface.getNumberOfISObjects(moduleCell.getSerialNo())), this.guiControl.colorScalePane.getColorScale().getColor(d));
                }
                break;
            }
            case 1: {
                Enumeration enumeration = this.config.getSerialNumberMap(this.selectedView).elements();
                while (enumeration.hasMoreElements()) {
                    ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
                    int n = moduleCell.getModuleGroup();
                    moduleCell.setData(Integer.toString(n), this.guiControl.colorScalePane.getColorScale().getColor(n));
                }
                break;
            }
        }
    }

    private String getTestData(String string, int n) {
        String string2;
        if (n == -1) {
            return null;
        }
        if (!SctNames.getISRepository().contains(string)) {
            return null;
        }
        TestSummaryIS testSummaryIS = new TestSummaryIS();
        SctNames.getISRepository().getValue(string, (Info)testSummaryIS);
        int n2 = this.guiControl.selectorPane.getDisplayParameterIndex();
        if (n2 < 0) {
            return null;
        }
        switch (n2) {
            case 0: {
                Reader reader = new Reader(testSummaryIS.dataString, false, true);
                string2 = reader.getTest().getTestStatus();
                break;
            }
            case 1: {
                Reader reader = new Reader(testSummaryIS.dataString, true, false);
                string2 = reader.getTest().getDefectiveStripCount();
                break;
            }
            default: {
                Reader reader = new Reader(testSummaryIS.dataString, n, n2 - 2);
                string2 = reader.getData(this.guiControl.selectorPane.getMouseClickIndex());
            }
        }
        return string2;
    }

    private String getSCTDBData(String string, int n) {
        String string2;
        if (n == -1) {
            return null;
        }
        if (!SctNames.getISRepository().contains(string)) {
            return null;
        }
        SCTDB_Data sCTDB_Data = new SCTDB_Data();
        SctNames.getISRepository().getValue(string, (Info)sCTDB_Data);
        int n2 = this.guiControl.selectorPane.getDisplayParameterIndex();
        if (n2 < 0) {
            return null;
        }
        switch (n2) {
            case 0: {
                string2 = Integer.toString(sCTDB_Data.status);
                break;
            }
            case 1: {
                string2 = Integer.toString(sCTDB_Data.noDefectChannels);
                break;
            }
            default: {
                string2 = this.extractSCTDBData(sCTDB_Data, this.guiControl.selectorPane.getMouseClickIndex(), n2 - 2);
            }
        }
        return string2;
    }

    private String extractSCTDBData(SCTDB_Data sCTDB_Data, int n, int n2) {
        String string;
        switch (n) {
            case -1: {
                double d = 0.0;
                double d2 = Double.parseDouble(sCTDB_Data.data_m0[n2]);
                if (d2 > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s1[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s2[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s3[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s4[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_e5[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_m8[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s9[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s10[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s11[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_s12[n2])) > d) {
                    d = d2;
                }
                if ((d2 = Double.parseDouble(sCTDB_Data.data_e13[n2])) > d) {
                    d = d2;
                }
                string = Double.toString(d2);
                break;
            }
            case 0: {
                string = sCTDB_Data.data_m0[n2];
                break;
            }
            case 1: {
                string = sCTDB_Data.data_s1[n2];
                break;
            }
            case 2: {
                string = sCTDB_Data.data_s2[n2];
                break;
            }
            case 3: {
                string = sCTDB_Data.data_s3[n2];
                break;
            }
            case 4: {
                string = sCTDB_Data.data_s4[n2];
                break;
            }
            case 5: {
                string = sCTDB_Data.data_e5[n2];
                break;
            }
            case 6: {
                string = sCTDB_Data.data_m8[n2];
                break;
            }
            case 7: {
                string = sCTDB_Data.data_s9[n2];
                break;
            }
            case 8: {
                string = sCTDB_Data.data_s10[n2];
                break;
            }
            case 9: {
                string = sCTDB_Data.data_s11[n2];
                break;
            }
            case 10: {
                string = sCTDB_Data.data_s12[n2];
                break;
            }
            case 11: {
                string = sCTDB_Data.data_e13[n2];
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private void getTestDataOptionMenu() {
        this.popupMenu = new JMenu("Test Data Options");
        this.popupMenu.setFont(displayParams.menuFont);
        JMenuItem jMenuItem = new JMenuItem("Test Report");
        jMenuItem.setFont(displayParams.menuFont);
        this.popupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReaderReportUtilities.showTestReport(DisplayPanel.this.guiControl, DisplayPanel.this.popupCell);
            }
        });
        jMenuItem = new JMenuItem("Summary Plots");
        jMenuItem.setFont(displayParams.menuFont);
        this.popupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DisplayPanel.this.guiControl.testDataInterface.getTestObjectHeader();
                if (string != null) {
                    DisplayPanel.this.guiControl.isInterface.launchExternalViewer(string + DisplayPanel.this.popupCell.getSerialNo());
                }
            }
        });
        jMenuItem = new JMenuItem("Module Configuration");
        jMenuItem.setFont(displayParams.menuFont);
        this.popupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("Module Configuration");
                jFrame.getContentPane().add(new ModuleConfigurationPanel(DisplayPanel.this.popupCell.getSerialNo()));
                jFrame.pack();
                jFrame.show();
            }
        });
        jMenuItem = new JMenuItem("Display All SCTDB Data");
        jMenuItem.setFont(displayParams.menuFont);
        this.popupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDownloader reportDownloader;
                String string = DisplayPanel.this.popupCell.getSerialNo();
                if (string.equals("SCTTestAPI_PseudoModule")) {
                    string = "20220330200020";
                }
                if ((reportDownloader = new ReportDownloader(9, string, 0)).isOkToStart()) {
                    reportDownloader.start();
                }
            }
        });
    }
}

