/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ModuleCell;
import DisplayGUI.SCTInfo;
import DisplayGUI.displayParams;
import GuiComponents.System.SystemInterface;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.IntHolder;
import sctConf.Configuration;
import sctConf.ConfigurationException;

public class ConfigurationInterface
implements displayParams,
SCTInfo {
    private static ConfigurationInterface instance = new ConfigurationInterface();
    private int maxWidth = 0;
    private int midX = 0;
    private int midY = 0;
    private int moduleCount = 0;
    private Polygon polygon;
    double[] radius = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    int[] xPoints = new int[]{0, 0, 0, 0};
    int[] yPoints = new int[]{0, 0, 0, 0};
    long fillsn = 3000L;
    private Hashtable[] serialNumberMap = new Hashtable[22];

    private ConfigurationInterface() {
        this.Refresh();
    }

    public static ConfigurationInterface getInstance() {
        return instance;
    }

    public void setWindowSize(int n, int n2) {
        this.maxWidth = n;
        this.midX = n / 2;
        this.midY = n2 / 2;
        n = (int)((double)n * 0.95);
        this.radius[0] = 0.35 * (double)n / 2.0;
        this.radius[1] = 0.52 * (double)n / 2.0;
        this.radius[2] = 0.5 * (double)n / 2.0;
        this.radius[3] = 0.76 * (double)n / 2.0;
        this.radius[4] = 0.74 * (double)n / 2.0;
        this.radius[5] = (double)n / 2.0;
    }

    public void Refresh() {
        int n = 0;
        while (n < 22) {
            this.serialNumberMap[n] = new Hashtable();
            ++n;
        }
        this.moduleCount = 0;
    }

    public boolean isConfigured() {
        return this.moduleCount > 0;
    }

    public void getConfiguration() {
        this.getConfiguration(-1);
    }

    public void getConfiguration(int n) {
        Configuration configuration = SystemInterface.getInstance().getConfigurationService();
        if (configuration == null) {
            return;
        }
        try {
            int[] nArray = configuration.listPartitions();
            int n2 = 0;
            while (n2 < nArray.length) {
                int[] nArray2 = configuration.listCratesInPartition(nArray[n2]);
                int n3 = 0;
                while (n3 < nArray2.length) {
                    int[] nArray3 = configuration.listRodsInCrate(nArray[n2], nArray2[n3]);
                    int n4 = 0;
                    while (n4 < nArray3.length) {
                        int[] nArray4 = configuration.listMURSInRod(nArray[n2], nArray2[n3], nArray3[n4]);
                        int n5 = 0;
                        while (n5 < nArray4.length) {
                            String[] stringArray = configuration.listModulesInMUR(nArray[n2], nArray4[n5]);
                            int n6 = 0;
                            while (n6 < stringArray.length) {
                                IntHolder intHolder = new IntHolder();
                                IntHolder intHolder2 = new IntHolder();
                                configuration.translateFromSN(stringArray[n6], intHolder, intHolder2);
                                IntHolder intHolder3 = new IntHolder();
                                IntHolder intHolder4 = new IntHolder();
                                IntHolder intHolder5 = new IntHolder();
                                try {
                                    configuration.translateToBarrel(intHolder.value, intHolder2.value, intHolder3, intHolder4, intHolder5);
                                    this.defineBarrelModuleGraphicsCell(intHolder3.value, intHolder4.value, intHolder5.value, intHolder.value, n, stringArray[n6]);
                                }
                                catch (ConfigurationException configurationException) {
                                    configuration.translateToEndcap(intHolder.value, intHolder2.value, intHolder3, intHolder4, intHolder5);
                                    this.defineEndCapModuleGraphicsCell(intHolder3.value, intHolder4.value, intHolder5.value, intHolder.value, n, stringArray[n6]);
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        catch (ConfigurationException configurationException) {
            System.err.println("Configuration exception retrieving configuration " + configurationException.detail);
            configurationException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("Non-configuration exception retrieving configuration ..." + exception);
            exception.printStackTrace();
        }
    }

    public String addModule(int n, int n2, int n3, int n4, int n5, String string) {
        int n6 = 0;
        while (n6 < 22) {
            if (this.serialNumberMap[n6].containsKey(string)) {
                return "Module " + string + " is already defined in " + SCTInfo.SCTViewNames[n6];
            }
            ++n6;
        }
        Enumeration enumeration = this.serialNumberMap[n].keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ModuleCell moduleCell = (ModuleCell)this.serialNumberMap[n].get(string2);
            if (moduleCell.getRow() != n2 || moduleCell.getModulePosition() != n3) continue;
            return "That location already taken by " + moduleCell.getSerialNo();
        }
        int n7 = n;
        if (n < 4) {
            this.defineBarrelModuleGraphicsCell(n7 += 3, n2, n3, n4, n5, string);
        } else if (n > 12) {
            this.defineEndCapModuleGraphicsCell(n7 -= 12, n2, n3, n4, n5, string);
        } else {
            n7 -= 3;
            this.defineEndCapModuleGraphicsCell(n7 *= -1, n2, n3, n4, n5, string);
        }
        return null;
    }

    private void defineBarrelModuleGraphicsCell(int n, int n2, int n3, int n4, int n5, String string) {
        int n6 = 0;
        while (n6 < 22) {
            if (this.serialNumberMap[n6].containsKey(string)) {
                System.out.println("** Module " + string + " defined more than once!");
                return;
            }
            ++n6;
        }
        if (n < 3 || n > 6) {
            System.out.println("** Module " + string + " reported to be in nonexistant barrel " + n + "!");
            return;
        }
        int n7 = n - 3;
        int n8 = n3;
        if ((n8 += 6) > 5) {
            --n8;
        }
        int n9 = n2;
        if (SCTInfo.moduleCells[n7] == null) {
            SCTInfo.moduleCells[n7] = new ModuleCell[SCTInfo.barrelRows[n7]][];
        }
        if (SCTInfo.moduleCells[n7][n9] == null) {
            SCTInfo.moduleCells[n7][n9] = new ModuleCell[12];
        }
        int n10 = this.maxWidth / 2 + n3 * 35;
        int n11 = 45 + (SCTInfo.yOffSetCount[n7] + n2) * 12;
        int[] nArray = new int[]{n10, n10, n10 + 35, n10 + 35};
        int[] nArray2 = new int[]{n11, n11 + 12, n11 + 12, n11};
        SCTInfo.moduleCells[n7][n9][n8] = new ModuleCell(string, n7, n2, n3, n4, n5, nArray, nArray2, 4);
        this.serialNumberMap[n7].put(string, SCTInfo.moduleCells[n7][n9][n8]);
        ++this.moduleCount;
    }

    private void defineEndCapModuleGraphicsCell(int n, int n2, int n3, int n4, int n5, String string) {
        int n6;
        int n7 = 0;
        while (n7 < 22) {
            if (this.serialNumberMap[n7].containsKey(string)) {
                System.out.println("** Module " + string + " defined more than once!");
                return;
            }
            ++n7;
        }
        int n8 = n6 = n < 0 ? 3 - n : 12 + n;
        if (SCTInfo.moduleCells[n6] == null) {
            SCTInfo.moduleCells[n6] = new ModuleCell[4][];
        }
        if (SCTInfo.moduleCells[n6][n2] == null) {
            SCTInfo.moduleCells[n6][n2] = new ModuleCell[33];
        }
        this.calculatePolygon(n6, n2, n3);
        SCTInfo.moduleCells[n6][n2][n3] = new ModuleCell(string, n6, n2, n3, n4, n5, this.xPoints, this.yPoints, 4);
        this.serialNumberMap[n6].put(string, SCTInfo.moduleCells[n6][n2][n3]);
        ++this.moduleCount;
    }

    public ModuleCell getCell(int n, int n2, int n3) {
        if (n < 4) {
            int n4 = (n3 - 45 - SCTInfo.yOffSetCount[n] * 12) / 12;
            if (n4 < 0 || n4 > SCTInfo.barrelRows[n] - 1) {
                return null;
            }
            int n5 = n2 - this.maxWidth / 2;
            int n6 = n5 / 35;
            if (n5 > 0 && n6 == 0) {
                return null;
            }
            if ((n6 += 5) < 0 || n6 > 11) {
                return null;
            }
            if (SCTInfo.moduleCells[n] != null && SCTInfo.moduleCells[n][n4] != null && SCTInfo.moduleCells[n][n4][n6] != null) {
                return SCTInfo.moduleCells[n][n4][n6];
            }
        } else {
            Enumeration enumeration = this.serialNumberMap[n].elements();
            while (enumeration.hasMoreElements()) {
                ModuleCell moduleCell = (ModuleCell)enumeration.nextElement();
                if (!moduleCell.contains(n2, n3)) continue;
                return moduleCell;
            }
        }
        return null;
    }

    public Hashtable getSerialNumberMap(int n) {
        return this.serialNumberMap[n];
    }

    public int getNumberOfModules(int n) {
        return this.serialNumberMap[n].size();
    }

    public Vector getSortedVector(int n) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.serialNumberMap[n].keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        Collections.sort(vector);
        return vector;
    }

    public ModuleCell getModuleCell(int n, String string) {
        return (ModuleCell)this.serialNumberMap[n].get(string);
    }

    public void drawSCTViewOutline(Graphics2D graphics2D, int n) {
        graphics2D.setColor(Color.lightGray);
        graphics2D.setFont(displayParams.displayTextFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = 0;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n3 = SCTInfo.yOffSetCount[n];
                int n4 = n3 + SCTInfo.barrelRows[n];
                int n5 = this.maxWidth / 2;
                int n6 = n3;
                while (n6 < n4) {
                    String string = Integer.toString(n2);
                    int n7 = fontMetrics.stringWidth(string);
                    int n8 = n5 - 210 - n7 - 8;
                    int n9 = n2;
                    boolean bl = SCTInfo.moduleCells[n] != null && SCTInfo.moduleCells[n][n9] != null;
                    graphics2D.setColor(Color.lightGray);
                    int n10 = -6;
                    while (n10 <= 6) {
                        if (n10 != 0) {
                            graphics2D.drawRect(n5 + 35 * n10, 45 + n6 * 12, 35, 12);
                        }
                        ++n10;
                    }
                    Color color = bl ? Color.black : Color.lightGray;
                    graphics2D.setColor(color);
                    graphics2D.drawString(string, n8, 45 + n6 * 12 + 12);
                    ++n2;
                    ++n6;
                }
                graphics2D.drawRect(n5 - 210, 45, 455, 672);
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                int n11;
                int n12 = 0;
                while (n12 < 4) {
                    n11 = 13;
                    while (n11 < 23) {
                        this.calculatePolygon(n, n12, n11);
                        if (this.polygon != null) {
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.polygon);
                            graphics2D.setColor(Color.lightGray);
                            graphics2D.draw(this.polygon);
                        }
                        ++n11;
                    }
                    ++n12;
                }
                n11 = 0;
                while (n11 < 4) {
                    int n13 = 0;
                    while (n13 < 13) {
                        this.calculatePolygon(n, n11, n13);
                        if (this.polygon != null) {
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.polygon);
                            graphics2D.setColor(Color.lightGray);
                            graphics2D.draw(this.polygon);
                        }
                        ++n13;
                    }
                    ++n11;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                int n14;
                int n15 = 0;
                while (n15 < 4) {
                    n14 = 13;
                    while (n14 < 23) {
                        this.calculatePolygon(n, n15, n14);
                        if (this.polygon != null) {
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.polygon);
                            graphics2D.setColor(Color.lightGray);
                            graphics2D.draw(this.polygon);
                        }
                        ++n14;
                    }
                    ++n15;
                }
                n14 = 0;
                while (n14 < 4) {
                    int n16 = 0;
                    while (n16 < 33) {
                        if (n16 < 13 || n16 >= 23) {
                            this.calculatePolygon(n, n14, n16);
                            if (this.polygon != null) {
                                graphics2D.setColor(Color.white);
                                graphics2D.fill(this.polygon);
                                graphics2D.setColor(Color.lightGray);
                                graphics2D.draw(this.polygon);
                            }
                        }
                        ++n16;
                    }
                    ++n14;
                }
                break;
            }
            case 12: 
            case 21: {
                int n17 = 0;
                while (n17 < 4) {
                    int n18 = 0;
                    while (n18 < 13) {
                        this.calculatePolygon(n, n17, n18);
                        if (this.polygon != null) {
                            graphics2D.draw(this.polygon);
                        }
                        ++n18;
                    }
                    ++n17;
                }
                break;
            }
        }
    }

    private void calculatePolygon(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n3 < 13) {
            d = 0.06041524333826525;
            d2 = 0.1208304866765305;
            n4 = 4;
            n5 = n3;
            n6 = 13;
        } else if (n3 >= 13 && n3 < 23) {
            d = 0.0;
            d2 = 0.15707963267948966;
            n4 = 2;
            n5 = n3 - 13;
            n6 = 10;
        } else {
            d = 0.07853981633974483;
            d2 = 0.15707963267948966;
            n4 = 0;
            n5 = n3 - 23;
            n6 = 10;
        }
        this.xPoints[0] = this.midX + (int)(this.radius[n4] * Math.sin((double)(n5 += n2 * n6) * d2 + d));
        this.xPoints[1] = this.midX + (int)(this.radius[n4] * Math.sin((double)(n5 + 1) * d2 + d));
        this.xPoints[2] = this.midX + (int)(this.radius[n4 + 1] * Math.sin((double)(n5 + 1) * d2 + d));
        this.xPoints[3] = this.midX + (int)(this.radius[n4 + 1] * Math.sin((double)n5 * d2 + d));
        this.yPoints[0] = this.midY - (int)(this.radius[n4] * Math.cos((double)n5 * d2 + d));
        this.yPoints[1] = this.midY - (int)(this.radius[n4] * Math.cos((double)(n5 + 1) * d2 + d));
        this.yPoints[2] = this.midY - (int)(this.radius[n4 + 1] * Math.cos((double)(n5 + 1) * d2 + d));
        this.yPoints[3] = this.midY - (int)(this.radius[n4 + 1] * Math.cos((double)n5 * d2 + d));
        this.polygon = new Polygon(this.xPoints, this.yPoints, 4);
    }
}

