/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ColorScale;
import DisplayGUI.displayParams;
import DisplayGUI.gui;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class ColorScalePane
extends JPanel
implements MouseListener,
MouseMotionListener,
displayParams {
    gui guiControl;
    FontMetrics metrics;
    int maxWidth;
    int maxHeight;
    Dimension dim;
    Rectangle area;
    Rectangle2D.Double drawRect;
    GradientPaint colorGradient;
    boolean firstTime = true;
    int x;
    int y;
    ColorScale colorScale;
    String scaleDescription;

    public ColorScalePane(gui gui2) {
        this.guiControl = gui2;
        this.setBackground(displayParams.backgroundColor);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.dim = this.getSize();
        this.maxWidth = (int)this.dim.getWidth();
        this.setMinimumSize(new Dimension(300, 60));
        this.setPreferredSize(new Dimension(300, 60));
        this.setBorder(new TitledBorder(null, "Display Colour Scale", 0, 0, new Font("Arial", 0, 11), new Color(0, 0, 153)));
    }

    public void setColorScale() {
        block0 : switch (this.guiControl.displayStatus.getStatus()) {
            case 2: {
                int n = this.guiControl.isInterface.getNoScans();
                if (n == 0) {
                    this.colorScale = null;
                    this.scaleDescription = null;
                    break;
                }
                if (this.guiControl.selectorPane.getDisplayParameter().indexOf("Analysed") != -1) {
                    n = 1;
                }
                if (n == 1) {
                    this.colorScale = new ColorScale(0.0, Color.red, "0");
                    this.colorScale.add(1.0, Color.green, "1");
                    break;
                }
                this.colorScale = new ColorScale(0.0, Color.red, "0", n, Color.green, Integer.toString(n));
                this.scaleDescription = new String("Number of IS data objects");
                break;
            }
            case 1: {
                this.colorScale = new ColorScale(-1.0, Color.white, "None");
                this.colorScale.add(0.0, Color.ORANGE, "Group 1");
                this.colorScale.add(1.0, Color.cyan, "Group 2");
                this.scaleDescription = new String("Selected module grouping");
                break;
            }
            case 3: {
                switch (this.guiControl.displayPane.getDisplayOption()) {
                    case 0: 
                    case 1: {
                        this.setTestDataScales(this.guiControl.testDataInterface.getTestIndex());
                        break block0;
                    }
                }
                this.colorScale = new ColorScale(-1.0, Color.white, "No Data");
                this.colorScale.add(1.0, Color.green, "Good");
                this.colorScale.add(2.0, Color.red, "Poor");
                this.scaleDescription = new String("Comparison with SCTDB Reference");
                break;
            }
            case 4: {
                this.setTestDataScales(this.guiControl.sctdbDataInterface.getTestIndex());
                break;
            }
            default: {
                this.colorScale = null;
                this.scaleDescription = null;
            }
        }
        this.repaint();
    }

    public void setTestDataScales(int n) {
        int n2 = this.guiControl.selectorPane.getDisplayParameterIndex();
        block0 : switch (n) {
            case 12: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.orange, "0", 5.0, Color.green, "5.0");
                        this.scaleDescription = new String("Token");
                        break block0;
                    }
                    case 3: {
                        this.colorScale = new ColorScale(0.0, Color.orange, "0", 5.0, Color.green, "5.0");
                        this.scaleDescription = new String("R-Token");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0");
                        this.colorScale.add(1.0, Color.red, ">0");
                        this.scaleDescription = new String("Number of defective pipelines");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.red, "0", 20.0, Color.red, "20");
                        this.colorScale.add(10.0, Color.green, "10");
                        this.colorScale.add(15.0, Color.green, "15");
                        this.scaleDescription = new String("Strobe Delay");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 5: 
            case 7: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.red, "0", 300.0, Color.red, "300.");
                        this.colorScale.add(100.0, Color.green, "100.");
                        this.colorScale.add(200.0, Color.green, "200.");
                        this.scaleDescription = new String("VT50 point at 2fC");
                        break block0;
                    }
                    case 3: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 10.0, Color.red, "10.");
                        this.colorScale.add(1.0, Color.green, "1.");
                        this.colorScale.add(5.0, Color.green, "5.");
                        this.scaleDescription = new String("VT50 rms at 2fC");
                        break block0;
                    }
                    case 4: {
                        this.colorScale = new ColorScale(30.0, Color.red, "30", 70.0, Color.red, "70");
                        this.colorScale.add(40.0, Color.green, "40");
                        this.colorScale.add(60.0, Color.green, "60");
                        this.scaleDescription = new String("Gain at 2fC");
                        break block0;
                    }
                    case 5: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 10.0, Color.red, "10.");
                        this.colorScale.add(1.0, Color.green, "1.");
                        this.colorScale.add(5.0, Color.green, "5.");
                        this.scaleDescription = new String("Gain rms at 2fC");
                        break block0;
                    }
                    case 6: {
                        this.colorScale = new ColorScale(0.0, Color.red, "0.", 100.0, Color.red, "100.");
                        this.colorScale.add(10.0, Color.green, "10");
                        this.colorScale.add(90.0, Color.green, "90");
                        this.scaleDescription = new String("Offset at 2fC");
                        break block0;
                    }
                    case 7: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 10.0, Color.red, "10.");
                        this.colorScale.add(1.0, Color.green, "1.");
                        this.colorScale.add(5.0, Color.green, "5.");
                        this.scaleDescription = new String("Offset rms at 2fC");
                        break block0;
                    }
                    case 8: {
                        this.colorScale = new ColorScale(10.0, Color.blue, "10.", 16.0, Color.red, "16.");
                        this.colorScale.add(12.0, Color.green, "12.");
                        this.colorScale.add(14.0, Color.green, "14.");
                        this.scaleDescription = new String("Output Noise at 2fC");
                        break block0;
                    }
                    case 9: {
                        this.colorScale = new ColorScale(1000.0, Color.blue, "1000", 2000.0, Color.red, "2000");
                        this.colorScale.add(1300.0, Color.green, "1300");
                        this.colorScale.add(1600.0, Color.green, "1600");
                        this.scaleDescription = new String("Input noise (ENC) at 2fC");
                        break block0;
                    }
                    case 10: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0.", 100.0, Color.red, "100");
                        this.colorScale.add(30.0, Color.green, "30.");
                        this.colorScale.add(80.0, Color.green, "80.");
                        this.scaleDescription = new String("Input noise rms (ENC) at 2fC");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 8: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.red, "0.", 100.0, Color.red, "100.");
                        this.colorScale.add(10.0, Color.green, "10");
                        this.colorScale.add(90.0, Color.green, "90");
                        this.scaleDescription = new String("Offset");
                        break block0;
                    }
                    case 3: {
                        this.colorScale = new ColorScale(1.0E-7, Color.blue, "1E-7", 1.0E-4, Color.red, "1E-4");
                        this.colorScale.add(1.0E-6, Color.green, "1E-6");
                        this.colorScale.add(1.0E-5, Color.green, "1E-5");
                        this.colorScale.setLogScale();
                        this.scaleDescription = new String("Noise Occupancy");
                        break block0;
                    }
                    case 4: {
                        this.colorScale = new ColorScale(1.0E-7, Color.blue, "1E-7", 1.0E-4, Color.red, "1E-4");
                        this.colorScale.add(1.0E-6, Color.green, "1E-6");
                        this.colorScale.add(1.0E-5, Color.green, "1E-5");
                        this.colorScale.setLogScale();
                        this.scaleDescription = new String("Noise Occupancy RMS");
                        break block0;
                    }
                    case 5: {
                        this.colorScale = new ColorScale(1000.0, Color.blue, "1000", 2000.0, Color.red, "2000");
                        this.colorScale.add(1300.0, Color.green, "1300");
                        this.colorScale.add(1600.0, Color.green, "1600");
                        this.scaleDescription = new String("Noise (ENC)");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 6: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0");
                        this.colorScale.add(1.0, Color.green, "1");
                        this.colorScale.add(2.0, Color.red, "2");
                        this.colorScale.add(3.0, Color.yellow, "3");
                        this.scaleDescription = new String("Trim Range");
                        break block0;
                    }
                    case 3: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0.", 250.0, Color.red, "250");
                        this.colorScale.add(50.0, Color.green, "50.");
                        this.colorScale.add(200.0, Color.green, "200.");
                        this.scaleDescription = new String("Target");
                        break block0;
                    }
                    case 4: {
                        this.colorScale = new ColorScale(0.0, Color.green, "100%");
                        this.colorScale.add(1.0, Color.red, "<100%");
                        this.scaleDescription = new String("Number of trimmed channels");
                        break block0;
                    }
                    case 5: {
                        this.colorScale = new ColorScale(0.0, Color.red, "0", 300.0, Color.red, "300.");
                        this.colorScale.add(100.0, Color.green, "100.");
                        this.colorScale.add(200.0, Color.green, "200.");
                        this.scaleDescription = new String("VT50 point");
                        break block0;
                    }
                    case 6: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 10.0, Color.red, "10.");
                        this.colorScale.add(1.0, Color.green, "1.");
                        this.colorScale.add(5.0, Color.green, "5.");
                        this.scaleDescription = new String("VT50 rms");
                        break block0;
                    }
                    case 7: {
                        this.colorScale = new ColorScale(-20.0, Color.blue, "0", 0.0, Color.green, "0.");
                        this.scaleDescription = new String("Trim offset");
                        break block0;
                    }
                    case 8: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 2.0, Color.green, "2.");
                        this.scaleDescription = new String("Trim offset rms");
                        break block0;
                    }
                    case 9: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 20.0, Color.green, "20.");
                        this.scaleDescription = new String("Trim step size");
                        break block0;
                    }
                    case 10: {
                        this.colorScale = new ColorScale(0.0, Color.blue, "0", 1.0, Color.green, "1.");
                        this.scaleDescription = new String("Trim step size rms");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            case 9: {
                switch (n2) {
                    case 0: {
                        this.colorScale = new ColorScale(0.0, Color.green, "Pass");
                        this.colorScale.add(1.0, Color.orange, "Problem");
                        this.colorScale.add(2.0, Color.red, "Fail");
                        this.scaleDescription = new String("Test Status");
                        break block0;
                    }
                    case 1: {
                        this.colorScale = new ColorScale(0.0, Color.green, "0", 15.0, Color.red, "15");
                        this.scaleDescription = new String("Number of defective channels");
                        break block0;
                    }
                    case 2: {
                        this.colorScale = new ColorScale(0.0, Color.red, "0", 10.0, Color.green, "10");
                        this.colorScale.add(12.0, Color.green, "12");
                        this.colorScale.add(20.0, Color.red, "20");
                        this.scaleDescription = new String("TimeWalk (ns)");
                        break block0;
                    }
                    case 3: {
                        this.colorScale = new ColorScale(20.0, Color.red, "20", 24.0, Color.green, "24");
                        this.colorScale.add(26.0, Color.green, "26");
                        this.colorScale.add(30.0, Color.red, "30");
                        this.scaleDescription = new String("TCal");
                        break block0;
                    }
                }
                this.colorScale = null;
                this.scaleDescription = null;
                break;
            }
            default: {
                this.colorScale = null;
                this.scaleDescription = null;
            }
        }
    }

    public void setColorScale(ColorScale colorScale) {
        this.colorScale = colorScale;
        this.repaint();
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.firstTime) {
            this.dim = this.getSize();
            this.area = new Rectangle(this.dim);
            this.maxWidth = (int)this.dim.getWidth();
            this.maxHeight = (int)this.dim.getHeight();
            this.firstTime = false;
            graphics2D.setFont(displayParams.displayTextFont);
            this.metrics = graphics2D.getFontMetrics();
            this.x = (int)((double)this.maxWidth / 2.0) - 125;
            this.y = (int)((double)this.maxHeight / 2.0) - 5;
        }
        graphics2D.setPaint(Color.white);
        graphics2D.fill(this.area);
        if (this.colorScale != null) {
            this.colorScale.drawColorScale(graphics2D, this.x, this.y);
        }
        if (this.scaleDescription != null) {
            graphics2D.setFont(displayParams.displayScaleFont);
            graphics2D.setPaint(displayParams.darkBlueColor);
            this.metrics = graphics2D.getFontMetrics();
            String string = "Scale: " + this.scaleDescription;
            int n = this.metrics.stringWidth(string);
            int n2 = this.metrics.getHeight();
            int n3 = (int)((double)this.maxWidth / 2.0) - n / 2;
            int n4 = (int)((double)this.maxHeight / 2.0) + 5 + n2 + 2;
            graphics2D.drawString(string, n3, n4);
        }
    }
}

