/*
 * Decompiled with CFR 0.152.
 */
package Sct.TestFramework;

import Sct.AbstractObjectManager;
import Sct.IStream;
import Sct.Name;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Serializable;
import Sct.Streamable;
import Sct.TestFramework.TestIStream;
import Sct.TestFramework.TestOStream;
import Sct.TestFramework.TestStreamData;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.StreamCorruptedException;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class TestObjectManager
extends AbstractObjectManager {
    private LinkedList list = new LinkedList();
    private String uniqueID;
    private String className;

    public Serializable readObject(String string) throws IOException {
        int n = string.indexOf(36);
        if (n == -1) {
            throw new FileNotFoundException("Invalid name - expected $ separator: " + string);
        }
        return this.readObject(string.substring(0, n), string.substring(n + 1));
    }

    public Serializable readObject(String string, String string2) throws IOException {
        if (!this.uniqueID.equals(string)) {
            throw new StreamCorruptedException("Incorrect uniqueID.\nWas asked for uniqueID: " + string + "\tClassName: " + string2 + "\nHave className: " + this.className + "\tuniqueID: " + this.uniqueID);
        }
        Serializable serializable = (Serializable)this.readObject(null, "PrimarySerializableObject", string2);
        if (!this.className.equals(serializable.getClassName())) {
            throw new InvalidClassException(string2, "Incorrect className.\nWas asked for uniqueID: " + string + "\tClassName: " + string2 + "\nHave className: " + this.className + "\tuniqueID: " + this.uniqueID + "\nGot class: " + serializable.getClass().getName());
        }
        return serializable;
    }

    public Streamable readObject(IStream iStream, String string) throws IOException {
        String string2 = this.readClassName(iStream);
        return this.readObject(iStream, string, string2);
    }

    public Streamable readObject(IStream iStream, String string, String string2) throws IOException {
        try {
            ClassData classData = (ClassData)this.list.removeFirst();
            if (!classData.name.equals(string)) {
                throw new StreamCorruptedException("Incorrect name.\nWas asked for className: " + string2 + "\tName: " + string + "\nHave className: " + classData.className + "\tName: " + classData.name);
            }
            TestIStream testIStream = new TestIStream(classData.data);
            Streamable streamable = this.createObject(testIStream, string2);
            if (!classData.className.equals(streamable.getClassName())) {
                throw new InvalidClassException(string2, "Incorrect className.\nWas asked for className: " + string2 + "\tName: " + string + "\nHave className: " + classData.className + "\tName: " + classData.name + "\nGot className: " + streamable.getClassName());
            }
            return streamable;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StreamCorruptedException("Tried to read in an object that wasn't written.\nName: " + string + "\nClassName: " + string2);
        }
    }

    public void writeObject(OStream oStream, String string, Streamable streamable, boolean bl) throws IOException {
        if (streamable == null) {
            throw new InvalidObjectException("Cannot write a null object.\nName: " + string);
        }
        if (bl) {
            this.writeClassName(oStream, streamable.getClassName());
        }
        TestOStream testOStream = new TestOStream();
        ClassData classData = new ClassData();
        classData.className = streamable.getClassName();
        classData.name = string;
        classData.data = testOStream.getData();
        this.list.add(classData);
        streamable.write((OStream)testOStream, (ObjectManager)this);
    }

    public Name writeObject(Serializable serializable) throws IOException {
        this.uniqueID = serializable.getUniqueID();
        this.className = serializable.getClassName();
        this.writeObject(null, "PrimarySerializableObject", (Streamable)serializable, false);
        return null;
    }

    public Streamable readStreamable() throws IOException {
        return this.readObject(null, "PrimaryStreamableObject", this.className);
    }

    public void writeStreamable(Streamable streamable) throws IOException {
        this.className = streamable.getClassName();
        this.writeObject(null, "PrimaryStreamableObject", streamable, false);
    }

    private class ClassData {
        String className;
        String name;
        TestStreamData data;

        private ClassData() {
        }
    }
}

