/*
 * Decompiled with CFR 0.152.
 */
package Sct.TestFramework;

import Sct.TestFramework.DataCompareFailure;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataCompare {
    public static boolean debug = false;
    public static DataCompareFailure lastFailure;
    protected List primitiveFields = new ArrayList();
    protected List objectFields = new ArrayList();
    protected List array = new ArrayList();
    protected Set ignore;

    public static boolean compare(Object object, Object object2) {
        return DataCompare.compare(object, object2, new HashSet());
    }

    public static boolean compare(Object object, Object object2, Set set) {
        if (debug) {
            System.out.println("Compare: " + object + " and " + object2);
        }
        if (object == null) {
            if (object2 == null) {
                return true;
            }
            lastFailure = new DataCompareFailure(object, object2, null, "One object is null and the other aint");
            return false;
        }
        if (object2 == null) {
            lastFailure = new DataCompareFailure(object, object2, null, "One object is null and the other aint");
            return false;
        }
        if (!object.getClass().equals(object2.getClass())) {
            lastFailure = new DataCompareFailure(object, object2, null, "Objects are of different classes");
            return false;
        }
        if (object.getClass().isArray()) {
            return DataCompare.compareArrays(object, object2, new HashSet());
        }
        DataCompare dataCompare = new DataCompare(object.getClass(), set);
        return dataCompare.compareRecurse(object, object2);
    }

    protected DataCompare(Class clazz, Set set) {
        this.ignore = set;
        this.getAllFields(clazz);
    }

    protected void getAllFields(Class clazz) {
        if (debug) {
            System.out.println("Getting All fields for " + clazz + "\n");
        }
        this.getFields(clazz);
        Class clazz2 = clazz;
        while ((clazz2 = clazz2.getSuperclass()) != null) {
            this.getFields(clazz2);
        }
        if (debug) {
            System.out.println("Got " + this.primitiveFields.size() + " primitive fields");
            System.out.println("Got " + this.objectFields.size() + " object fields");
            System.out.println("Got " + this.array.size() + " array fields");
            System.out.println("\n\n\n");
        }
    }

    protected void getFields(Class clazz) {
        if (debug) {
            System.out.println("Get fields for " + clazz);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            int n2;
            String string;
            if (!(Modifier.isStatic(fieldArray[n].getModifiers()) || this.ignore.contains(fieldArray[n]) || (string = fieldArray[n].getName()).substring((n2 = string.lastIndexOf(46)) + 1).startsWith("this$"))) {
                if (debug) {
                    System.out.println("Got field: " + fieldArray[n]);
                }
                fieldArray[n].setAccessible(true);
                Class<?> clazz2 = fieldArray[n].getType();
                if (clazz2.isArray()) {
                    this.array.add(fieldArray[n]);
                } else if (clazz2.isPrimitive()) {
                    this.primitiveFields.add(fieldArray[n]);
                } else {
                    this.objectFields.add(fieldArray[n]);
                }
            }
            ++n;
        }
    }

    protected boolean comparePrimitives(Object object, Object object2) {
        int n = 0;
        while (n < this.primitiveFields.size()) {
            try {
                Object object3 = ((Field)this.primitiveFields.get(n)).get(object);
                Object object4 = ((Field)this.primitiveFields.get(n)).get(object2);
                if (!object3.equals(object4)) {
                    lastFailure = new DataCompareFailure(object, object2, (Field)this.primitiveFields.get(n), "Primitives aren't equal " + object3 + " and " + object4);
                    return false;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Unable to access Field: " + this.primitiveFields.get(n));
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        return true;
    }

    protected boolean compareAllArrays(Object object, Object object2) {
        int n = 0;
        while (n < this.array.size()) {
            try {
                Object object3 = ((Field)this.array.get(n)).get(object);
                Object object4 = ((Field)this.array.get(n)).get(object2);
                if (!this.compareArrays(object3, object4)) {
                    DataCompare.lastFailure.o1 = object;
                    DataCompare.lastFailure.o2 = object2;
                    DataCompare.lastFailure.field = (Field)this.array.get(n);
                    return false;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Unable to access Field: " + this.array.get(n));
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        return true;
    }

    protected boolean compareArrays(Object object, Object object2) {
        return DataCompare.compareArrays(object, object2, this.ignore);
    }

    protected static boolean compareArrays(Object object, Object object2, Set set) {
        if (object == null) {
            if (object2 == null) {
                return true;
            }
            lastFailure = new DataCompareFailure(null, null, null, "One array is null, the other aint");
            return false;
        }
        if (object2 == null) {
            lastFailure = new DataCompareFailure(null, null, null, "One array is null, the other aint");
            return false;
        }
        int n = Array.getLength(object);
        boolean bl = object.getClass().getComponentType().isPrimitive();
        if (n != Array.getLength(object2)) {
            lastFailure = new DataCompareFailure(null, null, null, "Arrays different lengths: " + n + " and " + Array.getLength(object2));
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Object object3 = Array.get(object, n2);
            Object object4 = Array.get(object2, n2);
            if (bl) {
                if (!object3.equals(object4)) {
                    lastFailure = new DataCompareFailure(null, null, null, "Primitive element " + n2 + " not equal: " + object3 + " and " + object4);
                    return false;
                }
            } else if (!DataCompare.compare(object3, object4, set)) {
                DataCompareFailure dataCompareFailure = lastFailure;
                lastFailure = new DataCompareFailure(null, null, null, "Object element " + n2 + " not equal: " + object3 + " and " + object4);
                DataCompare.lastFailure.cause = dataCompareFailure;
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean compareRecurse(Object object, Object object2) {
        Object object3;
        if (!this.comparePrimitives(object, object2)) {
            DataCompareFailure dataCompareFailure = lastFailure;
            lastFailure = new DataCompareFailure(object, object2, null, "Primitives not equal");
            DataCompare.lastFailure.cause = dataCompareFailure;
            return false;
        }
        int n = 0;
        while (n < this.objectFields.size()) {
            try {
                object3 = ((Field)this.objectFields.get(n)).get(object);
                Object object4 = ((Field)this.objectFields.get(n)).get(object2);
                if (!DataCompare.compare(object3, object4, this.ignore)) {
                    DataCompareFailure dataCompareFailure = lastFailure;
                    lastFailure = new DataCompareFailure(object, object2, (Field)this.objectFields.get(n), "Objects not equal");
                    DataCompare.lastFailure.cause = dataCompareFailure;
                    return false;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Unable to access Field: " + this.objectFields.get(n));
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        if (!this.compareAllArrays(object, object2)) {
            object3 = lastFailure;
            lastFailure = new DataCompareFailure(object, object2, null, "Arrays not equal");
            DataCompare.lastFailure.cause = object3;
            return false;
        }
        return true;
    }
}

