/*
 * Decompiled with CFR 0.152.
 */
package Sct.File;

import Sct.File.IStreamFile;
import Sct.File.NameFile;
import Sct.File.OStreamFile;
import Sct.TestFramework.DataCompare;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class StreamTest
extends TestCase {
    IStreamFile in;
    OStreamFile out;

    public void testByte() throws IOException {
        byte by = 3;
        byte[] byArray = new byte[]{3, 6, 27, -57};
        this.startWrite("Byte");
        this.out.writeByte("Byte", by, true);
        this.out.writeByteArray("Bytes", byArray, true);
        this.endWrite("Byte");
        byte by2 = this.in.readByte("Byte");
        byte[] byArray2 = this.in.readByteArray("Bytes");
        Assert.assertEquals((byte)by, (byte)by2);
        boolean bl = DataCompare.compare(byArray, byArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testInt() throws IOException {
        int n = 5;
        int[] nArray = new int[]{3, 65, 7, 9};
        this.startWrite("Int");
        this.out.writeInt("Int", n, true);
        this.out.writeIntArray("Ints", nArray, true);
        this.endWrite("Int");
        int n2 = this.in.readInt("Int");
        int[] nArray2 = this.in.readIntArray("Ints");
        Assert.assertEquals((int)n, (int)n2);
        boolean bl = DataCompare.compare(nArray, nArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testLong() throws IOException {
        long l = 10L;
        long[] lArray = new long[]{302L, 565L, 77L, 899L};
        this.startWrite("Long");
        this.out.writeLong("Long", l, true);
        this.out.writeLongArray("Longs", lArray, true);
        this.endWrite("Long");
        long l2 = this.in.readLong("Long");
        long[] lArray2 = this.in.readLongArray("Long");
        Assert.assertEquals((long)l, (long)l2);
        boolean bl = DataCompare.compare(lArray, lArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testShort() throws IOException {
        short s = 1;
        short[] sArray = new short[]{32, 635, 427, 97};
        this.startWrite("Short");
        this.out.writeShort("Short", s, true);
        this.out.writeShortArray("Shorts", sArray, true);
        this.endWrite("Short");
        short s2 = this.in.readShort("Short");
        short[] sArray2 = this.in.readShortArray("Short");
        Assert.assertEquals((short)s, (short)s2);
        boolean bl = DataCompare.compare(sArray, sArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testFloat() throws IOException {
        float f = 55.7f;
        float[] fArray = new float[]{23.3f, 65.53f, 7.2f, 97.1f};
        this.startWrite("Float");
        this.out.writeFloat("Float", f);
        this.out.writeFloatArray("Floats", fArray);
        this.endWrite("Float");
        float f2 = this.in.readFloat("Float");
        float[] fArray2 = this.in.readFloatArray("Floats");
        Assert.assertEquals((double)f, (double)f2, (double)1.0E-10);
        boolean bl = DataCompare.compare(fArray, fArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testDouble() throws IOException {
        double d = 5.4;
        double[] dArray = new double[]{312.3, 6565.34, 7.45, 9.9};
        this.startWrite("Double");
        this.out.writeDouble("Double", d);
        this.out.writeDoubleArray("Doubles", dArray);
        this.endWrite("Double");
        double d2 = this.in.readDouble("Double");
        double[] dArray2 = this.in.readDoubleArray("Doubles");
        Assert.assertEquals((double)d, (double)d2, (double)1.0E-10);
        boolean bl = DataCompare.compare(dArray, dArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testString() throws IOException {
        String string = "Wibble";
        String[] stringArray = new String[]{"One", "65", "Hi", "Ya"};
        this.startWrite("String");
        this.out.writeString("String", string);
        this.out.writeStringArray("Strings", stringArray);
        this.endWrite("String");
        String string2 = this.in.readString("String");
        String[] stringArray2 = this.in.readStringArray("Strings");
        Assert.assertEquals((String)string, (String)string2);
        boolean bl = DataCompare.compare(stringArray, stringArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void testMixed() throws IOException {
        byte by = 2;
        float[] fArray = new float[]{1.2f, 4.5f, 5.6f};
        int[] nArray = new int[]{3, 7, 8, 2};
        String[] stringArray = new String[]{"One", "65", "Hi", "Ya"};
        double[] dArray = new double[]{2.6, 54.2, 65.78};
        long[] lArray = new long[]{324L, 55L, 76532L, 234L};
        short[] sArray = new short[]{2, 5, 7, 3};
        byte[] byArray = new byte[]{3, 6, 27, -57};
        String string = "Hi";
        byte by2 = 5;
        this.startWrite("Mixed");
        this.out.writeByte("Byte", by, true);
        this.out.writeFloatArray("Floats", fArray);
        this.out.writeIntArray("Ints", nArray, true);
        this.out.writeStringArray("Strings", stringArray);
        this.out.writeDoubleArray("Doubles", dArray);
        this.out.writeLongArray("Longs", lArray, true);
        this.out.writeShortArray("Shorts", sArray, true);
        this.out.writeByteArray("Bytes", byArray, true);
        this.out.writeString("String", string);
        this.out.writeByte("Byte", by2, true);
        this.endWrite("Mixed");
        byte by3 = this.in.readByte("Byte");
        float[] fArray2 = this.in.readFloatArray("Floats");
        int[] nArray2 = this.in.readIntArray("Ints");
        String[] stringArray2 = this.in.readStringArray("Strings");
        double[] dArray2 = this.in.readDoubleArray("Doubles");
        long[] lArray2 = this.in.readLongArray("Longs");
        short[] sArray2 = this.in.readShortArray("Shorts");
        byte[] byArray2 = this.in.readByteArray("Bytes");
        String string2 = this.in.readString("String");
        byte by4 = this.in.readByte("Byte");
        Assert.assertEquals((byte)by, (byte)by3);
        Assert.assertEquals((byte)by2, (byte)by4);
        Assert.assertEquals((String)string, (String)string2);
        boolean bl = DataCompare.compare(nArray, nArray2);
        if (!bl) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        if (!(bl = DataCompare.compare(fArray, fArray2))) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        if (!(bl = DataCompare.compare(dArray, dArray2))) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        if (!(bl = DataCompare.compare(lArray, lArray2))) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        if (!(bl = DataCompare.compare(sArray, sArray2))) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        if (!(bl = DataCompare.compare(byArray, byArray2))) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
        if (!(bl = DataCompare.compare(stringArray, stringArray2))) {
            Assert.fail((String)DataCompare.lastFailure.toString());
        }
    }

    public void tearDown() {
        String[] stringArray = new String[]{"Byte", "Int", "Short", "Long", "Double", "Float", "String", "Mixed"};
        int n = 0;
        while (n < stringArray.length) {
            new File("/tmp/DummyClass.DummyUniqueID" + stringArray[n]).delete();
            ++n;
        }
    }

    void startWrite(String string) throws IOException {
        this.out = new OStreamFile(new NameFile("/tmp/DummyClass.DummyUniqueID" + string));
    }

    void endWrite(String string) throws IOException {
        this.out.close();
        this.in = new IStreamFile(new NameFile("/tmp/DummyClass.DummyUniqueID" + string));
    }
}

