/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.scripting;

import GuiComponents.Console.JConsole;
import GuiComponents.scripting.DefaultInterpreter;
import GuiComponents.scripting.JythonInterpreter;
import GuiComponents.scripting.NameCompleter;
import GuiComponents.scripting.ScriptFactory;
import GuiComponents.scripting.SearchableObjectRegistry;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class JythonFactory
implements ScriptFactory {
    public JConsole createConsole() {
        return new JConsole();
    }

    public BSFEngine createEngine(BSFManager bSFManager) {
        try {
            return bSFManager.loadScriptingEngine("jython");
        }
        catch (BSFException bSFException) {
            System.err.println("Error loading jython scripting engine: " + (Object)((Object)bSFException));
            return null;
        }
    }

    public DefaultInterpreter createInterpreter(BSFEngine bSFEngine, JConsole jConsole, NameCompleter nameCompleter) {
        return new JythonInterpreter(jConsole, bSFEngine, nameCompleter);
    }

    public NameCompleter createNameCompleter(BSFEngine bSFEngine, SearchableObjectRegistry searchableObjectRegistry) {
        return searchableObjectRegistry;
    }
}

