/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.scripting;

import GuiComponents.Console.JConsole;
import GuiComponents.Console.NameCompletionListener;
import GuiComponents.scripting.NameCompleter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;

public class DefaultInterpreter
implements ActionListener,
NameCompletionListener {
    protected JConsole console;
    protected BSFEngine engine;
    protected NameCompleter completer;
    protected String defaultPath;
    protected String consoleCommandString = ".";
    protected char endCommandChar = (char)10;
    protected char lineContinueChar = (char)92;
    protected char blockStartChar = (char)123;
    protected char blockEndChar = (char)125;
    private int nestLevel = 0;
    private StringBuffer buffered = new StringBuffer();

    public DefaultInterpreter(JConsole jConsole, BSFEngine bSFEngine) {
        this(jConsole, bSFEngine, null);
    }

    public DefaultInterpreter(JConsole jConsole, BSFEngine bSFEngine, NameCompleter nameCompleter) {
        this.completer = nameCompleter;
        this.console = jConsole;
        jConsole.addActionListener(this);
        jConsole.addNameCompletionListener(this);
        jConsole.setPrompt("bsf> ");
        this.engine = bSFEngine;
        this.printStartMaterial();
        jConsole.initialize();
        this.defaultPath = System.getProperty("sct.daq.root") + File.pathSeparatorChar + "share" + File.pathSeparatorChar + "scripts" + File.pathSeparatorChar;
    }

    protected boolean printObject(Object object) {
        return object != null;
    }

    protected boolean startBlock(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        return stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == this.blockStartChar;
    }

    protected boolean endBlock(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        return stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == this.blockEndChar;
    }

    protected boolean continueLine(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        return stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == this.lineContinueChar;
    }

    public String toString() {
        return "DefaultInterpreter";
    }

    protected int nestLevel() {
        return this.nestLevel;
    }

    protected void incIndent() {
        ++this.nestLevel;
        this.setIndent(this.nestLevel);
    }

    protected void decIndent() {
        --this.nestLevel;
        if (this.nestLevel < 0) {
            this.nestLevel = 0;
        }
        this.setIndent(this.nestLevel);
    }

    protected void setIndent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "\t";
            ++n2;
        }
        this.console.setPostPrompt(string);
    }

    protected void printStartMaterial() {
        this.console.println("Welcome to the SCT scripting framework");
        this.console.println("Useful objects are:");
        this.console.println("sct: an interface to the sct_api and sct_analysis objects");
        this.console.println("sctPanel: the GUI");
        this.console.println("plotter: the histogram plotting widget - from JAS");
        this.console.println("There may also be some rudimentary tab completion");
        this.console.println("Finally, to load and execute a file, type .x <filename>");
        this.console.println("\n");
    }

    protected void printHelp() {
    }

    protected void consoleCommand(String string) {
        if (string.startsWith(".x")) {
            this.loadFile(string.substring(2).trim());
        }
    }

    protected void loadFile(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            if (string.indexOf(File.pathSeparatorChar) == -1) {
                this.loadFile(this.defaultPath + string);
            } else {
                this.console.println("Not a valid filename: " + string);
            }
            return;
        }
        try {
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            this.exec(new String(cArray), string, 0, 0);
        }
        catch (IOException iOException) {
            this.console.println("Error opening file: " + iOException.toString());
        }
    }

    public void completeName(String string) {
        String string2;
        String string3;
        if (this.completer == null) {
            return;
        }
        int n = (string = string.trim()).lastIndexOf(" ");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        List list = this.completer.completeName(string3, string2);
        if (list.size() == 0) {
            return;
        }
        String string4 = this.completeInline(string2, list);
        if (list.size() == 1) {
            string4 = string4.substring(string2.length());
            this.console.print(string4);
        } else {
            this.console.println();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.console.println(iterator.next());
            }
            this.console.resetCommandStart();
            this.console.print(string3 + " " + string4);
        }
    }

    protected String completeInline(String string, List list) {
        if (list.size() == 0) {
            return string;
        }
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        String string2 = string;
        boolean bl = true;
        int n = string.length() + 1;
        while (n <= ((String)list.get(0)).length()) {
            String string3 = ((String)list.get(0)).substring(0, n);
            int n2 = 1;
            while (n2 < list.size()) {
                bl &= ((String)list.get(n2)).startsWith(string3);
                ++n2;
            }
            if (!bl) break;
            ++n;
            string2 = string3;
        }
        return string2;
    }

    public void exec(String string, String string2, int n, int n2) {
        try {
            Object object = null;
            this.engine.exec(string2, n, n2, (Object)string);
            if (this.printObject(object)) {
                this.console.println(object.toString());
            }
        }
        catch (BSFException bSFException) {
            this.console.println(bSFException.toString());
            System.out.println(bSFException.getMessage());
            bSFException.printStackTrace();
        }
    }

    public void exec(String string) {
        this.exec(string, this.toString(), -1, -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith(this.consoleCommandString)) {
            this.consoleCommand(string);
            return;
        }
        if (this.continueLine(string)) {
            this.buffered.append(string);
            return;
        }
        if (this.startBlock(string)) {
            this.buffered.append(string);
            this.incIndent();
            return;
        }
        if (this.endBlock(string)) {
            this.decIndent();
        }
        if (this.nestLevel > 0) {
            this.buffered.append(string);
            return;
        }
        string = this.buffered + string;
        this.buffered.delete(0, this.buffered.length());
        this.exec(string);
    }
}

