/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.System;

import GuiComponents.System.SystemInterface;
import is.AnyInfo;
import is.InfoList;
import is.InfoListener;
import is.InfoNotFoundException;
import is.InvalidExpressionException;
import is.Repository;
import is.RepositoryNotFoundException;
import is.SctRepository;
import is.ServerIterator;
import is.SubscriptionNotFoundException;

public class ISInterface {
    private static ISInterface instance = new ISInterface();
    private Repository r;
    private SystemInterface si = SystemInterface.getInstance();

    public static ISInterface getInstance() {
        return instance;
    }

    public void refresh() {
        this.r = new SctRepository(this.si.getPartition());
    }

    public String[] getISServers() {
        ServerIterator serverIterator = new ServerIterator(this.si.getPartition());
        String[] stringArray = new String[serverIterator.entries()];
        int n = 0;
        while (n < serverIterator.entries()) {
            stringArray[n] = serverIterator.nextServerName();
            ++n;
        }
        return stringArray;
    }

    public String[] getISObjects(String string) {
        InfoList infoList = new InfoList(this.si.getPartition(), string);
        String[] stringArray = new String[infoList.getSize()];
        int n = 0;
        while (n < infoList.getSize()) {
            AnyInfo anyInfo = infoList.getInfo(n);
            stringArray[n] = new String(anyInfo.getName());
            ++n;
        }
        return stringArray;
    }

    public int getNumberOfISObjects(String string, String string2) {
        if (this.si.getPartition() == null) {
            return 0;
        }
        InfoList infoList = new InfoList(this.si.getPartition(), string, string2);
        return infoList.getSize();
    }

    public String[] getISObjects(String string, String string2) {
        if (this.si.getPartition() == null) {
            return new String[0];
        }
        InfoList infoList = new InfoList(this.si.getPartition(), string, string2);
        String[] stringArray = new String[infoList.getSize()];
        int n = 0;
        while (n < infoList.getSize()) {
            AnyInfo anyInfo = infoList.getInfo(n);
            stringArray[n] = new String(anyInfo.getName());
            ++n;
        }
        return stringArray;
    }

    public Repository getRepository() {
        return this.r;
    }

    public String subscribe(String string, String string2, boolean bl, InfoListener infoListener) {
        if (this.r == null) {
            return "Null Repository - probably some sort of net error.";
        }
        try {
            this.r.subscribe(string, string2, bl, infoListener);
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            return "Internal error while subscribing to server " + string + " for " + string2 + " : " + (Object)((Object)repositoryNotFoundException);
        }
        catch (InvalidExpressionException invalidExpressionException) {
            return "Internal error while subscribing to server " + string + " for " + string2 + " : " + (Object)((Object)invalidExpressionException);
        }
        return "Subscribe to " + string + " successful";
    }

    public String subscribe(String string, InfoListener infoListener) {
        return this.subscribe(string, ".*", true, infoListener);
    }

    public String unsubscribe(String string) {
        return this.unsubscribe(string, ".*");
    }

    public String unsubscribe(String string, String string2) {
        try {
            this.r.unsubscribe(string, string2, true);
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            return "Oops, internal error while unsubscribing: " + (Object)((Object)repositoryNotFoundException);
        }
        catch (SubscriptionNotFoundException subscriptionNotFoundException) {
            return "Ooop, internal error - subscription not found: " + (Object)((Object)subscriptionNotFoundException);
        }
        return "Unsubscribe from " + string + " for " + string2 + " successful";
    }

    public String remove(String string) {
        try {
            this.r.remove(string);
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            return "Oops, internal error while unsubscribing: " + (Object)((Object)repositoryNotFoundException);
        }
        catch (InfoNotFoundException infoNotFoundException) {
            return "Object not found in repository: " + (Object)((Object)infoNotFoundException);
        }
        return "Object" + string + " successfully removed";
    }

    private ISInterface() {
        this.refresh();
    }
}

