/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.Inspector;

import GuiComponents.Inspector.ArrayRep;
import GuiComponents.Inspector.NullRep;
import GuiComponents.Inspector.PrimitiveRep;
import GuiComponents.Inspector.Rep;
import Sct.IStream;
import Sct.Name;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Serializable;
import Sct.Streamable;
import java.io.IOException;
import java.util.ArrayList;

class StreamableRep
implements Rep,
OStream,
ObjectManager {
    protected ArrayList streamables = new ArrayList();
    protected ArrayList primitives = new ArrayList();
    protected String className;
    protected String name;
    private Streamable object;
    private boolean written = false;

    StreamableRep(String string, Serializable serializable) {
        this.className = serializable.getClassName();
        this.object = serializable;
        this.name = string;
        this.writeObject(serializable);
        this.written = true;
    }

    StreamableRep(String string, Streamable streamable) {
        this.className = streamable.getClassName();
        this.object = streamable;
        this.name = string;
        if (streamable instanceof Serializable) {
            this.name = this.name + " (" + streamable.getClassName() + "." + ((Serializable)streamable).getUniqueID() + ")";
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getValue() {
        return "";
    }

    int getChildCount() {
        if (!this.written) {
            this.writeChildren();
        }
        return this.streamables.size() + this.primitives.size();
    }

    Rep getChild(int n) {
        if (n >= this.streamables.size()) {
            return (Rep)this.primitives.get(n - this.streamables.size());
        }
        return (Rep)this.streamables.get(n);
    }

    private void writeChildren() {
        if (this.written) {
            return;
        }
        try {
            this.object.write((OStream)this, (ObjectManager)this);
            this.written = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Name writeObject(Serializable serializable) {
        try {
            serializable.write((OStream)this, (ObjectManager)this);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return null;
    }

    public void writeObject(OStream oStream, String string, Streamable streamable, boolean bl) {
        if (streamable == null) {
            this.primitives.add(new NullRep(string));
        } else {
            StreamableRep streamableRep = new StreamableRep(string, streamable);
            this.streamables.add(streamableRep);
        }
    }

    public void writeBoolean(String string, boolean bl) {
        this.primitives.add(new PrimitiveRep(string, new Boolean(bl)));
    }

    public void writeBooleanArray(String string, boolean[] blArray) {
        this.primitives.add(new ArrayRep(string, blArray));
    }

    public void writeByte(String string, byte by, boolean bl) {
        this.primitives.add(new PrimitiveRep(string, new Byte(by)));
    }

    public void writeByteArray(String string, byte[] byArray, boolean bl) {
        this.primitives.add(new ArrayRep(string, byArray));
    }

    public void writeDouble(String string, double d) {
        this.primitives.add(new PrimitiveRep(string, new Double(d)));
    }

    public void writeDoubleArray(String string, double[] dArray) {
        this.primitives.add(new ArrayRep(string, dArray));
    }

    public void writeFloat(String string, float f) {
        this.primitives.add(new PrimitiveRep(string, new Float(f)));
    }

    public void writeFloatArray(String string, float[] fArray) {
        this.primitives.add(new ArrayRep(string, fArray));
    }

    public void writeInt(String string, int n, boolean bl) {
        this.primitives.add(new PrimitiveRep(string, new Integer(n)));
    }

    public void writeIntArray(String string, int[] nArray, boolean bl) {
        this.primitives.add(new ArrayRep(string, nArray));
    }

    public void writeShort(String string, short s, boolean bl) {
        this.primitives.add(new PrimitiveRep(string, new Short(s)));
    }

    public void writeShortArray(String string, short[] sArray, boolean bl) {
        this.primitives.add(new ArrayRep(string, sArray));
    }

    public void writeString(String string, String string2) {
        this.primitives.add(new PrimitiveRep(string, string2));
    }

    public void writeStringArray(String string, String[] stringArray) {
        this.primitives.add(new ArrayRep(string, stringArray));
    }

    public Serializable readObject(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestGUI.Inspector.ObjectManager only supports write operations");
    }

    public Streamable readObject(IStream iStream, String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestGUI.Inspector.ObjectManager only supports write operations");
    }

    public Serializable readObject(String string, String string2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestGUI.Inspector.ObjectManager only supports write operations");
    }

    public Streamable readObject(IStream iStream, String string, String string2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestGUI.Inspector.ObjectManager only supports write operations");
    }

    public void writeLong(String string, long l, boolean bl) throws IOException {
    }

    public void writeLongArray(String string, long[] lArray, boolean bl) throws IOException {
    }
}

