/*
 * Decompiled with CFR 0.152.
 */
package GuiComponents.Console;

import GuiComponents.Console.JConsole;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ExternalProcess
extends JFrame
implements ActionListener {
    protected JConsole console;
    protected Process process;
    private StreamThread stdout;
    private StreamThread stderr;
    private Writer stdin;
    private JButton bClose;

    public ExternalProcess(String string) throws IOException {
        this.initComponents();
        this.myInit(string);
        this.setTitle(string);
        this.setSize(800, 500);
        this.show();
    }

    private void myInit(String string) throws IOException {
        this.console = new JConsole();
        this.console.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.console, gridBagConstraints);
        this.process = Runtime.getRuntime().exec(string);
        this.stdout = new StreamThread(this.process.getInputStream());
        this.stderr = new StreamThread(this.process.getErrorStream());
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.stdout.start();
        this.stderr.start();
    }

    private void initComponents() {
        this.bClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExternalProcess.this.exitForm(windowEvent);
            }
        });
        this.bClose.setText("Close");
        this.bClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalProcess.this.bCloseActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.bClose, gridBagConstraints);
        this.pack();
    }

    private void bCloseActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.close();
    }

    public void close() {
        this.process.destroy();
        this.stdout.stop = true;
        this.stderr.stop = true;
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            System.out.println("Writing: " + string);
            this.stdin.write(string);
            System.out.println("Done");
        }
        catch (IOException iOException) {}
    }

    class StreamThread
    extends Thread {
        InputStream inputStream;
        volatile boolean stop = false;

        StreamThread(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void run() {
            block9: {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                    StringBuffer stringBuffer = new StringBuffer(2000);
                    while (!this.stop) {
                        stringBuffer.setLength(0);
                        int n = 0;
                        while (bufferedReader.ready() && n < 100) {
                            stringBuffer.append(bufferedReader.readLine()).append("\n");
                            ++n;
                        }
                        if (n == 0) {
                            String string = bufferedReader.readLine();
                            if (string == null) break;
                            stringBuffer.append(string).append("\n");
                        }
                        if (ExternalProcess.this.console != null) {
                            ExternalProcess.this.console.print(stringBuffer.toString());
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (ExternalProcess.this.console != null) {
                        ExternalProcess.this.console.println(exception.getMessage());
                        break block9;
                    }
                    System.out.println(exception.getMessage());
                }
            }
        }
    }
}

