/*
 * Decompiled with CFR 0.152.
 */
package Sct;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
extends Properties {
    public static final Version instance = new Version();
    private String version;
    private double versionNumber;
    private int majorVersion;
    private int minorVersion;

    public String getVersionName() {
        return this.version;
    }

    public double getVersion() {
        return this.versionNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getBuildSystem() {
        return this.getProperty("Sct.BuildSystem", "No information available");
    }

    public String getBuildHost() {
        return this.getProperty("Sct.BuildHost", "No information available");
    }

    public String getBuildDate() {
        return this.getProperty("Sct.BuildDate", "No information available");
    }

    public String getCmtConfig() {
        return this.getProperty("Sct.CmtConfig", "No information available");
    }

    public String getOnlineVersion() {
        return this.getProperty("Sct.OnlineVersion", "No information available");
    }

    public String getRootVersion() {
        return this.getProperty("Sct.RootVersion", "No information available");
    }

    public String getGccVersion() {
        return this.getProperty("Sct.GccVersion", "No information available");
    }

    public String getRodDaqVersion() {
        return this.getProperty("Sct.RodDaqVersion", "No information available");
    }

    public String getDataFlowVersion() {
        return this.getProperty("Sct.DataFlowVersion", "No information available");
    }

    public String getAllInformation() {
        String string = "System version: " + this.getVersion() + " named " + this.getVersionName();
        string = string + "\n\nBuild Information\nBuild System: " + this.getBuildSystem() + "\nBuild Host: " + this.getBuildHost();
        string = string + "\nBuild Date: " + this.getBuildDate() + "\nCmtConfig: " + this.getCmtConfig() + "\nRodDaq Version: ";
        string = string + this.getRodDaqVersion() + "\nDataFlow Version: " + this.getDataFlowVersion() + "\nOnline Version: ";
        string = string + this.getOnlineVersion() + "\nRoot Version: " + this.getRootVersion() + "\nGcc Version: " + this.getGccVersion();
        return string;
    }

    private Version() {
        block5: {
            Object object;
            this.versionNumber = 0.0;
            this.majorVersion = -1;
            this.minorVersion = -1;
            String string = this.getProperty("Sct.TagName");
            this.version = string != null && string.length() > 7 ? string.substring(7, string.length() - 1) : "SctRodDaq_2_01_Exp";
            try {
                System.out.println(this.version);
                object = Pattern.compile("\\p{Alpha}+_(\\d+_\\d+).*").matcher(this.version);
                if (((Matcher)object).matches()) {
                    String string2 = ((Matcher)object).group(1);
                    string2 = string2.replace('_', '.');
                    this.versionNumber = Double.parseDouble(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.majorVersion = (int)Math.floor(this.versionNumber);
            this.minorVersion = (int)Math.floor((this.versionNumber - (double)this.majorVersion) * 101.0);
            object = this.getClass().getClassLoader().getResourceAsStream("Sct/version.properties");
            if (object == null) break block5;
            try {
                this.load((InputStream)object);
            }
            catch (IOException iOException) {}
        }
    }
}

