/*
 * Decompiled with CFR 0.152.
 */
package Sct.File;

import Sct.Name;
import Sct.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameFile
extends Name {
    private static Pattern fileNamePattern;
    private static String defaultPath;
    private String path;
    private String fileName;

    public NameFile(Serializable serializable) {
        this(serializable.getClassName(), serializable.getUniqueID());
    }

    public NameFile(String string) throws IllegalArgumentException {
        super(string);
        this.fileName = string;
    }

    public NameFile(String string, String string2) {
        super(string, string2);
        this.path = NameFile.getDefaultPath();
        this.construct();
    }

    public String getName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public static void reset() {
        fileNamePattern = null;
        defaultPath = null;
    }

    protected void parse(String string) throws IllegalArgumentException {
        try {
            Matcher matcher = NameFile.getPattern().matcher(string);
            matcher.matches();
            this.path = matcher.group(1);
            this.className = Name.convertFromC(matcher.group(2));
            this.uniqueID = matcher.group(3);
        }
        catch (IllegalStateException illegalStateException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("NameFile cannot parse File name - doesn't match expected format: " + string);
            illegalArgumentException.initCause(illegalStateException);
            throw illegalArgumentException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IllegalStateException illegalStateException = new IllegalStateException("NameFile internal error - regex does have expected number of groups.  Name: " + string);
            illegalStateException.initCause(indexOutOfBoundsException);
            throw illegalStateException;
        }
    }

    private static String getDefaultPath() {
        if (defaultPath == null) {
            defaultPath = System.getProperty("Sct.Scratch.Dir", "/tmp");
        }
        return defaultPath;
    }

    private void construct() {
        this.fileName = this.getPath() + "/" + Name.convertToC(this.className) + "." + this.uniqueID;
    }

    private static Pattern getPattern() {
        if (fileNamePattern == null) {
            fileNamePattern = Pattern.compile("(.*)/([\\S&&[^.]]*)\\.(.*)");
        }
        return fileNamePattern;
    }
}

