/*
 * Decompiled with CFR 0.152.
 */
package Sct.File;

import Sct.File.NameFile;
import Sct.IStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class IStreamFile
implements IStream {
    private ByteBuffer buffer;

    public IStreamFile(NameFile nameFile) throws IOException {
        FileChannel fileChannel = new FileInputStream(nameFile.getName()).getChannel();
        this.buffer = ByteBuffer.allocate((int)fileChannel.size());
        fileChannel.read(this.buffer);
        fileChannel.close();
        this.buffer.position(0);
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public IStreamFile(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
        this.buffer.position(0);
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public boolean readBoolean(String string) throws IOException {
        return this.buffer.get() != 0;
    }

    public boolean[] readBooleanArray(String string) throws IOException {
        int n = this.buffer.getInt();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = this.buffer.get() != 0;
            ++n2;
        }
        return blArray;
    }

    public byte readByte(String string) throws IOException {
        return this.buffer.get();
    }

    public byte[] readByteArray(String string) throws IOException {
        int n = this.buffer.getInt();
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        return byArray;
    }

    public double readDouble(String string) throws IOException {
        return this.buffer.getDouble();
    }

    public double[] readDoubleArray(String string) throws IOException {
        int n = this.buffer.getInt();
        double[] dArray = new double[n];
        this.buffer.position(this.buffer.position() + this.buffer.asDoubleBuffer().get(dArray).position() * 8);
        return dArray;
    }

    public float readFloat(String string) throws IOException {
        return this.buffer.getFloat();
    }

    public float[] readFloatArray(String string) throws IOException {
        int n = this.buffer.getInt();
        float[] fArray = new float[n];
        this.buffer.position(this.buffer.position() + this.buffer.asFloatBuffer().get(fArray).position() * 4);
        return fArray;
    }

    public int readInt(String string) throws IOException {
        return this.buffer.getInt();
    }

    public int[] readIntArray(String string) throws IOException {
        int n = this.buffer.getInt();
        int[] nArray = new int[n];
        this.buffer.position(this.buffer.position() + this.buffer.asIntBuffer().get(nArray).position() * 4);
        return nArray;
    }

    public long readLong(String string) throws IOException {
        return this.buffer.getLong();
    }

    public long[] readLongArray(String string) throws IOException {
        int n = this.buffer.getInt();
        long[] lArray = new long[n];
        this.buffer.position(this.buffer.position() + this.buffer.asLongBuffer().get(lArray).position() * 8);
        return lArray;
    }

    public short readShort(String string) throws IOException {
        return this.buffer.getShort();
    }

    public short[] readShortArray(String string) throws IOException {
        int n = this.buffer.getInt();
        short[] sArray = new short[n];
        this.buffer.position(this.buffer.position() + this.buffer.asShortBuffer().get(sArray).position() * 2);
        return sArray;
    }

    public String readString(String string) throws IOException {
        int n = this.buffer.getInt();
        byte[] byArray = new byte[n - 1];
        this.buffer.get(byArray);
        this.buffer.get();
        return new String(byArray);
    }

    public String[] readStringArray(String string) throws IOException {
        int n = this.buffer.getInt();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString("");
            ++n2;
        }
        return stringArray;
    }

    private void align(Buffer buffer, Buffer buffer2) {
        buffer2.position(buffer.position());
    }
}

