/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.freehep.util.io.ByteOrderOutputStream;

public class ByteCountOutputStream
extends ByteOrderOutputStream {
    private int currentBuffer = -1;
    private List bufferList = new LinkedList();

    public ByteCountOutputStream(OutputStream out, boolean littleEndian) {
        super(out, littleEndian);
    }

    public void write(int b) throws IOException {
        if (this.currentBuffer == -1) {
            super.write(b);
            return;
        }
        Buffer buffer = (Buffer)this.bufferList.get(this.currentBuffer);
        buffer.add((byte)b);
    }

    public void pushBuffer() throws IOException {
        this.append();
        this.bufferList.add(new Buffer());
        ++this.currentBuffer;
    }

    public int popBuffer() throws IOException {
        if (this.currentBuffer >= 0) {
            this.append();
            int len = this.getBufferLength();
            --this.currentBuffer;
            return len;
        }
        return -1;
    }

    public int getBufferLength() {
        return this.currentBuffer >= 0 ? ((Buffer)this.bufferList.get(this.currentBuffer)).getLength() : -1;
    }

    public int getLength() {
        int length = 0;
        for (int i = 0; i < this.bufferList.size(); ++i) {
            length += ((Buffer)this.bufferList.get(i)).getLength();
        }
        return this.currentBuffer >= 0 ? length : -1;
    }

    public void append() throws IOException {
        super.byteAlign();
        if (this.currentBuffer + 1 >= this.bufferList.size()) {
            return;
        }
        Buffer append = (Buffer)this.bufferList.get(this.currentBuffer + 1);
        if (append.getLength() > 0) {
            if (this.currentBuffer >= 0) {
                ((Buffer)this.bufferList.get(this.currentBuffer)).add(append);
            } else {
                super.write(append.getBytes(), 0, append.getLength());
            }
        }
        this.bufferList.remove(this.currentBuffer + 1);
    }

    public void close() throws IOException {
        this.append();
        super.close();
    }

    static class Buffer {
        byte[] buffer = new byte[256];
        int len = 0;

        Buffer() {
        }

        void add(byte b) {
            if (this.len + 1 > this.buffer.length) {
                byte[] newBuffer = new byte[this.buffer.length << 1];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
                this.buffer = newBuffer;
            }
            this.buffer[this.len] = b;
            ++this.len;
        }

        void add(Buffer append) {
            int appendLength = append.getLength();
            int needed = this.len + appendLength;
            if (needed > this.buffer.length) {
                byte[] newBuffer = new byte[needed];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
                this.buffer = newBuffer;
            }
            System.arraycopy(append.getBytes(), 0, this.buffer, this.len, appendLength);
            this.len += appendLength;
        }

        int getLength() {
            return this.len;
        }

        byte[] getBytes() {
            return this.buffer;
        }
    }
}

