/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnLong
extends TupleColumn {
    TupleColumnLong(String name, Value value, int length, int maxLength) {
        super(name, Long.TYPE, value, length, maxLength);
    }

    protected void createArray(int size) {
        long[] data = new long[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getLong();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        long[] data = (long[])this.currentArray;
        value.set(data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            long[] data = (long[])this.currentArray;
            data[index % this.arraySize] = value.getLong();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnLong");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getLong());
        }
    }
}

